/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPreferencesImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGPreferencesImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPreferences;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Preferences</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPreferencesImpl#getBrowserCookieName <em>Browser Cookie Name</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPreferencesImpl#isShow <em>Show</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPreferencesImpl#getStoredPreferences <em>Stored Preferences</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPreferencesImpl#getUpdatedPreferencesVariable <em>Updated Preferences Variable</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGPreferencesImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGPreferencesImpl extends SVGInputBase implements Preferences {
	/**
	 * The default value of the '{@link #getBrowserCookieName() <em>Browser Cookie Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBrowserCookieName()
	 * @generated
	 * @ordered
	 */
	protected static final String BROWSER_COOKIE_NAME_EDEFAULT = null;


	/**
	 * The default value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_EDEFAULT = false;

	/**
	 * This is true if the Show attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showESet = false;

	/**
	 * The default value of the '{@link #getStoredPreferences() <em>Stored Preferences</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStoredPreferences()
	 * @generated
	 * @ordered
	 */
	protected static final String STORED_PREFERENCES_EDEFAULT = null;


	/**
	 * The default value of the '{@link #getUpdatedPreferencesVariable() <em>Updated Preferences Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUpdatedPreferencesVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String UPDATED_PREFERENCES_VARIABLE_EDEFAULT = null;


	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;

	protected DPreferences pref;
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGPreferencesImpl() {
		super();
	}

	public SVGPreferencesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGPreferencesImpl(Chart chart, DGraphic dgraphic, DPreferences pref) {
		_chart = chart;
		_dgraphic = dgraphic;
	    if (pref == null){
	    	this.pref = new DPreferences();
	    	this.pref.setShow(SHOW_EDEFAULT);
	    }
	    else{
	    	this.pref = pref;
	    	showESet = true;
	    }
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBrowserCookieName() {
		return pref.getBrowserCookieName();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBrowserCookieName(String newBrowserCookieName) {
		pref.setBrowserCookieName(newBrowserCookieName);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShow() {
		if (pref.isShow() == false)
			showESet = true;
		return pref.isShow();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShow(boolean newShow) {
		pref.setShow(newShow);
		showESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShow() {
		showESet = false;
		pref.setShow(SHOW_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShow() {
		if (showESet == false) {
			isShow();
		}
		return showESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getStoredPreferences() {
		return pref.getStoredPreferences();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStoredPreferences(String newStoredPreferences) {
		pref.setStoredPreferences(newStoredPreferences);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUpdatedPreferencesVariable() {
		return pref.getUpdatedPreferencesVariable();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUpdatedPreferencesVariable(String newUpdatedPreferencesVariable) {
		pref.setUpdatedPreferencesVariable(newUpdatedPreferencesVariable);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUrl() {
		return pref.getUrl();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUrl(String newUrl) {
		pref.setUrl(newUrl);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null && _dgraphic != null) {
			if (pref.getTooltip() != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, pref.getTooltip());					
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		pref.setTooltip(tooltip.getLabel());
	}

	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		pref.setTooltip(tooltip.getLabel());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (browserCookieName: ");
		result.append(pref.getBrowserCookieName());
		result.append(", show: ");
		if (showESet) result.append(pref.isShow()); else result.append("<unset>");
		result.append(", storedPreferences: ");
		result.append(pref.getStoredPreferences());
		result.append(", updatedPreferencesVariable: ");
		result.append(pref.getUpdatedPreferencesVariable());
		result.append(", url: ");
		result.append(pref.getUrl());
		result.append(')');
		return result.toString();
	}

	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DPreferences.class) == null)
			_dgraphic.addChild(pref);
	}
} //PreferencesImpl
