/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGScriptsImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGScriptsImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DInclude;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Scripts</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGScriptsImpl#getEcmascript <em>Ecmascript</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGScriptsImpl extends SVGInputBase implements Scripts {
	/**
	 * The default value of the '{@link #getSvgDocumentVariable() <em>Svg Document Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgDocumentVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String SVG_DOCUMENT_VARIABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSvgDocumentVariable() <em>Svg Document Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgDocumentVariable()
	 * @generated
	 * @ordered
	 */
	protected String svgDocumentVariable = SVG_DOCUMENT_VARIABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSvgWindowVariable() <em>Svg Window Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgWindowVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String SVG_WINDOW_VARIABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSvgWindowVariable() <em>Svg Window Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgWindowVariable()
	 * @generated
	 * @ordered
	 */
	protected String svgWindowVariable = SVG_WINDOW_VARIABLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEcmascript() <em>Ecmascript</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEcmascript()
	 * @generated
	 * @ordered
	 */
	protected List ecmascript = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGScriptsImpl() {
		super();
	}

	public SVGScriptsImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGScriptsImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSvgDocumentVariable() {
		if (svgDocumentVariable == SVG_DOCUMENT_VARIABLE_EDEFAULT) {
			if (_dgraphic != null) {
				svgDocumentVariable = _dgraphic.getProperties().get("svgDocumentVariable", SVG_DOCUMENT_VARIABLE_EDEFAULT);
			}
		}
		return svgDocumentVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSvgDocumentVariable(String newSvgDocumentVariable) {
		svgDocumentVariable = newSvgDocumentVariable;
		
		if (_dgraphic != null) {
			_dgraphic.getProperties().store("svgDocumentVariable", newSvgDocumentVariable);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSvgWindowVariable() {
		if (svgWindowVariable == SVG_WINDOW_VARIABLE_EDEFAULT) {
			if (_dgraphic != null) {
				svgDocumentVariable = _dgraphic.getProperties().get("svgWindowVariable", SVG_WINDOW_VARIABLE_EDEFAULT);
			}
		}
		return svgWindowVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSvgWindowVariable(String newSvgWindowVariable) {
		svgWindowVariable = newSvgWindowVariable;
		
		if (_dgraphic != null) {
			_dgraphic.getProperties().store("svgWindowVariable", newSvgWindowVariable);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEcmascript() {
		if (ecmascript == null) {
			ecmascript = new ArrayList();
			if (_dgraphic != null) {
				List dgraphicList = (List)_dgraphic.getChildrenOfClass(DInclude.class);
				if (dgraphicList != null){
				for (int x = 0; x < dgraphicList.size(); x++){
					Object item = dgraphicList.get(x);
					if( item instanceof DInclude){
						ecmascript.add(new SVGEcmascriptImpl(_chart, _dgraphic, (DInclude)item));
					}
				}				
				}
			}
		}
		return ecmascript;
	}

	// function for assignment
	public void setEcmascript(List newEcmascript) {
		ecmascript = newEcmascript;
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (svgDocumentVariable: ");
		result.append(svgDocumentVariable);
		result.append(", svgWindowVariable: ");
		result.append(svgWindowVariable);
		result.append(')');
		return result.toString();
	}

} //ScriptsImpl
