/* ***********************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGShapeImpl.java,v 1.3 2006/02/14 21:23:33 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shape;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shape</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapeImpl#getShapeId <em>Shape Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapeImpl#getDataSetId <em>Data Set Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGShapeImpl extends SVGInputBase implements Shape {
	/**
	 * The default value of the '{@link #getShapeId() <em>Shape Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShapeId()
	 * @generated
	 * @ordered
	 */
	protected static final String SHAPE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDataSetId() <em>Data Set Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetId()
	 * @generated
	 * @ordered
	 */
	protected Object dataSetId = SHAPE_ID_EDEFAULT;
	
	protected DCurve curve = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SVGShapeImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null);
	}

	public SVGShapeImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.curve = curve;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getShapeId() {
		Object id = curve.getProperties().get(DCurve.P_SYMBOL, SHAPE_ID_EDEFAULT);
		if (id instanceof String)  return (String)id;
		return SHAPE_ID_EDEFAULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShapeId(String newShapeId) {
		curve.getProperties().store(DCurve.P_SYMBOL, newShapeId);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDataSetId() {
		if (dataSetId == null && _dgraphic != null) {
			// Search for the reference to DataSet
			String refId =  Integer.toString(EventTools.getHashCode(curve));
			Data data = _chart.getData();
			DataSets dataSets = data.getDataSets();
			List dataSetList = dataSets.getDataSet();
			for (int i = 0; i < dataSetList.size(); ++i) {
				DataSet dataSet = (DataSet) dataSetList.get(i);
				if ((dataSet.getId() != null) && (dataSet.getId().equals(refId))) {
					dataSetId = dataSet;
					break;
				}
			}
//			dataSetId = "" + curve.hashCode();
		}
		return dataSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetId(Object newDataSetId) {
		//should not change the id
	}

	// function for assignment
	public void assignDataSetId(Object newDataSetId) {
		try {
			DataSet dataSet = (DataSet) newDataSetId;
			String dataSetIdStr = dataSet.getId();
			if (curve != null) 
				curve.getProperties().store(DCurve.P_ID, dataSetIdStr);
		}catch (ClassCastException e) {
		}
	}
	
	// function for assignment
	public String fetchDataSetId() {
		return curve.getProperties().get(DCurve.P_ID).toString();
	}
	
	// function for assignment
	public void setDCurve(DCurve dcurve) {
		this.curve = dcurve;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (shapeId: ");
		result.append(getShapeId());
		result.append(')');
		return result.toString();
	}

} //ShapeImpl
