/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGShapesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGShapesImpl.java,v 1.2 2005/05/24 13:28:37 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IConstants;

import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DShapes;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shapes</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapesImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGShapesImpl#getVisibility <em>Visibility</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGShapesImpl extends SVGInputBase implements Shapes {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected String location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final String VISIBILITY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected String visibility = VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getShape() <em>Shape</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShape()
	 * @generated
	 * @ordered	 */
	protected List shape = null;
    protected DShapes s;

	public SVGShapesImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGShapesImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	    s = (DShapes)_dgraphic.getChildOfClass(DShapes.class);
	    if (s == null) s = new DShapes();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getShape() {
		if (shape == null) {
			if (_dgraphic != null) {
				shape = new ArrayList();
				for (IDItem item = _dgraphic.getFirstChild(); item!=null;item=item.getNext()) {
					if (item instanceof DCurve)
					shape.add(new SVGShapeImpl(_chart, _dgraphic, (DCurve)item));
				}
			} else {
				shape = new ArrayList();
			}
		}
		return shape;
	}

	// function for assignment
	public void setShape(List newShape) {
		shape = newShape;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", visibility: ");
		result.append(visibility);
		result.append(')');
		return result.toString();
	}

	/**
	 * @return
	 */
	public String getLocation() {
		return s.getLocation();
	}
	/**
	 * @return
	 */
	public String getVisibility() {
		return (s.isShow()? IConstants.VISIBLE : IConstants.HIDDEN);
	}
	/**
	 * @param location
	 */
	public void setLocation(String location) {
		s.setLocation(location);
	}
	/**
	 * @param show
	 */
	public void setVisibility(String show) {
		s.setShow(show.equals(IConstants.VISIBLE));
	}
	
	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DShapes.class) == null)
			_dgraphic.addChild(s);
	}
} //ShapesImpl
