/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSizeImpl.java,v 1.4 2005/06/07 21:03:07 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGSizeImpl.java,v 1.4 2005/06/07 21:03:07 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Size;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Size</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGSizeImpl#getHeight <em>Height</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGSizeImpl#getWidth <em>Width</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGSizeImpl extends SVGInputBase implements Size {
	/**
	 * The default value of the '{@link #getHeight() <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeight()
	 * @generated
	 * @ordered
	 */
	protected static final double HEIGHT_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getHeight() <em>Height</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeight()
	 * @generated
	 * @ordered
	 */
	protected double height = HEIGHT_EDEFAULT;

	/**
	 * This is true if the Height attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean heightESet = false;

	/**
	 * The default value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected static final double WIDTH_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getWidth() <em>Width</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWidth()
	 * @generated
	 * @ordered
	 */
	protected double width = WIDTH_EDEFAULT;

	/**
	 * This is true if the Width attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean widthESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGSizeImpl() {
		super();
	}

	public SVGSizeImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGSizeImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getHeight() {
		if (height == HEIGHT_EDEFAULT) {
			Object heightStr = _dgraphic.getProperties().get(DGraphic.P_MAX_HEIGHT);
			if (heightStr instanceof String)
				height = Integer.parseInt(heightStr.toString());
			else if (heightStr instanceof Double)
				height = ((Double)_dgraphic.getProperties().get(DGraphic.P_MAX_HEIGHT, new Double((int)HEIGHT_EDEFAULT))).doubleValue();
			else if (heightStr instanceof Float)
				height = ((Float)_dgraphic.getProperties().get(DGraphic.P_MAX_HEIGHT, new Float((float)HEIGHT_EDEFAULT))).floatValue();
			else if (heightStr instanceof Integer)
				height = ((Integer)_dgraphic.getProperties().get(DGraphic.P_MAX_HEIGHT, new Integer((int)HEIGHT_EDEFAULT))).intValue();
			if (_dgraphic.getProperties().get(DGraphic.P_MAX_HEIGHT) != null)
				heightESet = true;
		}
		return height;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeight(double newHeight) {
		height = newHeight;
		heightESet = true;
		
		if (_dgraphic != null) {
			_dgraphic.getProperties().store(DGraphic.P_MAX_HEIGHT, new Integer((int)height));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetHeight() {
		heightESet = false;
		height = HEIGHT_EDEFAULT;

		if (_dgraphic != null) {
			_dgraphic.getProperties().remove(DGraphic.P_MAX_HEIGHT);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetHeight() {
		if (heightESet == false) {
			getHeight();
		}
		return heightESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getWidth() {
		if (width == WIDTH_EDEFAULT) {
			Object widthStr = _dgraphic.getProperties().get(DGraphic.P_MAX_WIDTH);
			if (widthStr instanceof String)
				width = Integer.parseInt(widthStr.toString());
			else if (widthStr instanceof Double)
				width = ((Double)_dgraphic.getProperties().get(DGraphic.P_MAX_WIDTH, new Double(WIDTH_EDEFAULT))).doubleValue();
			else if (widthStr instanceof Float)
				width = ((Float)_dgraphic.getProperties().get(DGraphic.P_MAX_WIDTH, new Float((float)WIDTH_EDEFAULT))).floatValue();
			else if (widthStr instanceof Integer)
				width = ((Integer)_dgraphic.getProperties().get(DGraphic.P_MAX_WIDTH, new Integer((int)WIDTH_EDEFAULT))).intValue();
			if (_dgraphic.getProperties().get(DGraphic.P_MAX_WIDTH) != null)
				widthESet = true;
		}
		return width;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWidth(double newWidth) {
		width = newWidth;
		widthESet = true;
		
		if (_dgraphic != null) {
			_dgraphic.getProperties().store(DGraphic.P_MAX_WIDTH, new Integer((int)width));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetWidth() {
		widthESet = false;
		width = WIDTH_EDEFAULT;

		if (_dgraphic != null) {
			_dgraphic.getProperties().remove(DGraphic.P_MAX_WIDTH);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetWidth() {
		if (widthESet == false) {
			getWidth();
		}
		return widthESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (height: ");
		if (heightESet) result.append(height); else result.append("<unset>");
		result.append(", width: ");
		if (widthESet) result.append(width); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //SizeImpl
