/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTimestampImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTimestampImpl.java,v 1.1 2005/03/30 08:26:43 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Timestamp;

import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DTimeStamp;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Timestamp</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTimestampImpl#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTimestampImpl#getPrefix <em>Prefix</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTimestampImpl#isShow <em>Show</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTimestampImpl#getDateFormat <em>Date Format</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGTimestampImpl extends SVGInputBase implements Timestamp {
	/**
	 * The default value of the '{@link #getPrefix() <em>Prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrefix()
	 * @generated
	 * @ordered
	 */
	protected static final String PREFIX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPrefix() <em>Prefix</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrefix()
	 * @generated
	 * @ordered
	 */
	protected String prefix = PREFIX_EDEFAULT;

	/**
	 * The default value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected boolean show = SHOW_EDEFAULT;

	/**
	 * This is true if the Show attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showESet = false;

	/**
	 * The cached value of the '{@link #getDateFormat() <em>Date Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDateFormat()
	 * @generated
	 * @ordered
	 */
	protected DateFormat dateFormat = null;
	protected DTimeStamp ts = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGTimestampImpl() {
		super();
	}

	public SVGTimestampImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGTimestampImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;
		_dgraphic = dgraphic;
	     ts = (DTimeStamp)_dgraphic.getChildOfClass(DTimeStamp.class);
	     if (ts == null) ts = new DTimeStamp();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPrefix() {
		if (prefix == PREFIX_EDEFAULT) {
			prefix = ts.getPrefix();
		}
		return prefix;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrefix(String newPrefix) {
		prefix = newPrefix;
		ts.setPrefix(newPrefix);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShow() {
		if (show == SHOW_EDEFAULT) {
			show = ts.isShow();
			if (show == false)
				showESet = true;
		}
		return show;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShow(boolean newShow) {
		show = newShow;
		showESet = true;
		ts.setShow(newShow);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShow() {
		showESet = false;
		show = SHOW_EDEFAULT;
		ts.setShow(show);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShow() {
		if (showESet == false) {
			isShow();
		}
		return showESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DateFormat getDateFormat() {
		if (dateFormat == null && _dgraphic != null) {
			dateFormat = new SVGDateFormatImpl(_chart, _dgraphic, ts.getDatePattern());					
		}
		return dateFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDateFormat(DateFormat newDateFormat) {
		dateFormat = newDateFormat;
		ts.setDatePattern(dateFormat.getPattern());
	}

	// function for assignment
	public void assignDateFormat(DateFormat source) {
		dateFormat = new SVGDateFormatImpl(_chart, _dgraphic, SVGDateFormatImpl.PATTERN_EDEFAULT);
		((SVGDateFormatImpl) dateFormat).assign(source);
		if (dateFormat.getPattern() != null && dateFormat.getPattern() != "")
			ts.setDatePattern(dateFormat.getPattern());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(", prefix: ");
		result.append(prefix);
		result.append(", show: ");
		if (showESet) result.append(show); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

	// function for assignment
	public void constructModel() {
		if (_dgraphic.getChildOfClass(DTimeStamp.class) == null)
			_dgraphic.addChild(ts);
	}
	
} //TimestampImpl
