/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTitleBarImpl.java,v 1.2 2005/04/06 15:21:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGTitleBarImpl.java,v 1.2 2005/04/06 15:21:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;

import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DEvent;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Title Bar</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTitleBarImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTitleBarImpl#isWithSeparator <em>With Separator</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTitleBarImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTitleBarImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTitleBarImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGTitleBarImpl extends SVGInputBase implements TitleBar {
	/**
	 * The default value of the '{@link #getBackgroundColor() <em>Background Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected static final String BACKGROUND_COLOR_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_EDEFAULT = true;

	/**
	 * This is true if the Show attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showESet = false;

	/**
	 * The default value of the '{@link #isWithSeparator() <em>With Separator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isWithSeparator()
	 * @generated
	 * @ordered
	 */
	protected static final boolean WITH_SEPARATOR_EDEFAULT = true;

	/**
	 * This is true if the With Separator attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean withSeparatorESet = false;

	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;
	
	protected Tooltip tooltip = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGTitleBarImpl() {
		super();
	}

	public SVGTitleBarImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic());
	}

	public SVGTitleBarImpl(Chart chart, DGraphic dgraphic) {
		_chart = chart;	
		_dgraphic = dgraphic;
	}
    
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBackgroundColor() {
		DColor color = ((DColor)_dgraphic.getProperties().get(DGraphic.P_TITLE_BACKCOLOR));
		if (color != null)
			return color.serializeToString();
		return BACKGROUND_COLOR_EDEFAULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBackgroundColor(String newBackgroundColor) {
		if (newBackgroundColor != null && newBackgroundColor != "" && !newBackgroundColor.substring(0, 1).equals("#"))  // if the color name is not "#......"
			newBackgroundColor = convertToHex(newBackgroundColor);
		if (newBackgroundColor == null || newBackgroundColor == "") {	// if not matched, use default color
			_dgraphic.getProperties().remove(DGraphic.P_BACKCOLOR);
			return;
		}
		_dgraphic.getProperties().store(DGraphic.P_TITLE_BACKCOLOR, ((SVGChartImpl)_chart).getColor(newBackgroundColor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		return _dgraphic.getTitle();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		_dgraphic.setTitle(newLabel);
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShow() {
		if (_dgraphic.getProperties().get(DGraphic.P_SHOW_TITLE) != null)
			showESet = true;
		return _dgraphic.getProperties().get(DGraphic.P_SHOW_TITLE, SHOW_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShow(boolean newShow) {
		_dgraphic.getProperties().store(DGraphic.P_SHOW_TITLE, newShow);
		showESet = true;		
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShow() {
		showESet = false;
		_dgraphic.getProperties().remove(DGraphic.P_SHOW_TITLE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShow() {
		if (showESet == false) {
			isShow();
		}
		return showESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isWithSeparator() {
		if (_dgraphic.getProperties().get(DGraphic.P_TITLE_WITH_SEPARATOR) != null)
			withSeparatorESet = true;
		return _dgraphic.getProperties().get(DGraphic.P_TITLE_WITH_SEPARATOR, WITH_SEPARATOR_EDEFAULT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setWithSeparator(boolean newWithSeparator) {
		//_dgraphic.getProperties().store(DGraphic.P_LEGEND_LIMIT, newWithSeparator);
		_dgraphic.getProperties().store(DGraphic.P_TITLE_WITH_SEPARATOR, newWithSeparator);
		withSeparatorESet = true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetWithSeparator() {
		withSeparatorESet = false;
		//_dgraphic.getProperties().store(DGraphic.P_LEGEND_LIMIT, WITH_SEPARATOR_EDEFAULT);
		_dgraphic.getProperties().remove(DGraphic.P_TITLE_WITH_SEPARATOR);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetWithSeparator() {
		if (withSeparatorESet == false) {
			isWithSeparator();
		}
		return withSeparatorESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	
	public Accessibility getAccessibility() {
		if (accessibility == null)
			accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, (String)_dgraphic.getProperties().get(DGraphic.P_TITLE_ACC_TITLE),  (String)_dgraphic.getProperties().get(DGraphic.P_TITLE_ACC_DESC));					
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
	}

	// special case for Title Bar (Chart Title) in Accessibility and EventHandler
	// function for assignment
	public void assignAccessibility(Accessibility source) {
		accessibility = new SVGAccessibilityImpl(_chart, _dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
		((SVGAccessibilityImpl) accessibility).assign(source);
		_dgraphic.getProperties().store(DGraphic.P_TITLE_ACC_TITLE, source.getTitle());
		_dgraphic.getProperties().store(DGraphic.P_TITLE_ACC_DESC, source.getDescription());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			eventHandler = getEventHandler(_dgraphic.getProperties(), DGraphic.P_TITLE_EVENT_LIST);
		}
		return eventHandler;
	}

	// special case for Title Bar (Chart Title) in Accessibility and EventHandler
	// function for assignment
	public void setEventHandler(List newEventHandler) {
		// create a list of all DEvent
		List eventList = new ArrayList();
		for (int i = 0; i < newEventHandler.size(); i++) {
			DEvent event = ((SVGEventHandlerImpl) newEventHandler.get(i)).getDEvent();
			eventList.add(event);
		}
		_dgraphic.getProperties().store(DGraphic.P_TITLE_EVENT_LIST, eventList);
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {		
		if (tooltip == null && _dgraphic != null) {
			String tooltipStr = _dgraphic.getProperties().get(DGraphic.P_TITLE_TOOLTIP, null);
			if (tooltipStr != null)
				tooltip = new SVGTooltipImpl(_chart, _dgraphic, tooltipStr);					
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		_dgraphic.getProperties().store(DGraphic.P_TITLE_TOOLTIP, newTooltip.getLabel());
	}

	// function for assignment
	public void assignTooltip(Tooltip source) {
		tooltip = new SVGTooltipImpl(_chart, _dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
		((SVGTooltipImpl) tooltip).assign(source);
		_dgraphic.getProperties().store(DGraphic.P_TITLE_TOOLTIP, tooltip.getLabel());
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (label: ");
		result.append(getLabel());
		result.append(", withSeparator: ");
		if (withSeparatorESet) result.append(this.isWithSeparator()); else result.append("<unset>");
		if (showESet) result.append(isShow()); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //TitleBarImpl
