/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUnitDefinitionImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SVGUnitDefinitionImpl.java,v 1.2 2005/12/16 09:47:08 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Unit Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGUnitDefinitionImpl#isShowGridLine <em>Show Grid Line</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGUnitDefinitionImpl#isShowTick <em>Show Tick</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGUnitDefinitionImpl#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SVGUnitDefinitionImpl extends SVGInputBase implements UnitDefinition {
	
	protected DAxis axis;
	protected String showGridAttr;
	protected String showTickAttr;
	protected String valueAttr;
		
	/**
	 * The default value of the '{@link #isShowGridLine() <em>Show Grid Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowGridLine()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_GRID_LINE_EDEFAULT = false;

	/**
	 * This is true if the Show Grid Line attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showGridLineESet = false;

	/**
	 * The default value of the '{@link #isShowTick() <em>Show Tick</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowTick()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_TICK_EDEFAULT = false;


	/**
	 * This is true if the Show Tick attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showTickESet = false;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final double VALUE_EDEFAULT = 0.0;

	/**
	 * This is true if the Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean valueESet = false;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SVGUnitDefinitionImpl() {
		super();
	}

	public SVGUnitDefinitionImpl(SVGChartImpl chart) {
		this(chart, chart.getDGraphic(), null, null, null, null);
	}

	/**
	 * @param chart
	 * @param dgraphic
	 * @param tdef
	 */
	public SVGUnitDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis, String showTickAttr, String showGridAttr, String valueAttr) {
		_chart = chart;
		_dgraphic = dgraphic;
		this.axis = axis;
		this.showTickAttr = showTickAttr;
		this.valueAttr = valueAttr;
		this.showGridAttr = showGridAttr;
		
	}



	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShowGridLine() {
		showGridLineESet = false;
		axis.getProperties().remove(showGridAttr);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#getValue()
	 */
	public double getValue() {
		Object value = axis.getProperties().get(valueAttr);
		if (value instanceof Double){
			valueESet = true;
			return ((Double)value).doubleValue();
		}
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#isShowGridLine()
	 */
	public boolean isShowGridLine() {
		if (((Boolean)axis.getProperties().get(showGridAttr)) != null) {
			showGridLineESet = true;
			return ((Boolean)axis.getProperties().get(showGridAttr)).booleanValue();
		}
		return SHOW_GRID_LINE_EDEFAULT;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#isShowTick()
	 */
	public boolean isShowTick() {
		if (((Boolean)axis.getProperties().get(showTickAttr)) != null) {
			showTickESet = true;
			return ((Boolean)axis.getProperties().get(showTickAttr)).booleanValue();
		}
		return SHOW_TICK_EDEFAULT;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#setShowGridLine(boolean)
	 */
	public void setShowGridLine(boolean showGridLine) {
		showGridLineESet = true;
		axis.getProperties().store(showGridAttr, showGridLine);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#setShowTick(boolean)
	 */
	public void setShowTick(boolean showTick) {
		
		showTickESet = true;
		axis.getProperties().store(showTickAttr, showTick);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition#setValue(double)
	 */
	public void setValue(double value) {
		valueESet = true;
		axis.getProperties().store(valueAttr, value);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShowGridLine() {
		if (showGridLineESet == false) {
			isShowGridLine();
		}
		return showGridLineESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShowTick() {
		showTickESet = false;
		axis.getProperties().remove(showTickAttr);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShowTick() {
		if (showTickESet == false) {
			isShowTick();
		}
		return showTickESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetValue() {
		valueESet = false;
		axis.getProperties().remove(valueAttr);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetValue() {
		if (valueESet == false) {
			getValue();
		}
		return valueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (showGridLine: ");
		if (showGridLineESet) result.append(isShowGridLine()); else result.append("<unset>");
		result.append(", showTick: ");
		if (showTickESet) result.append(this.isSetShowTick()); else result.append("<unset>");
		result.append(", value: ");
		if (valueESet) result.append(getValue()); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //UnitDefinitionImpl
