/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Axes</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxesImpl#getIndependentAxis <em>Independent Axis</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxesImpl#getPrimaryDependentAxis <em>Primary Dependent Axis</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxesImpl#getSecondaryDependentAxis <em>Secondary Dependent Axis</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AxesImpl extends InputBase implements Axes {
	/**
	 * The cached value of the '{@link #getIndependentAxis() <em>Independent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndependentAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisDefinition independentAxis = null;

	/**
	 * The cached value of the '{@link #getPrimaryDependentAxis() <em>Primary Dependent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPrimaryDependentAxis()
	 * @generated
	 * @ordered
	 */
	protected AxisDefinition primaryDependentAxis = null;

	/**
	 * The cached value of the '{@link #getSecondaryDependentAxis() <em>Secondary Dependent Axis</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSecondaryDependentAxis()
	 * @generated
	 * @ordered
	 */
	protected DependentAxisDefinition secondaryDependentAxis = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AxesImpl() {
		super();
	}

	public AxesImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("axes");
		}

	}

	public AxesImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisDefinition getIndependentAxis() {
		if (independentAxis == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "independentAxis");
			if (resultElement != null) {
				independentAxis = new AxisDefinitionImpl(_chart, resultElement);					
			}
		}
		return independentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIndependentAxis(AxisDefinition newIndependentAxis) {
		independentAxis = newIndependentAxis;
		
		if (_element != null) {
			Utilities.appendChild(this, newIndependentAxis, "independentAxis");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisDefinition getPrimaryDependentAxis() {
		if (primaryDependentAxis == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "primaryDependentAxis");
			if (resultElement != null) {
				primaryDependentAxis = new AxisDefinitionImpl(_chart, resultElement);					
			}
		}
		return primaryDependentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrimaryDependentAxis(AxisDefinition newPrimaryDependentAxis) {
		primaryDependentAxis = newPrimaryDependentAxis;
		
		if (_element != null && newPrimaryDependentAxis != null && newPrimaryDependentAxis.getElement() != null) {
			Utilities.appendChild(this, newPrimaryDependentAxis, "primaryDependentAxis");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DependentAxisDefinition getSecondaryDependentAxis() {
		if (secondaryDependentAxis == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "secondaryDependentAxis");
			if (resultElement != null) {
				secondaryDependentAxis = new DependentAxisDefinitionImpl(_chart, resultElement);					
			}
		}
		return secondaryDependentAxis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSecondaryDependentAxis(DependentAxisDefinition newSecondaryDependentAxis) {
		secondaryDependentAxis = newSecondaryDependentAxis;
		
		if (_element != null && newSecondaryDependentAxis != null && newSecondaryDependentAxis.getElement() != null) {
			Utilities.appendChild(this, newSecondaryDependentAxis, "secondaryDependentAxis");
		}
	}

} //AxesImpl
