/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CustomFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Axis Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getLabelRotation <em>Label Rotation</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMax <em>Max</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMin <em>Min</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getScale <em>Scale</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMajorUnit <em>Major Unit</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMinorUnit <em>Minor Unit</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMarkerLine <em>Marker Line</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getMarkerRegion <em>Marker Region</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getNumberFormat <em>Number Format</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getDateFormat <em>Date Format</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getAccessibility <em>Accessibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getEventHandler <em>Event Handler</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AxisDefinitionImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AxisDefinitionImpl extends InputBase implements AxisDefinition {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected String label = LABEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getLabelRotation() <em>Label Rotation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelRotation()
	 * @generated
	 * @ordered
	 */
	protected static final double LABEL_ROTATION_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLabelRotation() <em>Label Rotation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabelRotation()
	 * @generated
	 * @ordered
	 */
	protected double labelRotation = LABEL_ROTATION_EDEFAULT;

	/**
	 * This is true if the Label Rotation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean labelRotationESet = false;

	/**
	 * The default value of the '{@link #getMax() <em>Max</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected static final double MAX_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMax() <em>Max</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMax()
	 * @generated
	 * @ordered
	 */
	protected double max = MAX_EDEFAULT;

	/**
	 * This is true if the Max attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean maxESet = false;

	/**
	 * The default value of the '{@link #getMin() <em>Min</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected static final double MIN_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMin() <em>Min</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMin()
	 * @generated
	 * @ordered
	 */
	protected double min = MIN_EDEFAULT;

	/**
	 * This is true if the Min attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean minESet = false;

	/**
	 * The default value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected static final String SCALE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getScale() <em>Scale</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScale()
	 * @generated
	 * @ordered
	 */
	protected String scale = SCALE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMajorUnit() <em>Major Unit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMajorUnit()
	 * @generated
	 * @ordered
	 */
	protected UnitDefinition majorUnit = null;

	/**
	 * The cached value of the '{@link #getMinorUnit() <em>Minor Unit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinorUnit()
	 * @generated
	 * @ordered
	 */
	protected UnitDefinition minorUnit = null;

	/**
	 * The cached value of the '{@link #getMarkerLine() <em>Marker Line</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMarkerLine()
	 * @generated
	 * @ordered
	 */
	protected List markerLine = null;

	/**
	 * The cached value of the '{@link #getMarkerRegion() <em>Marker Region</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMarkerRegion()
	 * @generated
	 * @ordered
	 */
	protected List markerRegion = null;

	/**
	 * The cached value of the '{@link #getNumberFormat() <em>Number Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberFormat()
	 * @generated
	 * @ordered
	 */
	protected NumberFormat numberFormat = null;

	/**
	 * The cached value of the '{@link #getDateFormat() <em>Date Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDateFormat()
	 * @generated
	 * @ordered
	 */
	protected DateFormat dateFormat = null;

	/**
	 * The cached value of the '{@link #getCustomFormat() <em>Custom Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCustomFormat()
	 * @generated
	 * @ordered
	 */
	protected CustomFormat customFormat = null;

	/**
	 * The cached value of the '{@link #getAccessibility() <em>Accessibility</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccessibility()
	 * @generated
	 * @ordered
	 */
	protected Accessibility accessibility = null;

	/**
	 * The cached value of the '{@link #getEventHandler() <em>Event Handler</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventHandler()
	 * @generated
	 * @ordered
	 */
	protected List eventHandler = null;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AxisDefinitionImpl() {
		super();
	}

	public AxisDefinitionImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("axisDefinition");
		}
	}

	public AxisDefinitionImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		if (id == ID_EDEFAULT) {
			if (_element != null && _element.hasAttribute("id")) {
				id = _element.getAttribute("id");
			}
		}
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		id = newId;
		
		if (_element != null) {
			_element.setAttribute("id", newId);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		if (label == LABEL_EDEFAULT) {
			if (_element != null && _element.hasAttribute("label")) {
				label = _element.getAttribute("label");
			}
		}
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		label = newLabel;
		
		if (_element != null) {
			_element.setAttribute("label", newLabel);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLabelRotation() {
		if (labelRotation == LABEL_ROTATION_EDEFAULT) {
			if (_element != null && _element.hasAttribute("labelRotation")) {
				// Convert to double
				String attr = _element.getAttribute("labelRotation");
				if (attr.length() != 0) {
					labelRotation = (new Double(attr)).doubleValue();
					labelRotationESet = true;
				}
			}
		}
		return labelRotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabelRotation(double newLabelRotation) {
		labelRotation = newLabelRotation;
		labelRotationESet = true;
		
		if (_element != null) {
			_element.setAttribute("labelRotation", Double.toString(newLabelRotation));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetLabelRotation() {
		labelRotationESet = false;
		labelRotation = LABEL_ROTATION_EDEFAULT;

		if (_element != null && _element.hasAttribute("labelRotation")) {
			_element.removeAttribute("labelRotation");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetLabelRotation() {
		if (labelRotationESet == false) {
			getLabelRotation();
		}
		return labelRotationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMax() {
		if (max == MAX_EDEFAULT) {
			if (_element != null && _element.hasAttribute("max")) {
				// Convert to double
				String attr = _element.getAttribute("max");
				if (attr.length() != 0) {
					max = (new Double(attr)).doubleValue();
					maxESet = true;
				}
			}
		}
		return max;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMax(double newMax) {
		max = newMax;
		maxESet = true;
		
		if (_element != null) {
			_element.setAttribute("max", Double.toString(newMax));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetMax() {
		maxESet = false;
		max = MAX_EDEFAULT;

		if (_element != null && _element.hasAttribute("max")) {
			_element.removeAttribute("max");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetMax() {
		if (maxESet == false) {
			getMax();
		}
		return maxESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMin() {
		if (min == MAX_EDEFAULT) {
			if (_element != null && _element.hasAttribute("min")) {
				// Convert to double
				String attr = _element.getAttribute("min");
				if (attr.length() != 0) {
					min = (new Double(attr)).doubleValue();
					minESet = true;
				}
			}
		}
		return min;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMin(double newMin) {
		min = newMin;
		minESet = true;
		
		if (_element != null) {
			_element.setAttribute("min", Double.toString(min));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetMin() {
		minESet = false;
		min = MIN_EDEFAULT;
		
		if (_element != null && _element.hasAttribute("min")) {
			_element.removeAttribute("min");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetMin() {
		if (minESet == false) {
			getMin();
		}
		return minESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getScale() {
		if (scale == LABEL_EDEFAULT) {
			if (_element != null && _element.hasAttribute("scale")) {
				scale = _element.getAttribute("scale");
			}
		}
		return scale;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScale(String newScale) {
		scale = newScale;
		
		if (_element != null) {
			_element.setAttribute("scale", newScale);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnitDefinition getMajorUnit() {
		if (majorUnit == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "majorUnit");
			if (resultElement != null) {
				majorUnit = new UnitDefinitionImpl(_chart, resultElement);					
			}
		}
		return majorUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMajorUnit(UnitDefinition newMajorUnit) {
		majorUnit = newMajorUnit;
		
		if (_element != null && newMajorUnit != null && newMajorUnit.getElement() != null) {
			Utilities.appendChild(this, newMajorUnit, "majorUnit");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnitDefinition getMinorUnit() {
		if (minorUnit == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "minorUnit");
			if (resultElement != null) {
				minorUnit = new UnitDefinitionImpl(_chart, resultElement);					
			}
		}
		return minorUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMinorUnit(UnitDefinition newMinorUnit) {
		minorUnit = newMinorUnit;
		
		if (_element != null && newMinorUnit != null && newMinorUnit.getElement() != null) {
			Utilities.appendChild(this, newMinorUnit, "minorUnit");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getMarkerLine() {
		if (markerLine == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "markerLine");
				markerLine = new ElementList(this, "markerLine");
				ElementList elemList = (ElementList) markerLine;
				for (int i = 0; i < elementList.size(); ++i) {
					elemList.add(new MarkerLineImpl(_chart, (Element)elementList.get(i)), false);
				}
			} else {
				markerLine = new ArrayList();
			}
		}
		return markerLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getMarkerRegion() {
		if (markerRegion == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "markerRegion");
				markerRegion = new ElementList(this, "markerRegion");
				ElementList elemList = (ElementList) markerRegion;
				for (int i = 0; i < elementList.size(); ++i) {
					elemList.add(new MarkerRegionImpl(_chart, (Element)elementList.get(i)), false);
				}
			} else {
				markerRegion = new ArrayList();
			}
		}
		return markerRegion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumberFormat getNumberFormat() {
		if (numberFormat == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "numberFormat");
			if (resultElement != null) {
				numberFormat = new NumberFormatImpl(_chart, resultElement);					
			}
		}
		return numberFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberFormat(NumberFormat newNumberFormat) {
		numberFormat = newNumberFormat;
		
		if (_element != null && newNumberFormat != null && newNumberFormat.getElement() != null) {
			Utilities.appendChild(this, newNumberFormat, "numberFormat");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DateFormat getDateFormat() {
		if (dateFormat == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "dateFormat");
			if (resultElement != null) {
				dateFormat = new DateFormatImpl(_chart, resultElement);					
			}
		}
		return dateFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDateFormat(DateFormat newDateFormat) {
		dateFormat = newDateFormat;
		
		if (_element != null && newDateFormat.getElement() != null){
			Utilities.appendChild(this, newDateFormat, "dateFormat");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Accessibility getAccessibility() {
		if (accessibility == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "accessibility");
			if (resultElement != null) {
				accessibility = new AccessibilityImpl(_chart, resultElement);					
			}
		}
		return accessibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAccessibility(Accessibility newAccessibility) {
		accessibility = newAccessibility;
		
		if (_element != null && newAccessibility != null && newAccessibility.getElement() != null) {
			Utilities.appendChild(this, newAccessibility, "accessibility");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEventHandler() {
		if (eventHandler == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "eventHandler");
				eventHandler = new ElementList(this, "eventHandler");
				ElementList elemList = (ElementList) eventHandler;
				for (int i = 0; i < elementList.size(); ++i) {
					elemList.add(new EventHandlerImpl(_chart, (Element)elementList.get(i)), false);
				}
			} else {
				eventHandler = new ArrayList();
			}
		}
		return eventHandler;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "tooltip");
			if (resultElement != null) {
				tooltip = new TooltipImpl(_chart, resultElement);					
			}
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		
		if (_element != null && newTooltip != null && newTooltip.getElement() != null) {
			Utilities.appendChild(this, newTooltip, "tooltip");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", label: ");
		result.append(label);
		result.append(", max: ");
		if (maxESet) result.append(max); else result.append("<unset>");
		result.append(", min: ");
		if (minESet) result.append(min); else result.append("<unset>");
		result.append(", scale: ");
		result.append(scale);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CustomFormat getCustomFormat() {
		if (customFormat == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "customFormat");
			if (resultElement != null) {
				customFormat = new CustomFormatImpl(_chart, resultElement);					
			}
		}
		return customFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCustomFormat(CustomFormat newCustomFormat) {
		customFormat = newCustomFormat;
		
		if (_element != null && newCustomFormat.getElement() != null){
			Utilities.appendChild(this, newCustomFormat, "customFormat");
		}
	}


} //AxisDefinitionImpl
