/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConfigurationImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConfigurationImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.ChartArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Size;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Timestamp;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getSize <em>Size</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getTitleBar <em>Title Bar</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getAxes <em>Axes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getLegend <em>Legend</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getBackgroundColors <em>Background Colors</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getShapes <em>Shapes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getPalettes <em>Palettes</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ConfigurationImpl#getPreferences <em>Preferences</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConfigurationImpl extends InputBase implements Configuration {
	/**
	 * The cached value of the '{@link #getInternationalization() <em>Internationalization</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInternationalization()
	 * @generated
	 * @ordered
	 */
	protected Internationalization internationalization = null;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected Size size = null;

	/**
	 * The cached value of the '{@link #getTitleBar() <em>Title Bar</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTitleBar()
	 * @generated
	 * @ordered
	 */
	protected TitleBar titleBar = null;

	/**
	 * The cached value of the '{@link #getAxes() <em>Axes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAxes()
	 * @generated
	 * @ordered
	 */
	protected Axes axes = null;

	/**
	 * The cached value of the '{@link #getDataValue() <em>DataValue</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataValue()
	 * @generated
	 * @ordered
	 */
	protected DataValue dataValue = null;

	/**
	 * The cached value of the '{@link #getLegend() <em>Legend</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLegend()
	 * @generated
	 * @ordered
	 */
	protected Legend legend = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected Timestamp timestamp = null;

	/**
	 * The cached value of the '{@link #getChartArea() <em>Chart Area</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChartArea()
	 * @generated
	 * @ordered
	 */
	protected ChartArea chartArea = null;

	/**
	 * The cached value of the '{@link #getPlotArea() <em>Plot Area</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPlotArea()
	 * @generated
	 * @ordered
	 */
	protected PlotArea plotArea = null;

	/**
	 * The cached value of the '{@link #getShapes() <em>Shapes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShapes()
	 * @generated
	 * @ordered
	 */
	protected Shapes shapes = null;

	/**
	 * The cached value of the '{@link #getPalettes() <em>Palettes</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPalettes()
	 * @generated
	 * @ordered
	 */
	protected Palettes palettes = null;

	/**
	 * The cached value of the '{@link #getPreferences() <em>Preferences</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPreferences()
	 * @generated
	 * @ordered
	 */
	protected Preferences preferences = null;

	/**
	 * The cached value of the '{@link #getScripts() <em>Scripts</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScripts()
	 * @generated
	 * @ordered
	 */
	protected Scripts scripts = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationImpl() {
		super();
	}

	public ConfigurationImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("configuration");
		}
	}

	public ConfigurationImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Internationalization getInternationalization() {
		if (internationalization == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "internationalization");
			if (resultElement != null) {
				internationalization = new InternationalizationImpl(_chart, resultElement);					
			}
		}
		return internationalization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternationalization(Internationalization newInternationalization) {
		internationalization = newInternationalization;
		
		if (_element != null && newInternationalization != null && newInternationalization.getElement() != null) {
			Utilities.appendChild(this, newInternationalization, "internationalization");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Size getSize() {
		if (size == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "size");
			if (resultElement != null) {
				size = new SizeImpl(_chart, resultElement);					
			}
		}
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(Size newSize) {
		size = newSize;
		
		if (_element != null && newSize != null && newSize.getElement() != null) {
			Utilities.appendChild(this, newSize, "size");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TitleBar getTitleBar() {
		if (titleBar == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "titleBar");
			if (resultElement != null) {
				titleBar = new TitleBarImpl(_chart, resultElement);					
			}
		}
		return titleBar;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTitleBar(TitleBar newTitleBar) {
		titleBar = newTitleBar;
		
		if (_element != null && newTitleBar != null && newTitleBar.getElement() != null) {
			Utilities.appendChild(this, newTitleBar, "titleBar");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Axes getAxes() {
		if (axes == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "axes");
			if (resultElement != null) {
				axes = new AxesImpl(_chart, resultElement);					
			}
		}
		return axes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAxes(Axes newAxes) {
		axes = newAxes;
		
		if (_element != null && newAxes != null && newAxes.getElement() != null) {
			Utilities.appendChild(this, newAxes, "axes");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Legend getLegend() {
		if (legend == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "legend");
			if (resultElement != null) {
				legend = new LegendImpl(_chart, resultElement);					
			}
		}
		return legend;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLegend(Legend newLegend) {
		legend = newLegend;
		
		if (_element != null && newLegend != null && newLegend.getElement() != null) {
			Utilities.appendChild(this, newLegend, "legend");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Timestamp getTimestamp() {
		if (timestamp == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "timestamp");
			if (resultElement != null) {
				timestamp = new TimestampImpl(_chart, resultElement);					
			}
		}
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(Timestamp newTimestamp) {
		timestamp = newTimestamp;
		
		if (_element != null && newTimestamp != null && newTimestamp.getElement() != null) {
			Utilities.appendChild(this, newTimestamp, "timestamp");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataValue getDataValue() {
		if (dataValue == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "dataValue");
			if (resultElement != null) {
				dataValue = new DataValueImpl(_chart, resultElement);					
			}
		}
		return dataValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataValue(DataValue newDataValue) {
		dataValue = newDataValue;
		
		if (_element != null && newDataValue != null && newDataValue.getElement() != null) {
			Utilities.appendChild(this, newDataValue, "dataValue");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ChartArea getChartArea() {
		if (chartArea == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "chartArea");
			if (resultElement != null) {
				chartArea = new ChartAreaImpl(_chart, resultElement);					
			}
		}
		return chartArea;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setChartArea(ChartArea newChartArea) {
		chartArea = newChartArea;
		
		if (_element != null && newChartArea != null && newChartArea.getElement() != null) {
			Utilities.appendChild(this, newChartArea, "chartArea");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlotArea getPlotArea() {
		if (plotArea == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "plotArea");
			if (resultElement != null) {
				plotArea = new PlotAreaImpl(_chart, resultElement);					
			}
		}
		return plotArea;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPlotArea(PlotArea newPlotArea) {
		plotArea = newPlotArea;
		
		if (_element != null && newPlotArea != null) {
			Utilities.appendChild(this, newPlotArea, "plotArea");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Shapes getShapes() {
		if (shapes == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "shapes");
			if (resultElement != null) {
				shapes = new ShapesImpl(_chart, resultElement);					
			}
		}
		return shapes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShapes(Shapes newShapes) {
		shapes = newShapes;
		
		if (_element != null && newShapes != null && newShapes.getElement() != null) {
			Utilities.appendChild(this, newShapes, "shapes");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Palettes getPalettes() {
		if (palettes == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "palettes");
			if (resultElement != null) {
				palettes = new PalettesImpl(_chart, resultElement);					
			}
		}
		return palettes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPalettes(Palettes newPalettes) {
		palettes = newPalettes;
		
		if (_element != null && newPalettes != null && newPalettes.getElement() != null) {
			Utilities.appendChild(this, newPalettes, "palettes");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Preferences getPreferences() {
		if (preferences == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "preferences");
			if (resultElement != null) {
				preferences = new PreferencesImpl(_chart, resultElement);					
			}
		}
		return preferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPreferences(Preferences newPreferences) {
		preferences = newPreferences;
		
		if (_element != null && newPreferences != null && newPreferences.getElement() != null) {
			Utilities.appendChild(this, newPreferences, "preferences");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Scripts getScripts() {
		if (scripts == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "scripts");
			if (resultElement != null) {
				scripts = new ScriptsImpl(_chart, resultElement);					
			}
		}
		return scripts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setScripts(Scripts newScripts) {
		scripts = newScripts;
		
		if (_element != null && newScripts != null && newScripts.getElement() != null) {
			Utilities.appendChild(this, newScripts, "scripts");
		}
	}

} //ConfigurationImpl
