/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetAssociationsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetAssociationsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.IDRefList;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Set Associations</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataSetAssociationsImpl#getDataSetIds <em>Data Set Ids</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataSetAssociationsImpl extends InputBase implements DataSetAssociations {
	/**
	 * The cached value of the '{@link #getDataSetIds() <em>Data Set Ids</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetIds()
	 * @generated
	 * @ordered
	 */
	protected List dataSetIds = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSetAssociationsImpl() {
		super();
	}

	public DataSetAssociationsImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("dataSetAssociations");
		}
	}

	public DataSetAssociationsImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSetIds() {
		if (dataSetIds == null) {
			if (_element != null) {
				String attr = _element.getAttribute("dataSetIds");
				dataSetIds = new IDRefList(_element, "dataSetIds");
				List refIds = new ArrayList();
			
				// Extract the IDs from a space separated list
				attr = attr.trim();
				String id = "";
				int i = 0;
				while (i < attr.length()) {
					char c = attr.charAt(i);
					if (c != ' ') {
						id += c;
						++i;
						continue;
					}
					else {
						refIds.add(id);
						id = "";
						while (attr.charAt(i) == ' ') ++i;					 
					}
				}
			
				if (attr.length() != 0) {
					refIds.add(id);
				}

				// Search for the references to dataSets
				Data data = _chart.getData();
				DataSets dataSets = data.getDataSets();
				List dataSetList = dataSets.getDataSet();
				for (i = 0; i < dataSetList.size(); ++i) {
					DataSet dataSet = (DataSet) dataSetList.get(i);
					IDRefList dataSetidRefs = (IDRefList) dataSetIds;
					for (int j = 0; j < refIds.size(); ++j) {
						if (dataSet.getId().compareTo((String)refIds.get(j)) == 0) {
							dataSetidRefs.add(dataSet, false);
						}
					}
				}
			} else {
				dataSetIds = new ArrayList();
			}
		}
		return dataSetIds;
	}

} //DataSetAssociationsImpl
