/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetColorImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetColorImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetColor;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Set Color</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataSetColorImpl#getColor <em>Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataSetColorImpl#getDataSetId <em>Data Set Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataSetColorImpl extends InputBase implements DataSetColor {
	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected String color = COLOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDataSetId() <em>Data Set Id</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetId()
	 * @generated
	 * @ordered
	 */
	protected Object dataSetId = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataSetColorImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("shapes");
		}
	}
	
	public DataSetColorImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColor() {
		if (color == COLOR_EDEFAULT) {
			if (_element != null && _element.hasAttribute("color")) {
				color = _element.getAttribute("color");
			}
		}
		return color;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColor(String newColor) {
		color = newColor;
		
		if (_element != null) {
			_element.setAttribute("color", newColor);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDataSetId() {
		if (dataSetId == null && _element != null) {
			// Search for the reference to DataSet
			String refId = _element.getAttribute("dataSetId");
			Data data = _chart.getData();
			DataSets dataSets = data.getDataSets();
			List dataSetList = dataSets.getDataSet();
			for (int i = 0; i < dataSetList.size(); ++i) {
				DataSet dataSet = (DataSet) dataSetList.get(i);
				if (dataSet.getId().equals(refId)) {
					dataSetId = dataSet;
					break;
				}
			}
		}
		return dataSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetId(Object newDataSetId) {
		dataSetId = newDataSetId;
		
		DataSet dataSet = null;
		String dataSetIdStr;
		try {
			dataSet = (DataSet) newDataSetId;
			dataSetIdStr = dataSet.getId();
			if (_element != null) {
				_element.setAttribute("dataSetId", dataSetIdStr);
			}
		} catch (ClassCastException e) {
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (color: ");
		result.append(color);
		result.append(')');
		return result.toString();
	}

} //DataSetColorImpl
