/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Sets</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataSetsImpl#getDataSet <em>Data Set</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DataSetsImpl extends InputBase implements DataSets {
	/**
	 * The cached value of the '{@link #getDataSet() <em>Data Set</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSet()
	 * @generated
	 * @ordered
	 */
	protected List dataSet = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataSetsImpl() {
		super();
	}

	public DataSetsImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("dataSets");
		}
	}

	public DataSetsImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSet() {
		if (dataSet == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "dataSet");
				dataSet = new ElementList(this, "dataSet");
				ElementList elemList = (ElementList) dataSet;
				for (int i = 0; i < elementList.size(); ++i) {
					elemList.add(new DataSetImpl(_chart, (Element)elementList.get(i)), false);
				}
			} else {
				dataSet = new ArrayList();
			}
		}
		return dataSet;
	}

} //DataSetsImpl
