/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataValueImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataValueImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataValueImpl#getPercentageVisibility <em>Percentage Visibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataValueImpl#getValueVisibility <em>Value Visibility</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DataValueImpl#getNumberFormat <em>Number Format</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.InputPackage#getDataValue()
 * @model 
 * @generated
 */
public class DataValueImpl extends InputBase implements DataValue {

	/**
	 * The default value of the '{@link #getPercentageVisibility() <em>Percentage Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPercentageVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final String PERCENTAGE_VISIBILITY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPercentageVisibility() <em>Percentage Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPercentageVisibility()
	 * @generated
	 * @ordered
	 */
	protected String percentageVisibility = PERCENTAGE_VISIBILITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getValueVisibility() <em>Value Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final String VALUE_VISIBILITY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getValueVisibility() <em>Value Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueVisibility()
	 * @generated
	 * @ordered
	 */
	protected String valueVisibility = VALUE_VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getNumberFormat() <em>Number Format</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberFormat()
	 * @generated
	 * @ordered
	 */
	protected NumberFormat numberFormat = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataValueImpl() {
		super();
	}

	public DataValueImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("dataValue");
		}
	}

	public DataValueImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPercentageVisibility() {
		if (percentageVisibility == PERCENTAGE_VISIBILITY_EDEFAULT) {
			if (_element != null && _element.hasAttribute("percentageVisibility")) {
				percentageVisibility = _element.getAttribute("percentageVisibility");
			}
		}
		return percentageVisibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPercentageVisibility(String newPercentageVisibility) {
		percentageVisibility = newPercentageVisibility;
		
		if (_element != null) {
			_element.setAttribute("percentageVisibility", newPercentageVisibility);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getValueVisibility() {
		if (valueVisibility == VALUE_VISIBILITY_EDEFAULT) {
			if (_element != null && _element.hasAttribute("valueVisibility")) {
				valueVisibility = _element.getAttribute("valueVisibility");
			}
		}
		return valueVisibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValueVisibility(String newValueVisibility) {
		valueVisibility = newValueVisibility;
		
		if (_element != null) {
			_element.setAttribute("valueVisibility", newValueVisibility);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumberFormat getNumberFormat() {
		if (numberFormat == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "numberFormat");
			if (resultElement != null) {
				numberFormat = new NumberFormatImpl(_chart, resultElement);					
			}
		}
		return numberFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberFormat(NumberFormat newNumberFormat) {
		numberFormat = newNumberFormat;
		
		if (_element != null && newNumberFormat != null && newNumberFormat.getElement() != null) {
			Utilities.appendChild(this, newNumberFormat, "numberFormat");
		}
	}

}
