/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DependentAxisDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DependentAxisDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dependent Axis Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.DependentAxisDefinitionImpl#getDataSetAssociations <em>Data Set Associations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DependentAxisDefinitionImpl extends AxisDefinitionImpl implements DependentAxisDefinition {
	/**
	 * The cached value of the '{@link #getDataSetAssociations() <em>Data Set Associations</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetAssociations()
	 * @generated
	 * @ordered
	 */
	protected DataSetAssociations dataSetAssociations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DependentAxisDefinitionImpl() {
		super();
	}

	public DependentAxisDefinitionImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("dependentAxisDefinition");
		}
	}

	public DependentAxisDefinitionImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DataSetAssociations getDataSetAssociations() {
		if (dataSetAssociations == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "dataSetAssociations");
			if (resultElement != null) {
				dataSetAssociations = new DataSetAssociationsImpl(_chart, resultElement);					
			}
		}
		return dataSetAssociations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetAssociations(DataSetAssociations newDataSetAssociations) {
		dataSetAssociations = newDataSetAssociations;
		
		if (_element != null && newDataSetAssociations != null && newDataSetAssociations.getElement() != null) {
			Utilities.appendChild(this, newDataSetAssociations, "dataSetAssociations");
		}
	}

} //DependentAxisDefinitionImpl
