/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InternationalizationImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InternationalizationImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Internationalization</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InternationalizationImpl#getCountry <em>Country</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InternationalizationImpl#getLanguage <em>Language</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InternationalizationImpl#getTextDirection <em>Text Direction</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InternationalizationImpl extends InputBase implements Internationalization {
	/**
	 * The default value of the '{@link #getCountry() <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountry()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountry() <em>Country</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountry()
	 * @generated
	 * @ordered
	 */
	protected String country = COUNTRY_EDEFAULT;

	/**
	 * The default value of the '{@link #getLanguage() <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguage()
	 * @generated
	 * @ordered
	 */
	protected static final String LANGUAGE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLanguage() <em>Language</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLanguage()
	 * @generated
	 * @ordered
	 */
	protected String language = LANGUAGE_EDEFAULT;

	/**
	 * The default value of the '{@link #getResourceBundle() <em>Resource Bundle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceBundle()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_BUNDLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResourceBundle() <em>Resource Bundle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceBundle()
	 * @generated
	 * @ordered
	 */
	protected String resourceBundle = RESOURCE_BUNDLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTextDirection() <em>Text Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTextDirection()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_DIRECTION_EDEFAULT = "LTR";

	/**
	 * The cached value of the '{@link #getTextDirection() <em>Text Direction</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTextDirection()
	 * @generated
	 * @ordered
	 */
	protected String textDirection = TEXT_DIRECTION_EDEFAULT;

	/**
	 * This is true if the Text Direction attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean textDirectionESet = false;

	/**
	 * The default value of the '{@link #getTimezone() <em>Timezone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimezone()
	 * @generated
	 * @ordered
	 */
	protected static final String TIMEZONE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimezone() <em>Timezone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimezone()
	 * @generated
	 * @ordered
	 */
	protected String timezone = TIMEZONE_EDEFAULT;
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InternationalizationImpl() {
		super();
	}

	public InternationalizationImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("internationalization");
		}
	}

	public InternationalizationImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCountry() {
		if (country == COUNTRY_EDEFAULT) {
			if (_element != null && _element.hasAttribute("country")) {
				country = _element.getAttribute("country");
			}
		}
		return country;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCountry(String newCountry) {
		country = newCountry;
		
		if (_element != null) {
			_element.setAttribute("country", newCountry);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLanguage() {
		if (language == LANGUAGE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("language")) {
				language = _element.getAttribute("language");
			}
		}
		return language;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLanguage(String newLanguage) {
		language = newLanguage;
		
		if (_element != null) {
			_element.setAttribute("language", newLanguage);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTextDirection() {
		// Handle default value
		if (textDirection.equals(TEXT_DIRECTION_EDEFAULT)) {
			if (_element != null && _element.hasAttribute("textDirection")) {
				textDirection = _element.getAttribute("textDirection");
				textDirectionESet = true;
			}
		}
		return textDirection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTextDirection(String newTextDirection) {
		textDirection = newTextDirection;
		textDirectionESet = true;
		
		if (_element != null) {
			_element.setAttribute("textDirection", newTextDirection);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetTextDirection() {
		textDirectionESet = false;
		textDirection = TEXT_DIRECTION_EDEFAULT;

		if (_element != null && _element.hasAttribute("textDirection")) {
			_element.removeAttribute("textDirection");
		}
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTimezone() {
		// Handle default value
		if (timezone == TIMEZONE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("timezone")) {
				timezone = _element.getAttribute("timezone");
			}
		}
		return timezone;		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimezone(String newTimezone) {
		timezone = newTimezone;

		if (_element != null && _element.hasAttribute("timezone")) {
			_element.removeAttribute("timezone");
		}	}
	

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetTextDirection() {
		if (textDirectionESet == false) {
			getTextDirection();
		}
		return textDirectionESet;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#getResourceBundle()
	 */
	public String getResourceBundle() {
		if (resourceBundle == RESOURCE_BUNDLE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("resourceBundle")) {
				resourceBundle = _element.getAttribute("resourceBundle");
			}
		}
		return resourceBundle;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization#setResourceBundle(java.lang.String)
	 */
	public void setResourceBundle(String newResourceBundle) {
		country = newResourceBundle;
		
		if (_element != null) {
			_element.setAttribute("resourceBundle", newResourceBundle);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (country: ");
		result.append(country);
		result.append(", language: ");
		result.append(language);
		result.append(", textDirection: ");
		if (textDirectionESet) result.append(textDirection); else result.append("<unset>");
		result.append(", resourceBundle: ");
		result.append(resourceBundle);
		result.append(')');
		return result.toString();
	}

} //InternationalizationImpl
