/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerRegionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MarkerRegionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Marker Region</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.MarkerRegionImpl#getColor <em>Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.MarkerRegionImpl#getFromValue <em>From Value</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.MarkerRegionImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.MarkerRegionImpl#getLabel <em>Label</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.MarkerRegionImpl#getToValue <em>To Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MarkerRegionImpl extends InputBase implements MarkerRegion {
	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected String color = COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getFromValue() <em>From Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFromValue()
	 * @generated
	 * @ordered
	 */
	protected static final double FROM_VALUE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getFromValue() <em>From Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFromValue()
	 * @generated
	 * @ordered
	 */
	protected double fromValue = FROM_VALUE_EDEFAULT;

	/**
	 * This is true if the From Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean fromValueESet = false;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected static final String LABEL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLabel() <em>Label</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabel()
	 * @generated
	 * @ordered
	 */
	protected String label = LABEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getToValue() <em>To Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToValue()
	 * @generated
	 * @ordered
	 */
	protected static final double TO_VALUE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getToValue() <em>To Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getToValue()
	 * @generated
	 * @ordered
	 */
	protected double toValue = TO_VALUE_EDEFAULT;

	/**
	 * This is true if the To Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean toValueESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MarkerRegionImpl() {
		super();
	}

	public MarkerRegionImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("markerLine");
		}
	}

	public MarkerRegionImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColor() {
		if (color == COLOR_EDEFAULT) {
			if (_element != null && _element.hasAttribute("color")) {
				color = _element.getAttribute("color");
			}
		}
		return color;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColor(String newColor) {
		color = newColor;
		
		if (_element != null) {
			_element.setAttribute("color", newColor);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getFromValue() {
		if (fromValue == FROM_VALUE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("fromValue")) {
				// Convert to double
				String attr = _element.getAttribute("fromValue");
				if (attr.length() != 0) {
					fromValue = (new Double(attr)).doubleValue();
					fromValueESet = true;
				}
			}
		}
		return fromValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFromValue(double newFromValue) {
		fromValue = newFromValue;
		fromValueESet = true;
		
		if (_element != null) {
			_element.setAttribute("fromValue", Double.toString(newFromValue));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetFromValue() {
		fromValueESet = false;
		fromValue = FROM_VALUE_EDEFAULT;

		if (_element != null && _element.hasAttribute("fromValue")) {
			_element.removeAttribute("fromValue");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetFromValue() {
		if (fromValueESet == false) {
			getFromValue();
		}
		return fromValueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		if (id == ID_EDEFAULT) {
			if (_element != null && _element.hasAttribute("id")) {
				id = _element.getAttribute("id");
			}
		}
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		id = newId;
		
		if (_element != null) {
			_element.setAttribute("id", newId);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLabel() {
		if (label == LABEL_EDEFAULT) {
			if (_element != null && _element.hasAttribute("label")) {
				label = _element.getAttribute("label");
			}
		}
		return label;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLabel(String newLabel) {
		label = newLabel;
		
		if (_element != null) {
			_element.setAttribute("label", newLabel);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getToValue() {
		if (toValue == TO_VALUE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("toValue")) {
				// Convert to double
				String attr = _element.getAttribute("toValue");
				if (attr.length() != 0) {
					toValue = (new Double(attr)).doubleValue();
					toValueESet = true;
				}
			}
		}
		return toValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setToValue(double newToValue) {
		toValue = newToValue;
		toValueESet = true;
		
		if (_element != null) {
			_element.setAttribute("toValue", Double.toString(newToValue));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetToValue() {
		toValueESet = false;
		toValue = TO_VALUE_EDEFAULT;

		if (_element != null && _element.hasAttribute("toValue")) {
			_element.removeAttribute("toValue");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetToValue() {
		if (toValueESet == false) {
			getToValue();
		}
		return toValueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (color: ");
		result.append(color);
		result.append(", fromValue: ");
		if (fromValueESet) result.append(fromValue); else result.append("<unset>");
		result.append(", id: ");
		result.append(id);
		result.append(", label: ");
		result.append(label);
		result.append(", toValue: ");
		if (toValueESet) result.append(toValue); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //MarkerRegionImpl
