/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PalettesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PalettesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Palettes</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PalettesImpl#getLocation <em>Location</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PalettesImpl extends InputBase implements Palettes {
	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected String location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getPaletteId() <em>Palette Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteId()
	 * @generated
	 * @ordered
	 */
	protected static final String PALETTE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPaletteId() <em>Palette Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteId()
	 * @generated
	 * @ordered
	 */
	protected String paletteId = PALETTE_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getPaletteSetId() <em>Palette Set Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteSetId()
	 * @generated
	 * @ordered
	 */
	protected static final String PALETTE_SET_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPaletteSetId() <em>Palette Set Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPaletteSetId()
	 * @generated
	 * @ordered
	 */
	protected String paletteSetId = PALETTE_SET_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDataSetColor() <em>Data Set Color</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetColor()
	 * @generated
	 * @ordered
	 */
	protected List dataSetColor = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PalettesImpl() {
		super();
	}

	public PalettesImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("palettes");
		}
	}

	public PalettesImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation() {
		if (location == LOCATION_EDEFAULT) {
			if (_element != null && _element.hasAttribute("location")) {
				location = _element.getAttribute("location");
			}
		}
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation) {
		location = newLocation;
		
		if (_element != null) {
			_element.setAttribute("location", newLocation);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPaletteId() {
		if (paletteId == PALETTE_ID_EDEFAULT) {
			if (_element != null && _element.hasAttribute("paletteId")) {
				paletteId = _element.getAttribute("paletteId");
			}
		}
		return paletteId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPaletteId(String newPaletteId) {
		paletteId = newPaletteId;
		
		if (_element != null) {
			_element.setAttribute("paletteId", newPaletteId);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPaletteSetId() {
		if (paletteSetId == PALETTE_SET_ID_EDEFAULT) {
			if (_element != null && _element.hasAttribute("paletteSetId")) {
				paletteSetId = _element.getAttribute("paletteSetId");
			}
		}
		return paletteSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPaletteSetId(String newPaletteSetId) {
		paletteId = newPaletteSetId;
		
		if (_element != null) {
			_element.setAttribute("paletteSetId", newPaletteSetId);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getDataSetColor() {
		if (dataSetColor == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "dataSetColor");
				dataSetColor = new ElementList(this, "dataSetColor");
				for (int i = 0; i < elementList.size(); ++i) {
					dataSetColor.add(new DataSetColorImpl(_chart, (Element)elementList.get(i)));
				}
			} else {
				dataSetColor = new ArrayList();
			}
		}
		return dataSetColor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (location: ");
		result.append(location);
		result.append(", paletteId: ");
		result.append(paletteId);
		result.append(", paletteSetId: ");
		result.append(paletteSetId);
		result.append(')');
		return result.toString();
	}

} //PalettesImpl
