/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PlotAreaImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.PlotArea;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Plot Area</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PlotAreaImpl#getBackgroundColor <em>Background Color</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PlotAreaImpl#isBorder <em>Border</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PlotAreaImpl extends InputBase implements PlotArea {
	/**
	 * The default value of the '{@link #getBackgroundColor() <em>Background Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected static final String BACKGROUND_COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBackgroundColor() <em>Background Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgroundColor()
	 * @generated
	 * @ordered
	 */
	protected String backgroundColor = BACKGROUND_COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #isBorder() <em>Border</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isBorder()
	 * @generated
	 * @ordered
	 */
	protected static final boolean BORDER_EDEFAULT = true;

	/**
	 * The cached value of the '{@link #isBorder() <em>Border</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isBorder()
	 * @generated
	 * @ordered
	 */
	protected boolean border = BORDER_EDEFAULT;

	/**
	 * This is true if the Border attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean borderESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlotAreaImpl() {
		super();
	}

	public PlotAreaImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("plotArea");
		}
	}

	public PlotAreaImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBackgroundColor() {
		if (backgroundColor == BACKGROUND_COLOR_EDEFAULT) {
			if (_element != null && _element.hasAttribute("backgroundColor")) {
				backgroundColor = _element.getAttribute("backgroundColor");
			}
		}
		return backgroundColor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBackgroundColor(String newBackgroundColor) {
		backgroundColor = newBackgroundColor;
		
		if (_element != null) {
			_element.setAttribute("backgroundColor", newBackgroundColor);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isBorder() {
		if (border == BORDER_EDEFAULT) {
			if (_element != null && _element.hasAttribute("border")) {
				// Convert to boolean, default is TRUE
				String attr = _element.getAttribute("border");
				if (attr.length() != 0) {
					if (attr.equalsIgnoreCase("false")) {
						border = false;
					}
					borderESet = true;
				}
			}
		}
		return border;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBorder(boolean newBorder) {
		border = newBorder;
		borderESet = true;
		
		if (_element != null) {
			if (border) {
				_element.setAttribute("border", "true");
			} else {
				_element.setAttribute("border", "false");
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetBorder() {
		borderESet = false;
		border = BORDER_EDEFAULT;

		if (_element != null && _element.hasAttribute("border")) {
			_element.removeAttribute("border");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetBorder() {
		if (borderESet == false) {
			isBorder();
		}
		return borderESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (backgroundColor: ");
		result.append(backgroundColor);
		result.append(", border: ");
		if (borderESet) result.append(border); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //PlotAreaImpl
