/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PreferencesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PreferencesImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Preferences</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PreferencesImpl#getBrowserCookieName <em>Browser Cookie Name</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PreferencesImpl#isShow <em>Show</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PreferencesImpl#getStoredPreferences <em>Stored Preferences</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PreferencesImpl#getUpdatedPreferencesVariable <em>Updated Preferences Variable</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.PreferencesImpl#getTooltip <em>Tooltip</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PreferencesImpl extends InputBase implements Preferences {
	/**
	 * The default value of the '{@link #getBrowserCookieName() <em>Browser Cookie Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBrowserCookieName()
	 * @generated
	 * @ordered
	 */
	protected static final String BROWSER_COOKIE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getBrowserCookieName() <em>Browser Cookie Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBrowserCookieName()
	 * @generated
	 * @ordered
	 */
	protected String browserCookieName = BROWSER_COOKIE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isShow() <em>Show</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShow()
	 * @generated
	 * @ordered
	 */
	protected boolean show = SHOW_EDEFAULT;

	/**
	 * This is true if the Show attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showESet = false;

	/**
	 * The default value of the '{@link #getStoredPreferences() <em>Stored Preferences</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStoredPreferences()
	 * @generated
	 * @ordered
	 */
	protected static final String STORED_PREFERENCES_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStoredPreferences() <em>Stored Preferences</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStoredPreferences()
	 * @generated
	 * @ordered
	 */
	protected String storedPreferences = STORED_PREFERENCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getUpdatedPreferencesVariable() <em>Updated Preferences Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUpdatedPreferencesVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String UPDATED_PREFERENCES_VARIABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUpdatedPreferencesVariable() <em>Updated Preferences Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUpdatedPreferencesVariable()
	 * @generated
	 * @ordered
	 */
	protected String updatedPreferencesVariable = UPDATED_PREFERENCES_VARIABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUrl() <em>Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUrl()
	 * @generated
	 * @ordered
	 */
	protected String url = URL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getTooltip() <em>Tooltip</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTooltip()
	 * @generated
	 * @ordered
	 */
	protected Tooltip tooltip = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PreferencesImpl() {
		super();
	}

	public PreferencesImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("preferences");
		}
	}

	public PreferencesImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getBrowserCookieName() {
		if (browserCookieName == BROWSER_COOKIE_NAME_EDEFAULT) {
			if (_element != null && _element.hasAttribute("browserCookieName")) {
				browserCookieName = _element.getAttribute("browserCookieName");
			}
		}
		return browserCookieName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBrowserCookieName(String newBrowserCookieName) {
		browserCookieName = newBrowserCookieName;
		
		if (_element != null) {
			_element.setAttribute("browserCookieName", newBrowserCookieName);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShow() {
		if (show == SHOW_EDEFAULT) {
			// Convert to boolean, default is FALSE
			String attr = _element.getAttribute("show");
			if (attr.length() != 0) {
				if (attr.equalsIgnoreCase("true")) {
					show = true;
				}
				showESet = true;
			}
		}
		return show;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShow(boolean newShow) {
		show = newShow;
		showESet = true;
		
		if (_element != null) {
			if (show) {
				_element.setAttribute("show", "true");
			} else {
				_element.setAttribute("show", "false");
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShow() {
		showESet = false;
		show = SHOW_EDEFAULT;

		if (_element != null && _element.hasAttribute("show")) {
			_element.removeAttribute("show");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShow() {
		if (showESet == false) {
			isShow();
		}
		return showESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getStoredPreferences() {
		if (storedPreferences == STORED_PREFERENCES_EDEFAULT) {
			if (_element != null && _element.hasAttribute("storedPreferences")) {
				storedPreferences = _element.getAttribute("storedPreferences");
			}
		}
		return storedPreferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStoredPreferences(String newStoredPreferences) {
		storedPreferences = newStoredPreferences;
		
		if (_element != null) {
			_element.setAttribute("storedPreferences", newStoredPreferences);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUpdatedPreferencesVariable() {
		if (updatedPreferencesVariable == UPDATED_PREFERENCES_VARIABLE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("updatedPreferencesVariable")) {
				updatedPreferencesVariable = _element.getAttribute("updatedPreferencesVariable");
			}
		}
		return updatedPreferencesVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUpdatedPreferencesVariable(String newUpdatedPreferencesVariable) {
		updatedPreferencesVariable = newUpdatedPreferencesVariable;
		
		if (_element != null) {
			_element.setAttribute("updatedPreferencesVariable", newUpdatedPreferencesVariable);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUrl() {
		if (url == URL_EDEFAULT) {
			if (_element != null && _element.hasAttribute("url")) {
				url = _element.getAttribute("url");
			}
		}
		return url;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUrl(String newUrl) {
		url = newUrl;
		
		if (_element != null) {
			_element.setAttribute("url", newUrl);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Tooltip getTooltip() {
		if (tooltip == null && _element != null) {
			Element resultElement = Utilities.getElement(_element, "tooltip");
			if (resultElement != null) {
				tooltip = new TooltipImpl(_chart, resultElement);					
			}
		}
		return tooltip;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTooltip(Tooltip newTooltip) {
		tooltip = newTooltip;
		
		if (_element != null && newTooltip != null && newTooltip.getElement() != null) {
			Utilities.appendChild(this, newTooltip, "tooltip");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (browserCookieName: ");
		result.append(browserCookieName);
		result.append(", show: ");
		if (showESet) result.append(show); else result.append("<unset>");
		result.append(", storedPreferences: ");
		result.append(storedPreferences);
		result.append(", updatedPreferencesVariable: ");
		result.append(updatedPreferencesVariable);
		result.append(", url: ");
		result.append(url);
		result.append(')');
		return result.toString();
	}

} //PreferencesImpl
