/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ScriptsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ScriptsImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Scripts</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ScriptsImpl#getEcmascript <em>Ecmascript</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ScriptsImpl extends InputBase implements Scripts {
	/**
	 * The default value of the '{@link #getSvgDocumentVariable() <em>Svg Document Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgDocumentVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String SVG_DOCUMENT_VARIABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSvgDocumentVariable() <em>Svg Document Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgDocumentVariable()
	 * @generated
	 * @ordered
	 */
	protected String svgDocumentVariable = SVG_DOCUMENT_VARIABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSvgWindowVariable() <em>Svg Window Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgWindowVariable()
	 * @generated
	 * @ordered
	 */
	protected static final String SVG_WINDOW_VARIABLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSvgWindowVariable() <em>Svg Window Variable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSvgWindowVariable()
	 * @generated
	 * @ordered
	 */
	protected String svgWindowVariable = SVG_WINDOW_VARIABLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEcmascript() <em>Ecmascript</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEcmascript()
	 * @generated
	 * @ordered
	 */
	protected List ecmascript = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScriptsImpl() {
		super();
	}

	public ScriptsImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("scripts");
		}
	}

	public ScriptsImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSvgDocumentVariable() {
		if (svgDocumentVariable == SVG_DOCUMENT_VARIABLE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("svgDocumentVariable")) {
				svgDocumentVariable = _element.getAttribute("svgDocumentVariable");
			}
		}
		return svgDocumentVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSvgDocumentVariable(String newSvgDocumentVariable) {
		svgDocumentVariable = newSvgDocumentVariable;
		
		if (_element != null) {
			_element.setAttribute("svgDocumentVariable", newSvgDocumentVariable);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSvgWindowVariable() {
		if (svgWindowVariable == SVG_WINDOW_VARIABLE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("svgWindowVariable")) {
				svgWindowVariable = _element.getAttribute("svgWindowVariable");
			}
		}
		return svgWindowVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSvgWindowVariable(String newSvgWindowVariable) {
		svgWindowVariable = newSvgWindowVariable;
		
		if (_element != null) {
			_element.setAttribute("svgWindowVariable", newSvgWindowVariable);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getEcmascript() {
		if (ecmascript == null) {
			if (_element != null) {
				List elementList = Utilities.getElementList(_element, "ecmascript");
				ecmascript = new ElementList(this, "ecmascript");
				ElementList elemList = (ElementList) ecmascript;
				for (int i = 0; i < elementList.size(); ++i) {
					elemList.add(new EcmascriptImpl(_chart, (Element)elementList.get(i)), false);
				}
			} else {
				ecmascript = new ArrayList();
			}
		}
		return ecmascript;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (svgDocumentVariable: ");
		result.append(svgDocumentVariable);
		result.append(", svgWindowVariable: ");
		result.append(svgWindowVariable);
		result.append(')');
		return result.toString();
	}

} //ScriptsImpl
