/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShapeImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ShapeImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shape;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shape</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ShapeImpl#getShapeId <em>Shape Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.ShapeImpl#getDataSetId <em>Data Set Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ShapeImpl extends InputBase implements Shape {
	/**
	 * The default value of the '{@link #getShapeId() <em>Shape Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShapeId()
	 * @generated
	 * @ordered
	 */
	protected static final String SHAPE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getShapeId() <em>Shape Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getShapeId()
	 * @generated
	 * @ordered
	 */
	protected String shapeId = SHAPE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDataSetId() <em>Data Set Id</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDataSetId()
	 * @generated
	 * @ordered
	 */
	protected Object dataSetId = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ShapeImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("shape");
		}
	}

	public ShapeImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getShapeId() {
		if (shapeId == SHAPE_ID_EDEFAULT) {
			if (_element != null && _element.hasAttribute("shapeId")) {
				shapeId = _element.getAttribute("shapeId");
			}
		}
		return shapeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShapeId(String newShapeId) {
		shapeId = newShapeId;
		
		if (_element != null) {
			_element.setAttribute("shapeId", newShapeId);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDataSetId() {
		if (dataSetId == null && _element != null) {
			// Search for the reference to DataSet
			String refId = _element.getAttribute("dataSetId");
			Data data = _chart.getData();
			DataSets dataSets = data.getDataSets();
			List dataSetList = dataSets.getDataSet();
			for (int i = 0; i < dataSetList.size(); ++i) {
				DataSet dataSet = (DataSet) dataSetList.get(i);
				if (dataSet.getId().equals(refId)) {
					dataSetId = dataSet;
					break;
				}
			}
		}
		return dataSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDataSetId(Object newDataSetId) {
		dataSetId = newDataSetId;
		
		DataSet dataSet = null;
		String dataSetIdStr;
		try {
			dataSet = (DataSet) newDataSetId;
			dataSetIdStr = dataSet.getId();
			if (_element != null) {
				_element.setAttribute("dataSetId", dataSetIdStr);
			}
		} catch (ClassCastException e) {
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (shapeId: ");
		result.append(shapeId);
		result.append(')');
		return result.toString();
	}

} //ShapeImpl
