/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UnitDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UnitDefinitionImpl.java,v 1.1 2005/03/30 08:26:39 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Unit Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.UnitDefinitionImpl#isShowGridLine <em>Show Grid Line</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.UnitDefinitionImpl#isShowTick <em>Show Tick</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.UnitDefinitionImpl#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class UnitDefinitionImpl extends InputBase implements UnitDefinition {
	/**
	 * The default value of the '{@link #isShowGridLine() <em>Show Grid Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowGridLine()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_GRID_LINE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isShowGridLine() <em>Show Grid Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowGridLine()
	 * @generated
	 * @ordered
	 */
	protected boolean showGridLine = SHOW_GRID_LINE_EDEFAULT;

	/**
	 * This is true if the Show Grid Line attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showGridLineESet = false;

	/**
	 * The default value of the '{@link #isShowTick() <em>Show Tick</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowTick()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SHOW_TICK_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isShowTick() <em>Show Tick</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isShowTick()
	 * @generated
	 * @ordered
	 */
	protected boolean showTick = SHOW_TICK_EDEFAULT;

	/**
	 * This is true if the Show Tick attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean showTickESet = false;

	/**
	 * The default value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected static final double VALUE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getValue() <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValue()
	 * @generated
	 * @ordered
	 */
	protected double value = VALUE_EDEFAULT;

	/**
	 * This is true if the Value attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean valueESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnitDefinitionImpl() {
		super();
	}

	public UnitDefinitionImpl(Chart chart) {
		_chart = chart;
		if (_chart.getElement() != null) {
			_element = _chart.getElement().getOwnerDocument().createElement("unitDefinition");
		}
	}

	public UnitDefinitionImpl(Chart chart, Element element) {
		_chart = chart;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShowGridLine() {
		if (showGridLine == SHOW_GRID_LINE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("showGridLine")) {
				// Convert to boolean, default is FALSE
				String attr = _element.getAttribute("showGridLine");
				if (attr.length() != 0) {
					if (attr.equalsIgnoreCase("true")) {
						showGridLine = true;
					}
					showGridLineESet = true;
				}
			}
		}
		return showGridLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShowGridLine(boolean newShowGridLine) {
		showGridLine = newShowGridLine;
		showGridLineESet = true;
		
		if (_element != null) {
			if (showGridLine) {
				_element.setAttribute("showGridLine", "true");
			} else {
				_element.setAttribute("showGridLine", "false");
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShowGridLine() {
		showGridLineESet = false;
		showGridLine = SHOW_GRID_LINE_EDEFAULT;

		if (_element != null && _element.hasAttribute("showGridLine")) {
			_element.removeAttribute("showGridLine");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShowGridLine() {
		if (showGridLineESet == false) {
			isShowGridLine();
		}
		return showGridLineESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isShowTick() {
		if (showTick == SHOW_TICK_EDEFAULT) {
			if (_element != null && _element.hasAttribute("showTick")) {
				// Convert to boolean, default is FALSE
				String attr = _element.getAttribute("showTick");
				if (attr.length() != 0) {
					if (attr.equalsIgnoreCase("true")) {
						showTick = true;
					}
					showTickESet = true;
				}
			}
		}
		return showTick;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setShowTick(boolean newShowTick) {
		showTick = newShowTick;
		showTickESet = true;
		
		if (_element != null) {
			if (showTick) {
				_element.setAttribute("showTick", "true");
			} else {
				_element.setAttribute("showTick", "false");
			}
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetShowTick() {
		showTickESet = false;
		showTick = SHOW_TICK_EDEFAULT;

		if (_element != null && _element.hasAttribute("showTick")) {
			_element.removeAttribute("showTick");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetShowTick() {
		if (showTickESet == false) {
			isShowTick();
		}
		return showTickESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getValue() {
		if (value == VALUE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("value")) {
				// Convert to double
				String attr = _element.getAttribute("value");
				if (attr.length() != 0) {
					value = (new Double(attr)).doubleValue();
					valueESet = true;
				}
			}
		}
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValue(double newValue) {
		value = newValue;
		valueESet = true;
		
		if (_element != null) {
			_element.setAttribute("value", Double.toString(newValue));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetValue() {
		valueESet = false;
		value = VALUE_EDEFAULT;

		if (_element != null && _element.hasAttribute("value")) {
			_element.removeAttribute("value");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetValue() {
		if (valueESet == false) {
			getValue();
		}
		return valueESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (showGridLine: ");
		if (showGridLineESet) result.append(showGridLine); else result.append("<unset>");
		result.append(", showTick: ");
		if (showTickESet) result.append(showTick); else result.append("<unset>");
		result.append(", value: ");
		if (valueESet) result.append(value); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //UnitDefinitionImpl
