/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColorPaletteSetsImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ColorPaletteSetsImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.ColorPaletteSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteSetType;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Color Palette Sets</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.ColorPaletteSetsImpl#getColorPaletteSet <em>Color Palette Set</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.ColorPaletteSetsImpl#getDefaultSetId <em>Default Set Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ColorPaletteSetsImpl implements ColorPaletteSets {
	/**
	 * The default value of the '{@link #getResourceBundle() <em>Resource Bundle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceBundle()
	 * @generated
	 * @ordered
	 */
	protected static final String RESOURCE_BUNDLE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getResourceBundle() <em>Resource Bundle</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getResourceBundle()
	 * @generated
	 * @ordered
	 */
	protected String resourceBundle = RESOURCE_BUNDLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getColorPaletteSet() <em>Color Palette Set</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColorPaletteSet()
	 * @generated
	 * @ordered
	 */
	protected List colorPaletteSet = null;

	/**
	 * The cached value of the '{@link #getDefaultSetId() <em>Default Set Id</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultSetId()
	 * @generated
	 * @ordered
	 */
	protected Object defaultSetId = null;

	protected Element _element;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ColorPaletteSetsImpl() {
		super();
	}

	public ColorPaletteSetsImpl(Element element) {
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getColorPaletteSet() {
		if (colorPaletteSet == null) {
			List elementList = Utilities.getElementList(_element, "colorPaletteSet");
			colorPaletteSet = new ArrayList();
			for (int i = 0; i < elementList.size(); ++i) {
				colorPaletteSet.add(new PaletteSetTypeImpl(this, (Element)elementList.get(i)));
			}
		}
		return colorPaletteSet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDefaultSetId() {
		if (defaultSetId == null) {
			// Search for the reference to ColorPaletteSet
			String refId = _element.getAttribute("defaultSetId");
			List colorPaletteSetList = getColorPaletteSet();
			for (int i = 0; i < colorPaletteSetList.size(); ++i) {
				PaletteSetType paletteSet = (PaletteSetType) colorPaletteSetList.get(i);
				if (paletteSet.getId().equals(refId)) {
					defaultSetId = paletteSet;
					break;
				}
			}
		}
		return defaultSetId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultSetId(Object newDefaultSetId) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getResourceBundle() {
		if (resourceBundle == RESOURCE_BUNDLE_EDEFAULT) {
			if (_element != null && _element.hasAttribute("resourceBundle")) {
				resourceBundle = _element.getAttribute("resourceBundle");
			}
		}
		return resourceBundle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setResourceBundle(String newResourceBundle) {
		Utilities.unimplementedFunction();
	}

} //ColorPaletteSetsImpl
