/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PaletteSetTypeImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PaletteSetTypeImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.ColorPaletteSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteSetType;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteType;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Palette Set Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteSetTypeImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteSetTypeImpl#getPalette <em>Palette</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteSetTypeImpl#getDefaultPaletteId <em>Default Palette Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PaletteSetTypeImpl implements PaletteSetType {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPalette() <em>Palette</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPalette()
	 * @generated
	 * @ordered
	 */
	protected List palette = null;

	/**
	 * The cached value of the '{@link #getDefaultPaletteId() <em>Default Palette Id</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDefaultPaletteId()
	 * @generated
	 * @ordered
	 */
	protected Object defaultPaletteId = null;

	protected ColorPaletteSets _colorPaletteSets;
	protected Element _element;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PaletteSetTypeImpl() {
		super();
	}

	public PaletteSetTypeImpl(ColorPaletteSets colorPaletteSets, Element element) {
		_colorPaletteSets = colorPaletteSets;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		if (id == ID_EDEFAULT) {
			if (_element.hasAttribute("id")) {
				id = _element.getAttribute("id");
			}
		}
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPalette() {
		if (palette == null) {
			List elementList = Utilities.getElementList(_element, "palette");
			palette = new ArrayList();
			for (int i = 0; i < elementList.size(); ++i) {
				palette.add(new PaletteTypeImpl(_colorPaletteSets, (Element)elementList.get(i)));
			}
		}
		return palette;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getDefaultPaletteId() {
		if (defaultPaletteId == null) {
			// Search for the reference to Palette
			String refId = _element.getAttribute("defaultPaletteId");
			List paletteSetList = _colorPaletteSets.getColorPaletteSet();
			for (int j = 0; j < paletteSetList.size(); ++j) {
				PaletteSetType paletteSet = (PaletteSetType) paletteSetList.get(j);
				List paletteList = paletteSet.getPalette();
				for (int i = 0; i < paletteList.size(); ++i) {
					PaletteType palette = (PaletteType) paletteList.get(i);
					if (palette.getId().equals(refId)) {
						defaultPaletteId = palette;
						break;
					}
				}
			}
		}
		return defaultPaletteId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDefaultPaletteId(Object newDefaultPaletteId) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(')');
		return result.toString();
	}

} //PaletteSetTypeImpl
