/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PaletteTypeImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PaletteTypeImpl.java,v 1.1 2005/03/30 08:26:53 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.ColorPaletteSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.palettes.PaletteType;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Palette Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteTypeImpl#getColorList <em>Color List</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteTypeImpl#getDisplayName <em>Display Name</em>}</li>
 *   <li>{@link org.eclipse.tptp.platform.report.chart.svg.internal.palettes.impl.PaletteTypeImpl#getId <em>Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class PaletteTypeImpl implements PaletteType {
	/**
	 * The default value of the '{@link #getColorList() <em>Color List</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColorList()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_LIST_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColorList() <em>Color List</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColorList()
	 * @generated
	 * @ordered
	 */
	protected String colorList = COLOR_LIST_EDEFAULT;

	/**
	 * The default value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplayName()
	 * @generated
	 * @ordered
	 */
	protected static final String DISPLAY_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDisplayName() <em>Display Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDisplayName()
	 * @generated
	 * @ordered
	 */
	protected String displayName = DISPLAY_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	protected ColorPaletteSets _colorPaletteSets;
	protected Element _element;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PaletteTypeImpl() {
		super();
	}

	public PaletteTypeImpl(ColorPaletteSets colorPaletteSets, Element element) {
		_colorPaletteSets = colorPaletteSets;
		_element = element;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getColorList() {
		if (colorList == ID_EDEFAULT) {
			if (_element.hasAttribute("colorList")) {
				colorList = _element.getAttribute("colorList");
			}
		}
		return colorList;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColorList(String newColorList) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		if (id == ID_EDEFAULT) {
			if (_element.hasAttribute("id")) {
				id = _element.getAttribute("id");
			}
		}
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDisplayName() {
		if (displayName == DISPLAY_NAME_EDEFAULT) {
			if (_element != null && _element.hasAttribute("displayName")) {
				displayName = _element.getAttribute("displayName");
			}
		}
		return displayName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDisplayName(String newDisplayName) {
		Utilities.unimplementedFunction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (colorList: ");
		result.append(colorList);
		result.append(", displayName: ");
		result.append(displayName);
		result.append(", id: ");
		result.append(id);
		result.append(')');
		return result.toString();
	}

} //PaletteTypeImpl
