/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Axis.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Axis.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * 
 */
public abstract class Axis extends Part {

	/**
	 * degrees of label text - horizontal or vertical
	 */
	protected double labelDegrees = 0;

	/**
	 * width of axis
	 */
	protected double axisWidth;
	
	protected int marginForMax = 0;
	/**
	 * height of axis
	 */
	protected double axisHeight;
	
	/**
	 * Major Unit definition from input
	 */	
	protected UnitDefinition majorUnitDef;

	/**
	 * Minor Unit definition from input
	 */	
	protected UnitDefinition minorUnitDef;

	/**
	 * A flag to indicate whether major grid lines should be shown
	 */	
	protected boolean showMajorGridLines;
	
	/**
	 * A flag to indicate whether minor grid lines should be shown
	 */	
	protected boolean showMinorGridLines;
	
	/**
	 * A flag to indicate whether major tick marks should be shown
	 */	
	protected boolean showMajorTicks = true;
	
	/**
	 * A flag to indicate whether minor tick marks should be shown
	 */	
	protected boolean showMinorTicks = false;
	
	/**
	 * axis definition  (a pointer to the input DOM)
	 */
	protected AxisDefinition axisDef = null;

	/**
	 * Data value definition  (a pointer to the input DOM)
	 */
	protected DataValue dataValueDef = null;
		
	/**
	 * An object for retriving translated text
	 */
	protected NLString nls;
	

	/**
	 * @param input
	 */
	public Axis(Chart input, NLString nls, double labelDegrees) {
		super(input);
		this.nls = nls;
		this.setLabelDegrees(labelDegrees);
	}

	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public Axis(
		Chart input,
		double x,
		double y,
		double width,
		double height, 
		NLString nls) {
		super(input, x, y, width, height);
		this.nls = nls;
	}

	/**
	 * Gets length of axis
	 * @return
	 */
	abstract public double getAxisLength();
	
	/**
	 * Sets length of axis
	 * @param length
	 */
	abstract public void setAxisLength(double length);
	
	/**
	 * Gets the width of the axis part
	 * @return
	 */
	abstract public double getAxisWidth();
	
	/**
	 * Gets the Height of the axis part
	 * @return
	 */
	abstract public double getAxisHeight();
	
	/**
	 * Sets the coordinates of the point where this axis meets with another axis.
	 * @param x
	 * @param y
	 */
	abstract public void setCrossPoint(double x, double y);
	
	/**
	 * determines if major grid lines should be drawn
	 * @return true if major grid lines should be drawn
	 */
	public boolean isShowMajorGridLines() {
		return showMajorGridLines;
	}

	/**
	 * determines if minor grid lines should be drawn
	 * @return true if minor grid lines should be drawn
	 */
	public boolean isShowMinorGridLines() {
		return showMinorGridLines;
	}
	
	/**
	 * Gets the orientation of the axis
	 * @return orientation
	 */
	abstract public short getAxisOrientation();

	/**
	 * Returns the extra length of the axes in cases where additional padding is needed
	 * @return
	 */
	public double axisExtendedLength(){
		return 0;
	}
	
	public int getMarginForMax() {
		return marginForMax;
	}	
	/**
	 * @return Returns the labelDegrees.
	 */
	public double getLabelDegrees() {
		return labelDegrees;
	}
	/**
	 * @param labelDegrees The labelDegrees to set.
	 */
	public void setLabelDegrees(double labelDegrees) {
		this.labelDegrees = labelDegrees;
	}
}
