/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryHorizontal.java,v 1.3 2005/10/17 19:12:12 sleeloy Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryHorizontal.java,v 1.3 2005/10/17 19:12:12 sleeloy Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * $Revision: 1.3 $
 */
public class AxisCategoryHorizontal extends AxisCategory {


	/**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
	 * line height
	 */
	private final static int LINE_HEIGHT = AXIS_LABEL_FONT_SIZE + 6;

	/**
	 * text direction, true if LTR, false if RTL
	 */
	private boolean isLTR = true;

	/**
	 * Constructor
	 * @param input
	 * @param axisOrientation
	 */
	public AxisCategoryHorizontal(Chart input, boolean isLTR, NLString nls) {
		// label is horizontal by default
		this(input, isLTR, HORIZONTAL, nls);
		
		this.isLTR = isLTR;
	}

	/**
	 * Constructor
	 * @param input
	 * @param axisOrientation
	 * @param labelOrientation
	 */
	public AxisCategoryHorizontal(Chart input, boolean isLTR, short labelOrientation, NLString nls) {
		super(input, labelOrientation, nls);
		this.isLTR = isLTR;
		axisHeight = getAxisHeight();
	}

	/**
	 * Sets the length of the axis.  The method is used by the parent container.
	 * The information is dependent on other axes.
	 * 
	 * @param length
	 */
	public void setAxisLength(double length) {
		axisWidth = length;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#getAxisLength()
	 */
	public double getAxisLength() {
		return axisWidth;
	}
	
	/**
	 * Get height of axis title section
	 * @return height of axis title
	 */
	private int getTitleHeight() {
		if (title == null) {
			return 0;
		}
		return AXIS_TITLE_FONT_SIZE + 14;
	}

	/**
	 * Calculate the height of the axis, which is determined by the number of 
	 * rows of label text. 
	 * @return height of the axis part
	 */
	public double getAxisHeight() {
//		if (labelOrientation == HORIZONTAL) {
//		//LABEL_FONT_SIZE + 5 is the height of each row
//			return getMaxNumOfRowsOfLabels() * LINE_HEIGHT + AXIS_SPACE_BTW_AXIS_AND_LABEL + getTitleHeight();
//		} else {
			return getMaxLabelHeight() + AXIS_SPACE_BTW_AXIS_AND_LABEL + getTitleHeight();
//		}
	}

	/**
	 * Constructs the SVG components of the axis
	 */
	protected void constructPart() {
		// create axis group
		SVGGroup axisGroup = new SVGGroup();
		SVGBase[] axisParts = new SVGBase[5]; //axis line, major tick marks, minor tick marks and labels, title
		axisGroup.setChildren(axisParts);
//		if (axisDef != null) {
//			axisGroup.setIdentifier(axisDef.getId());
//		}
		
		// add axis group to axis svg
		SVGBase[] child = new SVGBase[1];
		child[0] = axisGroup;
		setChildren(child);		
		
		// draw major axis line
		SVGLine axis = new SVGLine();
		axis.setX1("0");
		axis.setY1(Integer.toString(TICK_MARK_LENGTH));
		axis.setX2(Double.toString(axisWidth));
		axis.setY2(Integer.toString(TICK_MARK_LENGTH));
		axis.setStyleClass("axisLines");
		
		SVGGroup axisGroup2 = new SVGGroup();
		SVGBase[] axisGroup2Children = new SVGBase[2];
		axisGroup2Children[0] = axis;
		axisGroup2.setChildren(axisGroup2Children);
		
		if (axisDef != null) {
			// Handle user tooltips
			axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, axisDef.getTooltip(), nls);
		
			// Handle user events
			EventTools.generateUserEvents(axisGroup2, axisDef.getEventHandler());

			// Handle accessibility
			EventTools.generateAccessibility(axisGroup2, axisDef.getAccessibility(), nls);
		}
		
		axisParts[0] = axisGroup2;
		
		// draw ticks (in the middle of each group)
		// 1. define tick mark
		//		<g id="xtickline">
		//			<polyline class="axisTicks" points="0 0 0 -5"/>
		//		</g>

		SVGGroup tickDefGroup = new SVGGroup();
		tickDefGroup.setIdentifier("xtickline");
		
		SVGBase tickDef = drawTickMarks();
		tickDef.setStyleClass("axisTicks");
		tickDef.setIdentifier("xtickline");
		
		SVGBase[] tick = new SVGBase[1];
		tick[0] = tickDef; 
		tickDefGroup.setChildren(tick);
		
		addDefinition(tickDef);
		
		// 2. draw major tick marks
		// <use xlink:href="#xtickline" x="___" y="0"/>
		if (showMajorTicks) {
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[categoryList.size() + 1];
			axisParts[1] = tickGroup;
			tickGroup.setChildren(ticks);
		
			double[] tickPositions = getGroupBoundaryPositions();
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#xtickline");
				useTick.setXCoordinate(Double.toString(tickPositions[i]));
				useTick.setYCoordinate(Integer.toString(TICK_MARK_LENGTH));
				ticks[i] = useTick;
			}
		}
		
		// 3. draw minor tick marks
		// <use xlink:href="#xtickline" x="___" y="0"/>
		if (showMinorTicks) {
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[categoryList.size()];
			axisParts[2] = tickGroup;
			tickGroup.setChildren(ticks);
		
			double[] tickPositions = getGroupDataPositions();
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#xtickline");
				useTick.setXCoordinate(Double.toString(tickPositions[i]));
				useTick.setYCoordinate(Integer.toString(TICK_MARK_LENGTH));
				ticks[i] = useTick;
			}
		}
		
		// 4. draw labels
		if (labelOrientation == HORIZONTAL) {
			axisParts[3] = drawHorizontalLabels();
		} else {
			axisParts[3] = drawVerticalLabels();
		}
		
		// 5. draw axis title
		if (title != null) {
			SVGText svgTitle = new SVGText();
			svgTitle.setText(title);
			svgTitle.setXCoordinate(Double.toString(getAxisLength()/2));
			svgTitle.setYCoordinate(Double.toString(getAxisHeight()));
			svgTitle.setStyleClass("axisTitles anchorAtMiddle");
			svgTitle.setIdentifier("SVGGEN_labelsValues0");
			axisParts[4] = svgTitle;
		}
	}
	
	/**
	 * Constructs the horizontal labels for the horizontal category axis.
	 */
	protected SVGBase drawHorizontalLabels() {
		SVGGroup labelGroup = new SVGGroup();
		SVGBase[] labels = new SVGBase[categoryList.size()];
		labelGroup.setChildren(labels);
		double[] labelPositions = getGroupDataPositions();
		for (int i=0; i<labelPositions.length; i++) {
			int currentY = AXIS_LABEL_FONT_SIZE/2 + TICK_MARK_LENGTH + AXIS_SPACE_BTW_AXIS_AND_LABEL;
			int categoryIndex = isLTR ? i : (labelPositions.length - i - 1);
			Category category = (Category) categoryList.get(categoryIndex); 
			if (category.getLabel() != null) {
				String rows[] = wrapLabel(nls.getString(category.getLabel()));

				SVGGroup label = new SVGGroup();
				SVGBase[] rowText = new SVGBase[rows.length+1];
				label.setChildren(rowText);
				label.setIdentifier(category.getId());
				
				// Handle user tooltips
				rowText[rows.length] = EventTools.generateUserTooltip(label, category.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(label, category.getEventHandler());

				// Handle accessibility
				EventTools.generateAccessibility(label, category.getAccessibility(), nls);
				double labelDegreesTemp = labelDegrees;
				if (rows.length > 1){
					labelDegreesTemp = 0;		
					label.setTransformation("rotate("+labelDegrees+","+labelPositions[i]+","+(currentY+rows.length*LINE_HEIGHT/2)+")");
				}
				for (int j=0; j<rows.length; j++) {
					AxisLabel labelLine = new AxisLabel(AxisLabel.EAST, AxisLabel.BELOW);
					labelLine.setDegrees(labelDegreesTemp);
					labelLine.setXCoordinate(Double.toString(labelPositions[i]));
					labelLine.setYCoordinate(Integer.toString(currentY));						
//					labelLine.setStyleClass("axisLabels anchorAtStart");
					labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
					labelLine.setText(rows[j]);
					currentY += LINE_HEIGHT;
					rowText[j] = labelLine;
				}
				labels[i] = label;
			}
		}
		return labelGroup;
	}

	/**
	 * Constructs the vertical labels for the horizontal category axis.
	 */
	protected SVGBase drawVerticalLabels() {
		return null;
	}

	/**
	 * Sets the x,y coordinates of the axis component
	 */
	public void setCrossPoint(double x, double y) {
		setXCoordinate(Double.toString(x));
		setYCoordinate(Double.toString(y - TICK_MARK_LENGTH));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisWidth()
	 */
	public double getAxisWidth() {
		// this method is not used
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisOrientation()
	 */
	public short getAxisOrientation() {
		return HORIZONTAL;
	}
	
	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		tickDef.setPoints("0 0 0 -" + TICK_MARK_LENGTH);
		return tickDef;
	}
}
