/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryHorizontal3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * @author sleeloy
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class AxisCategoryHorizontal3D extends AxisCategoryHorizontal {
	static final long serialVersionUID = 9151140042777821124L;
	protected double x3Doffset;
	protected double y3Doffset;

	/**
	 * Constructor for AxisCategoryHorizontal3D.
	 * @param input
	 * @param isLTR
	 */
	public AxisCategoryHorizontal3D(Chart input, boolean isLTR, double x3Doffset, double y3Doffset, NLString nls) {
		super(input, isLTR, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;		
	}

	/**
	 * Constructor for AxisCategoryHorizontal3D.
	 * @param input
	 * @param isLTR
	 * @param labelOrientation
	 */
	public AxisCategoryHorizontal3D(
		Chart input,
		boolean isLTR,
		short labelOrientation, double x3Doffset, double y3Doffset,
		NLString nls) {
		super(input, isLTR, labelOrientation, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;
	}
	
	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		tickDef.setPoints("0 0 " + (x3Doffset) + " " +(-y3Doffset)); // "0 0 5 0"
		return tickDef;
	}

}
