/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryVertical.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryVertical.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * Implementation of vertical category axis
 */
public class AxisCategoryVertical extends AxisCategory {
	static final long serialVersionUID = -6236256611860054814L;

	/**
	 * The maximum number of characters of the labels
	 */
	protected double maxLabelLength = 0;
	
	/**
	 * position of the vertical axis. True if it is on the left, false if it is on the right.
	 */
	protected boolean left = true;
	
	/**
	 * @param input
	 */
	public AxisCategoryVertical(Chart input, boolean isLTR, NLString nls) {
		// label is horizontal by default
		this(input, isLTR, HORIZONTAL, nls, 0);
	}

	/**
	 * @param input
	 * @param labelOrientation
	 */
	public AxisCategoryVertical(Chart input, boolean isLTR, short labelOrientation, NLString nls) {
		this(input, isLTR, labelOrientation, nls, 0);
	}
	public AxisCategoryVertical(Chart input, boolean isLTR, short labelOrientation, NLString nls, double labelDegrees) {
		super(input, labelOrientation, nls, labelDegrees);
		
		maxLabelLength = getMaxLabelLength();

		if (!isLTR) {
			left = false;
		}
	}

	/**
	 * Find the appoximate width of the labels
	 * @return
	 */
	protected double getLabelWidth() {
		return maxLabelLength;
	}
	

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#drawHorizontalLabels(double)
	 */
	protected SVGBase drawHorizontalLabels() {
		double[] labelPositions = getGroupDataPositions();
		SVGGroup labelGroup = new SVGGroup();
		SVGBase[] svglabels = new SVGBase[labelPositions.length];
		labelGroup.setChildren(svglabels);

		for (int i=0; i<labelPositions.length; i++) {
		//for (int i=labelPositions.length-1; i>=0; i--) {
			Category category = (Category) categoryList.get(i);
			String labelText = category.getLabel();
			
			if (labelText != null) {
				SVGGroup label = new SVGGroup();
				SVGBase[] rowText = new SVGBase[2];
				label.setChildren(rowText);
				label.setIdentifier(category.getId());
				
				// Handle user tooltips
				rowText[1] = EventTools.generateUserTooltip(label, category.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(label, category.getEventHandler());

				// Handle accessibility
				EventTools.generateAccessibility(label, category.getAccessibility(), nls);

				AxisLabel labelLine = null;
				if (left) {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.ABOVE);
					labelLine.setDegrees(labelDegrees);
//					labelLine.setAnchorStyle(IConstants.TEXT_ANCHOR_END);
					labelLine.setXCoordinate(Double.toString(getTitleWidth() + this.getLabelWidth()));
					labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i]));// + AXIS_LABEL_FONT_SIZE/2));
//					labelLine.setStyleClass("axisLabels anchorAtEnd");
				} else {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.BELOW);
					labelLine.setDegrees(labelDegrees);
					labelLine.setXCoordinate(Double.toString(TICK_MARK_LENGTH + AXIS_SPACE_BTW_AXIS_AND_LABEL));
					labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i]));// + AXIS_LABEL_FONT_SIZE/2));
//					labelLine.setStyleClass("axisLabels anchorAtStart");
				}
				labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
				labelLine.setText(nls.getString(labelText));
				rowText[0] = labelLine;
				
				svglabels[i] = label;
			}
		}
		return labelGroup;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#drawVerticalLabels(double)
	 */
	protected SVGBase drawVerticalLabels() {
		// TODO support vertical labels
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#setAxisLength(double)
	 */
	public void setAxisLength(double length) {
		axisHeight = length;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#getAxisLength()
	 */
	public double getAxisLength() {
		return axisHeight;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#setCrossPoint(double, double)
	 */
	public void setCrossPoint(double x, double y) {
		if (left) {
			setXCoordinate(Double.toString(x - getAxisWidth() + TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength()));
		} else {
			setXCoordinate(Double.toString(x - TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength()));
		}
	}

	protected double getTitleWidth() {
		if (title == null) {
			return 0;
		}
		return AXIS_TITLE_FONT_SIZE + 5;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		setYCoordinate(""+(Double.parseDouble(getYCoordinate())-marginForMax));
		// create axis group
		SVGGroup axisGroup = new SVGGroup();
		axisGroup.setTransformation("translate(0,"+marginForMax+")");
		SVGBase[] axisParts = new SVGBase[5]; //axis line, major tick marks, minor tick marks and labels, title
		axisGroup.setChildren(axisParts);
//		if (axisDef != null) {
//			axisGroup.setIdentifier(axisDef.getId());
//		}

		// add axis group to axis svg
		SVGBase[] child = new SVGBase[1];
		child[0] = axisGroup;
		setChildren(child);

		// draw major axis line
		SVGLine axis = new SVGLine();
		String axis_x;
		if (left) {
			axis_x = Double.toString(getTitleWidth() + getLabelWidth() + AXIS_SPACE_BTW_AXIS_AND_LABEL);
		} else {
			axis_x = Integer.toString(TICK_MARK_LENGTH);
		}
		axis.setX1(axis_x);
		axis.setY1("0");
		axis.setX2(axis_x);
		axis.setY2(Double.toString(axisHeight));
		axis.setStyleClass("axisLines");
		
		SVGGroup axisGroup2 = new SVGGroup();
		SVGBase[] axisGroup2Children = new SVGBase[2];
		axisGroup2Children[0] = axis;
		axisGroup2.setChildren(axisGroup2Children);
		
		if (axisDef != null) {
			// Handle user tooltips
			axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, axisDef.getTooltip(), nls);

			// Handle user events
			EventTools.generateUserEvents(axisGroup2, axisDef.getEventHandler());

			// Handle accessibility
			EventTools.generateAccessibility(axisGroup2, axisDef.getAccessibility(), nls);
		}
		
		axisParts[0] = axisGroup2;
		
		// draw ticks (in the middle of each group)
		// 1. define tick mark
		//		<g id="xtickline">
		//			<polyline class="axisTicks" points="0 0 0 -5"/>
		//		</g>

		SVGGroup tickDefGroup = new SVGGroup();
		tickDefGroup.setIdentifier("tickline");
		
		SVGBase tickDef = drawTickMarks();
		tickDef.setStyleClass("axisTicks");
		tickDef.setIdentifier("tickline");
		
		SVGBase[] tick = new SVGBase[1];
		tick[0] = tickDef; 
		tickDefGroup.setChildren(tick);
		
		addDefinition(tickDef);

		// 2. create group for ticks
		// <use xlink:href="#xtickline" x="___" y="0"/>
		// major ticks
		if (showMajorTicks) {
			double[] tickPositions = getGroupBoundaryPositions();
			
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[tickPositions.length];
			axisParts[1] = tickGroup;
			tickGroup.setChildren(ticks);
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tickPositions[i]));
				ticks[i] = useTick;
			}
		}
		
		// minor ticks
		if (showMinorTicks) {
			double[] tickPositions = getGroupDataPositions();
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[tickPositions.length];
			axisParts[2] = tickGroup;
			tickGroup.setChildren(ticks);
			
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tickPositions[i]));
				ticks[i] = useTick;
			}
		}
		
		// 3. draw labels
		if (labelOrientation == HORIZONTAL) {
			axisParts[3] = drawHorizontalLabels();
		} else {
			axisParts[3] = drawVerticalLabels();
		}
		
		// 4. draw axis title
		if (title != null) {
			String title_x;
			if (left) {
				title_x = Double.toString(AXIS_TITLE_FONT_SIZE);
			} else {
				title_x = Double.toString(getAxisWidth());
			}
			SVGText svgTitle = new SVGText();
			svgTitle.setText(title);
			String xanchor = title_x;
			String yanchor = Double.toString(getAxisLength()/2);
			svgTitle.setXCoordinate(xanchor);
			svgTitle.setYCoordinate(yanchor);
			svgTitle.setStyleClass("axisTitles anchorAtMiddle");
			svgTitle.setTransformation("rotate(270," + xanchor + ","+yanchor+")");
			svgTitle.setIdentifier("SVGGEN_labelsValues0");
			axisParts[4] = svgTitle;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisWidth()
	 */
	public double getAxisWidth() {
		if (labelOrientation == HORIZONTAL) {
			return getLabelWidth() + AXIS_SPACE_BTW_AXIS_AND_LABEL + TICK_MARK_LENGTH + getTitleWidth();
		}
		// TODO axis width for vertical label
		//return LINE_HEIGHT + SPACE_BTW_AXIS_AND_LABEL + TICK_MARK_LENGTH + getTitleWidth();
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisHeight()
	 */
	public double getAxisHeight() {
		// not used for vertical axes
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisOrientation()
	 */
	public short getAxisOrientation() {
		return VERTICAL;
	}
	
	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		tickDef.setPoints("0 0 " + TICK_MARK_LENGTH + " 0"); // "0 0 5 0"
		return tickDef;
	}

	public int getMarginForMax() {
		if ((categoryList == null) || (categoryList.size() == 0)) return 0;
		if (((left) && (labelDegrees <= 90)&& (labelDegrees >= 0)) || ((!left) && (labelDegrees > 90))) return 0;
		Category category = (Category) categoryList.get((categoryList.size()-1));
		String labelText = category.getLabel();
		String maxLabel = nls.getString(labelText);

		FontHelper fontHelper = new FontHelper();
		fontHelper.setFontSize(IConstants.AXIS_LABEL_FONT_SIZE);
		marginForMax =(int)(fontHelper.getStringWidth(maxLabel, labelDegrees)/2);
		return marginForMax;
	}
	

}
