/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisCategoryVertical3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * @author sleeloy
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class AxisCategoryVertical3D extends AxisCategoryVertical {
	static final long serialVersionUID = 2184364356962451015L;
	protected double x3Doffset;
	protected double y3Doffset;
	

	/**
	 * Constructor for AxisCategoryVertical3D.
	 * @param input
	 * @param isLTR
	 */
	public AxisCategoryVertical3D(Chart input, boolean isLTR,	double x3Doffset,	double y3Doffset, NLString nls) {
		super(input, isLTR, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;
	}

	/**
	 * Constructor for AxisCategoryVertical3D.
	 * @param input
	 * @param isLTR
	 * @param labelOrientation
	 */
	public AxisCategoryVertical3D(
		Chart input,
		boolean isLTR,
		short labelOrientation,
		double x3Doffset,
		double y3Doffset,
		NLString nls) {
		super(input, isLTR, labelOrientation, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;
	}
	
	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		if (left)
			tickDef.setPoints(x3Doffset +" "+(-y3Doffset)+" 0 0");
		else			
			//shift to the right
			tickDef.setPoints((x3Doffset+x3Doffset) +" "+(-y3Doffset)+" "+x3Doffset+" 0");
		return tickDef;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#drawHorizontalLabels(double)
	 */
	protected SVGBase drawHorizontalLabels() {
		double[] labelPositions = getGroupDataPositions();
		SVGGroup labelGroup = new SVGGroup();
		SVGBase[] svglabels = new SVGBase[labelPositions.length];
		labelGroup.setChildren(svglabels);

		for (int i=0; i<labelPositions.length; i++) {
		//for (int i=labelPositions.length-1; i>=0; i--) {
			Category category = (Category) categoryList.get(i);
			String labelText = category.getLabel();
			
			if (labelText != null) {
				SVGGroup label = new SVGGroup();
				SVGBase[] rowText = new SVGBase[2];
				label.setChildren(rowText);
				label.setIdentifier(category.getId());
				
				// Handle user tooltips
				rowText[1] = EventTools.generateUserTooltip(label, category.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(label, category.getEventHandler());

				// Handle accessibility
				EventTools.generateAccessibility(label, category.getAccessibility(), nls);

				AxisLabel labelLine = null;
				if (left) {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.ABOVE);
		//			labelLine.setAnchorStyle(IConstants.TEXT_ANCHOR_END);
					labelLine.setXCoordinate(Double.toString(getTitleWidth() + getLabelWidth()));
					labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i]+y3Doffset));
	//				labelLine.setStyleClass("axisLabels anchorAtEnd");
				} else {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.BELOW);
					labelLine.setXCoordinate(Double.toString(TICK_MARK_LENGTH + AXIS_SPACE_BTW_AXIS_AND_LABEL));
					labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i]+y3Doffset));
		//			labelLine.setStyleClass("axisLabels anchorAtStart");
				}
				labelLine.setDegrees(labelDegrees);
				labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
				labelLine.setText(nls.getString(labelText));

				rowText[0] = labelLine;
				
				svglabels[i] = label;
			}
		}
		return labelGroup;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartCategoryAxis#setCrossPoint(double, double)
	 */
	public void setCrossPoint(double x, double y) {
		if (left) {
			setXCoordinate(Double.toString(x - getAxisWidth() + TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength()- y3Doffset));
		} else {
			setXCoordinate(Double.toString(x - TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength() - y3Doffset));
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		setYCoordinate(""+(Double.parseDouble(getYCoordinate())-marginForMax));
		// create axis group
		SVGGroup axisGroup = new SVGGroup();
		axisGroup.setTransformation("translate(0,"+marginForMax+")");
		SVGBase[] axisParts = new SVGBase[5]; //axis line, major tick marks, minor tick marks and labels, title
		axisGroup.setChildren(axisParts);
		if (axisDef != null) {
			axisGroup.setIdentifier(axisDef.getId());
		}

		// add axis group to axis svg
		SVGBase[] child = new SVGBase[1];
		child[0] = axisGroup;
		setChildren(child);

		// draw major axis line
		SVGLine axis = new SVGLine();
		String axis_x;
		if (left) {
			axis_x = Double.toString(getTitleWidth() + getLabelWidth() + AXIS_SPACE_BTW_AXIS_AND_LABEL);
		} else {
			axis_x = Integer.toString(TICK_MARK_LENGTH);
		}
		axis.setX1(axis_x);
//		axis.setY1("0");
		axis.setY1(Double.toString(y3Doffset));
		axis.setX2(axis_x);
		axis.setY2(Double.toString(y3Doffset+axisHeight));
		axis.setStyleClass("axisLines");
		
		SVGGroup axisGroup2 = new SVGGroup();
		SVGBase[] axisGroup2Children = new SVGBase[2];
		axisGroup2Children[0] = axis;
		axisGroup2.setChildren(axisGroup2Children);
		
		if (axisDef != null) {
			// Handle user tooltips
			axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, axisDef.getTooltip(), nls);

			// Handle user events
			EventTools.generateUserEvents(axisGroup2, axisDef.getEventHandler());

			// Handle accessibility
			EventTools.generateAccessibility(axisGroup2, axisDef.getAccessibility(), nls);
		}
		
		axisParts[0] = axisGroup2;
		
		// draw ticks (in the middle of each group)
		// 1. define tick mark
		//		<g id="xtickline">
		//			<polyline class="axisTicks" points="0 0 0 -5"/>
		//		</g>

		SVGGroup tickDefGroup = new SVGGroup();
		tickDefGroup.setIdentifier("tickline");
		
		SVGBase tickDef = drawTickMarks();
		tickDef.setStyleClass("axisTicks");
		tickDef.setIdentifier("tickline");
		
		SVGBase[] tick = new SVGBase[1];
		tick[0] = tickDef; 
		tickDefGroup.setChildren(tick);
		
		addDefinition(tickDef);

		// 2. create group for ticks
		// <use xlink:href="#xtickline" x="___" y="0"/>
		// major ticks
		if (showMajorTicks) {
			double[] tickPositions = getGroupBoundaryPositions();
			
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[tickPositions.length];
			axisParts[1] = tickGroup;
			tickGroup.setChildren(ticks);
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tickPositions[i]+y3Doffset));
				ticks[i] = useTick;
			}
		}
		
		// minor ticks
		if (showMinorTicks) {
			double[] tickPositions = getGroupDataPositions();
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[tickPositions.length];
			axisParts[2] = tickGroup;
			tickGroup.setChildren(ticks);
			
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < tickPositions.length; i++) {
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tickPositions[i]+y3Doffset));
				ticks[i] = useTick;
			}
		}
		
		// 3. draw labels
		if (labelOrientation == HORIZONTAL) {
			axisParts[3] = drawHorizontalLabels();
		} else {
			axisParts[3] = drawVerticalLabels();
		}
		
		// 4. draw axis title
		if (title != null) {
			String title_x;
			if (left) {
				title_x = Double.toString(AXIS_TITLE_FONT_SIZE);
			} else {
				title_x = Double.toString(getAxisWidth());
			}
			SVGText svgTitle = new SVGText();
			svgTitle.setText(nls.getString(title));
			String xanchor = title_x;
			String yanchor = Double.toString(getAxisLength()/2);
			svgTitle.setXCoordinate(xanchor);
			svgTitle.setYCoordinate(""+(Double.parseDouble(yanchor)+y3Doffset));
			svgTitle.setStyleClass("axisTitles anchorAtMiddle");
			svgTitle.setTransformation("rotate(270," + xanchor + ","+yanchor+")");
			svgTitle.setIdentifier("SVGGEN_labelsValues0");
			axisParts[4] = svgTitle;
		}
	}

}
