/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisLabel.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisLabel.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.awt.Font;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRotateText;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class AxisLabel extends SVGRotateText {
	protected int direction;
	protected int position;
	public static final int NORTH = 0;
	public static final int SOUTH = 1;
	public static final int EAST = 2;
	public static final int WEST = 3;
	public static final int ABOVE = 0;
	public static final int BELOW = 1;
	static final long serialVersionUID = 4073547883552478212L;	
	public AxisLabel(int direction, int position){
		this.direction = direction;
		this.position = position;
	}
	/**
	 * @return Returns the direction.
	 */
	public int getDirection() {
		return direction;
	}
	/**
	 * @param direction The direction to set.
	 */
	public void setDirection(int direction) {
		this.direction = direction;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGBase#doImplementation(org.w3c.dom.Document)
	 */
	public Element doImplementation(Document svgDocument) throws DOMException,
			NullPointerException {
//		Element normLabel = super.doImplementation(svgDocument);
		implementation = super.doImplementation(svgDocument);
		int fontSize = Integer.parseInt(this.getFontSize());
		double midPointY = 0;
		double midPointX = 0;
		double radDegrees = (degrees)*Math.PI/180;
		
//		if (direction == EAST || direction == WEST){			
//			midPointY = fontSize / 2 * Math.cos(radDegrees);
//			if (position == ABOVE) midPointY = 	-midPointY;		
//		}
//		else{
//			midPointY = 0;
////			midPointY = fontSize / 2 * Math.cos(radDegrees);
////			midPointX = fontSize / 2 * Math.sin(radDegrees);
//			if (position == ABOVE) midPointX = 	-midPointX;		
//		}
		if (direction == EAST || direction == WEST){			
		if (anchorStyle == IConstants.TEXT_ANCHOR_START){
			midPointX = -fontSize/2* Math.abs(Math.sin(radDegrees));
			if (degrees > 90)
				midPointY = -(fontSize/2* Math.abs(Math.sin(radDegrees)));
			else
				midPointY = fontSize/2* Math.abs(Math.sin(radDegrees));
		}
		else if (anchorStyle == IConstants.TEXT_ANCHOR_END){
			midPointX = fontSize/2* Math.abs(Math.sin(radDegrees));
			if (degrees > 90)
				midPointY = -(fontSize/2* Math.abs(Math.cos(radDegrees)));			
			else
				midPointY = fontSize/2* Math.abs(Math.cos(radDegrees));			
		}
		else {
			midPointY = fontSize;		
			if (degrees == 180)
				midPointY = fontSize/2;
		}
		}
		else{
			if (anchorStyle == IConstants.TEXT_ANCHOR_START){
				if (degrees > 90)
					midPointX = -(fontSize/2* Math.abs(Math.sin(radDegrees)));
				else
					midPointX = (fontSize/2* Math.abs(Math.cos(radDegrees)));
				if (degrees < 0)
					midPointY = -(fontSize/2* Math.abs(Math.sin(radDegrees)));
				else
					midPointY = fontSize/2* Math.abs(Math.sin(radDegrees));
			}
			else if (anchorStyle == IConstants.TEXT_ANCHOR_END){
				if (degrees > 90)
					midPointX = -(fontSize/2* Math.abs(Math.cos(radDegrees)));
				else
					midPointX = (fontSize/2* Math.abs(Math.cos(radDegrees)));
				if (degrees < 0)
					midPointY = -(fontSize/2* Math.abs(Math.sin(radDegrees)));
				else
					midPointY = fontSize/2* Math.abs(Math.sin(radDegrees));
			}
			else {
				if (position == ABOVE)
					midPointX = -fontSize;	
				else{
					midPointX = fontSize;
				}
				if ((degrees == 180) || (degrees == 0))
						midPointX = fontSize/2;
			//	midPointY = fontSize/4;		
			}
		}
		double translateDegrees = 0;
		if (direction == NORTH){ 
			translateDegrees = degrees - 90;
			if ((position == ABOVE) && ((degrees  % 180) == 0) && (degrees != 0)) translateDegrees+= 180;
		
		}
		else if (direction == EAST){
//			translateDegrees = degrees;
//			if (degrees> 0 && degrees < 90)
//				translateDegrees = degrees-90;
//			else
				translateDegrees = degrees*(-1);
		}
		else if (direction == WEST){
			translateDegrees = degrees - 180;
		}
		else if (direction == SOUTH){
			translateDegrees = -1*(degrees - 90);
		}
		
		implementation.setAttribute("transform", "translate("+(Double.parseDouble(this.getXCoordinate())+midPointX)+","+(Double.parseDouble(this.getYCoordinate())+midPointY)+
				                   ") rotate("+translateDegrees+") translate("+0+","+0+")");
		if (this.getXCoordinate() != null) {
			implementation.removeAttribute("x");
		}	
		
		if (this.getYCoordinate() != null) {
			implementation.removeAttribute("y");
		}
		
		boundingBox = SVGRotateText.getBoundingBox(this.getText(), 0, new Font("arial", Font.PLAIN, IConstants.BASE_FONT_SIZE));

		Element rect = svgDocument.createElement("rect");
		rect.setAttribute("x",(Double.parseDouble(this.getXCoordinate()))+"" );
		rect.setAttribute("y",(Double.parseDouble(this.getYCoordinate()))+"" );
		rect.setAttribute("height",(1)+"" );
		rect.setAttribute("width",(1)+"" );
		rect.setAttribute("fill","red" );
		
		Element group = svgDocument.createElement("g");
		group.appendChild(rect);
		group.appendChild(implementation);
//		group.appendChild(normLabel);
		return implementation;
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGRotateText#setDegrees(double)
	 */
	public void setDegrees(double degrees) {
		degrees = degrees % 360;
		////////////////////////////////////////////////////////////////////////////
		//Set anchor depending on rotation and position of label relative to axis
		////////////////////////////////////////////////////////////////////////////
		switch (direction){
		case EAST:
		case WEST:			
			if (degrees == 0 || degrees == 180){
				setAnchorStyle(IConstants.TEXT_ANCHOR_MIDDLE);
			}
			else if (degrees < 0){
				setAnchorStyle(IConstants.TEXT_ANCHOR_START);									
			}
			else if (degrees <= 180){
				setAnchorStyle(IConstants.TEXT_ANCHOR_END);					
			}
			else{
				setAnchorStyle(IConstants.TEXT_ANCHOR_START);					
			}
		break;
		case NORTH:
		case SOUTH:
			if (degrees == 0 || degrees == 180){
				setAnchorStyle(IConstants.TEXT_ANCHOR_MIDDLE);
			}
			else{
				if (position == ABOVE){
					if (degrees < 0)
						setAnchorStyle(IConstants.TEXT_ANCHOR_START);									
					else
						setAnchorStyle(IConstants.TEXT_ANCHOR_END);									
				}
				else{
						setAnchorStyle(IConstants.TEXT_ANCHOR_START);									
				}
			}
	}
		
		super.setDegrees(degrees);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.generator.svg.SVGRotateText#setAnchorStyle(int)
	 */
	public void setAnchorStyle(int anchorStyle) {
		super.setAnchorStyle(anchorStyle);
		switch (anchorStyle){
		case IConstants.TEXT_ANCHOR_END:
			setStyleClass("axisLabels anchorAtEnd");
			break;
		case IConstants.TEXT_ANCHOR_MIDDLE:
			setStyleClass("axisLabels anchorAtMiddle");
			break;
		case IConstants.TEXT_ANCHOR_START:
			setStyleClass("axisLabels anchorAtStart");
			break;
		}
	}
}
