/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisNumberVertical.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisNumberVertical.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 *
 */
public class AxisNumberVertical extends AxisNumber {
	static final long serialVersionUID = 4579202889483253736L;
	/**
	 * position of the vertical axis. True if it is on the left, false if it is on the right.
	 */
	protected boolean left = true;
	
	/**
	 * @param input
	 * @param datasets
	 * @param axisType
	 * @param cumulative
	 */
	public AxisNumberVertical(Chart input, boolean isLTR, List datasets, short axisType, boolean cumulative, NLString nls) {
		super(input, datasets, axisType, cumulative, nls, 0);

		if (axisType == AXIS_TYPE_SECONDARY_DEPENDENT_AXIS && isLTR) {
			left = false;
		} else if (axisType == AXIS_TYPE_PRIMARY_DEPENDENT_AXIS && !isLTR) {
			left = false;
		}
	}

	/**
	 * @param input
	 * @param datasets
	 * @param axisType
	 * @param cumulative
	 * @param labelOrientation
	 */
	public AxisNumberVertical(
		Chart input,
		boolean isLTR, 
		Vector datasets,
		short axisType,
		boolean cumulative,
		short labelOrientation,
		NLString nls) {
		super(input, datasets, axisType, cumulative, labelOrientation, nls, 0);

		if (axisType == AXIS_TYPE_SECONDARY_DEPENDENT_AXIS && isLTR) {
			left = false;
		} else if (axisType == AXIS_TYPE_PRIMARY_DEPENDENT_AXIS && !isLTR) {
			left = false;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#setAxisLength(double)
	 */
	public void setAxisLength(double length) {
		axisHeight = length;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#getAxisLength()
	 */
	public double getAxisLength() {
		return axisHeight;
	}
	
	private double getTitleWidth() {
		if (title == null) {
			return 0;
		}
		FontHelper fontHelper = new FontHelper();
		fontHelper.setFontSize(AXIS_TITLE_FONT_SIZE);
		return fontHelper.getHeight()+5;
	}

	/**
	 * Get the width of the axis
	 */	
	public double getAxisWidth() {
//		if (labelOrientation == HORIZONTAL) {
			return getLabelHeight() + AXIS_SPACE_BTW_AXIS_AND_LABEL + TICK_MARK_LENGTH + getTitleWidth();
//		}
//		// TODO axis width for vertical label
//		//return LINE_HEIGHT + SPACE_BTW_AXIS_AND_LABEL + TICK_MARK_LENGTH + getTitleWidth();
//		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#setCrossPoint(double, double)
	 */
	public void setCrossPoint(double x, double y) {
		if (left) {
			// axis is on the left
			setXCoordinate(Double.toString(x - getAxisWidth() + TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength() - TOP_MARGIN));
		} else {
			// axis is on the right
			setXCoordinate(Double.toString(x - TICK_MARK_LENGTH));
			setYCoordinate(Double.toString(y - getAxisLength() - TOP_MARGIN));
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#drawHorizontalLabels(double[])
	 */
	protected SVGBase drawHorizontalLabels(double[] positions) {
		SVGGroup labelGroup = new SVGGroup();
		SVGBase[] svglabels = new SVGBase[labels.length];
		labelGroup.setChildren(svglabels);

		for (int i=0; i<labels.length; i++) {
			if (labels[i] != null) {
				SVGGroup label = new SVGGroup();
				SVGBase[] rowText = new SVGBase[1];
				label.setChildren(rowText);

			//	SVGRotateText labelLine = new SVGRotateText();
				AxisLabel labelLine = null;
				if (left) {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.ABOVE);
					labelLine.setDegrees(labelDegrees);
//					labelLine.setAnchorStyle(IConstants.TEXT_ANCHOR_END);					
					labelLine.setXCoordinate(Double.toString(getTitleWidth() + getLabelHeight()));
					labelLine.setYCoordinate(Double.toString(positions[i]));
//					labelLine.setStyleClass("axisLabels anchorAtEnd");
					labelLine.setText(labels[i]);
				} else {
					labelLine = new AxisLabel(AxisLabel.NORTH, AxisLabel.BELOW);
					labelLine.setDegrees(labelDegrees);
					labelLine.setXCoordinate(Double.toString(TICK_MARK_LENGTH + AXIS_SPACE_BTW_AXIS_AND_LABEL));
					labelLine.setYCoordinate(Double.toString(positions[i]));
//					labelLine.setStyleClass("axisLabels anchorAtStart");
					labelLine.setText(labels[i]);
				}
				labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
				rowText[0] = labelLine;
				
				svglabels[i] = label;
			}
		}
		return labelGroup;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#drawVerticalLabels(double)
	 */
	protected SVGBase drawVerticalLabels(double[] positions) {
		// TODO draw vertical labels
		return null;
	}

	/**
	 * Constructs the SVG components of the axis
	 */
	protected void constructPart() {
		double[] tick_y_coordinates = new double[majorUnitValues.length];
		setYCoordinate(""+(Double.parseDouble(getYCoordinate())-marginForMax));
		// create axis group
		SVGGroup axisGroup = new SVGGroup();
		axisGroup.setTransformation("translate(0,"+marginForMax+")");
		
		SVGBase[] axisParts = new SVGBase[5]; //axis line, major tick marks, minor tick marks and labels, title
		axisGroup.setChildren(axisParts);
//		if (axisDef != null) {
//			axisGroup.setIdentifier(axisDef.getId());
//		}
		
		// add axis group to axis svg
		SVGBase[] child = new SVGBase[1];
		child[0] = axisGroup;
		setChildren(child);

		// draw major axis line
		SVGLine axis = new SVGLine();
		// L/R
		String axis_x;
		if (left) {
			axis_x = Double.toString(getTitleWidth() + getLabelHeight() + AXIS_SPACE_BTW_AXIS_AND_LABEL);
		} else {
			axis_x = Integer.toString(TICK_MARK_LENGTH);
		}
		axis.setX1(axis_x);
		axis.setY1(Integer.toString(TOP_MARGIN));
		axis.setX2(axis_x);
		axis.setY2(Double.toString(TOP_MARGIN + axisHeight));
		axis.setStyleClass("axisLines");

		SVGGroup axisGroup2 = new SVGGroup();
		SVGBase[] axisGroup2Children = new SVGBase[2];
		axisGroup2Children[0] = axis;
		axisGroup2.setChildren(axisGroup2Children);
		
		if (axisDef != null) {
			// Handle user tooltips
			axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, axisDef.getTooltip(), nls);

			// Handle user events
			EventTools.generateUserEvents(axisGroup2, axisDef.getEventHandler());

			// Handle accessibility
			EventTools.generateAccessibility(axisGroup2, axisDef.getAccessibility(), nls);
		}
		
		axisParts[0] = axisGroup2;
		
		// draw ticks (in the middle of each group)
		// 1. define tick mark
		//		<g id="xtickline">
		//			<polyline class="axisTicks" points="0 0 0 -5"/>
		//		</g>

		SVGGroup tickDefGroup = new SVGGroup();
		tickDefGroup.setIdentifier("tickline");
		
		SVGBase tickDef = drawTickMarks();
		tickDef.setStyleClass("axisTicks");
		tickDef.setIdentifier("tickline");
		
		SVGBase[] tick = new SVGBase[1];
		tick[0] = tickDef; 
		tickDefGroup.setChildren(tick);
		
		addDefinition(tickDef);

		// 2. create group for ticks
		// <use xlink:href="#xtickline" x="___" y="0"/>
		// major ticks

		if (showMajorTicks) {
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[majorUnitValues.length];
			axisParts[1] = tickGroup;
			tickGroup.setChildren(ticks);
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < majorUnitValues.length; i++) {
				double tick_y = getYCoordinate(majorUnitValues[i], TOP_MARGIN, TOP_MARGIN+axisHeight, max, min);
				tick_y_coordinates[i] = tick_y;
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tick_y));
				ticks[i] = useTick;
			}
		} else {
			// calculate positions for labels only
			for (int i=0; i < majorUnitValues.length; i++) {
				double tick_y = getYCoordinate(majorUnitValues[i], TOP_MARGIN, TOP_MARGIN+axisHeight, max, min);
				tick_y_coordinates[i] = tick_y;
			}
		}
		
		// minor ticks
		if (showMinorTicks) {
			SVGGroup tickGroup = new SVGGroup();
			SVGBase[] ticks = new SVGBase[minorUnitValues.length];
			axisParts[2] = tickGroup;
			tickGroup.setChildren(ticks);
			
			String tick_x;
			if (left) {
				tick_x = axis_x;
			} else {
				tick_x = "0";
			}
			
			for (int i=0; i < minorUnitValues.length; i++) {
				double tick_y = getYCoordinate(minorUnitValues[i], TOP_MARGIN, TOP_MARGIN+axisHeight, max, min);
				SVGUse useTick = new SVGUse();
				useTick.setHref("#tickline");
				useTick.setXCoordinate(tick_x);
				useTick.setYCoordinate(Double.toString(tick_y));
				ticks[i] = useTick;
			}
		}
		
		// 3. draw labels
		if (labelOrientation == HORIZONTAL) {
			axisParts[3] = drawHorizontalLabels(tick_y_coordinates);
		} else {
			axisParts[3] = drawVerticalLabels(tick_y_coordinates);
		}
		
		// 4. draw axis title
		if (title != null) {
			String title_x;
			if (left) {
				title_x = Double.toString(getTitleWidth()-5);
			} else {
				title_x = Double.toString(getAxisWidth());
			}
			SVGText svgTitle = new SVGText();
			svgTitle.setText(title);
			String xanchor = title_x;
			String yanchor = Double.toString(TOP_MARGIN + getAxisLength()/2);
			svgTitle.setXCoordinate(xanchor);
			svgTitle.setYCoordinate(yanchor);
			svgTitle.setStyleClass("axisTitles anchorAtMiddle");
			svgTitle.setTransformation("rotate(270," + xanchor + ","+yanchor+")");
			if (axisType == AXIS_TYPE_PRIMARY_DEPENDENT_AXIS) {
				svgTitle.setIdentifier("SVGGEN_labelsValues1");
			} else {
				svgTitle.setIdentifier("SVGGEN_labelsValues2");
			}
			axisParts[4] = svgTitle;
		}
	}

	/**
	 * TODO remove!!! replace with getCoordinate(...) from super class.
	 * @param value
	 * @param max_y
	 * @param min_y
	 * @param max
	 * @param min
	 * @return
	 */
	private double getYCoordinate(double value, double max_y, double min_y, double max, double min) {
		return (value - max) / (min - max) * (min_y - max_y) + max_y;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartNumberAxis#getAxisOrientation()
	 */
	public short getAxisOrientation() {
		return VERTICAL;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartAxis#getAxisHeight()
	 */
	public double getAxisHeight() {
		// This method is not used
		return 0;
	}

	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		tickDef.setPoints("0 0 " + TICK_MARK_LENGTH + " 0"); // "0 0 5 0"		
		return tickDef;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis#getMarginForMax()
	 */
	public int getMarginForMax() {
		marginForMax =  super.getMarginForMax();
		if ((this.labelDegrees > 90) || (this.labelDegrees < 0))marginForMax = 2*(marginForMax +5) - 5;
		return marginForMax;
	}
}
