/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AxisNumberVertical3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * @author sleeloy
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class AxisNumberVertical3D extends AxisNumberVertical {
	static final long serialVersionUID = 664207708456665319L;
	
	protected double x3Doffset;
	protected double y3Doffset;

	/**
	 * Constructor for AxisNumberVertical3D.
	 * @param input
	 * @param isLTR
	 * @param datasets
	 * @param axisType
	 * @param cumulative
	 */
	public AxisNumberVertical3D(
		Chart input,
		boolean isLTR,
		List datasets,
		short axisType,
		boolean cumulative,
		double x3Doffset,
		double y3Doffset,
		NLString nls) {
		super(input, isLTR, datasets, axisType, cumulative, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;
	}

	/**
	 * Constructor for AxisNumberVertical3D.
	 * @param input
	 * @param isLTR
	 * @param datasets
	 * @param axisType
	 * @param cumulative
	 * @param labelOrientation
	 */
	public AxisNumberVertical3D(
		Chart input,
		boolean isLTR,
		Vector datasets,
		short axisType,
		boolean cumulative,
		short labelOrientation,
		double x3Doffset,
		double y3Doffset,
		NLString nls) {
		super(input, isLTR, datasets, axisType, cumulative, labelOrientation, nls);
		this.x3Doffset = x3Doffset;
		this.y3Doffset = y3Doffset;
	}
	
	protected SVGBase drawTickMarks(){
		SVGPolyline tickDef = new SVGPolyline();
		if (left)
			tickDef.setPoints(x3Doffset +" "+(-y3Doffset)+" 0 0");
		else			
			//shift to the right
			tickDef.setPoints((x3Doffset+x3Doffset) +" "+(-y3Doffset)+" "+x3Doffset+" 0");
		return tickDef;
	}

}
