/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSet.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSet.java,v 1.1 2005/03/30 08:26:41 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * 
 */
public abstract class DataSet extends Part {

	/**
	 * data set to be plotted
	 */
	protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
	
	/**
	 * The order of this dataset among the datasets of this chart
	 */
	protected int datasetIndex;
	
	/**
	 * An object for retriving translated text
	 */
	protected NLString nls;
	

	/**
	 * @param input
	 */
	public DataSet(Chart input, NLString nls) {
		super(input);
		this.nls = nls;
	}

	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public DataSet(Chart input, double x, double y, double width, double height, NLString nls) {
		super(input, x, y, width, height);
		this.nls = nls;
	}
	
	/**
	 * Calculate coordinate in linear scale
	 * @param log Scale true if data is to be plotted in log scale, false otherwise
	 * @param value value to be plotted
	 * @param max_coor coordinate of the maximum value of this axis
	 * @param min_coor coordinate of the minimum value of this axis
	 * @param max maximum value of this axis
	 * @param min minimum value of this axis
	 * @return
	 */
	protected double getCoordinate(boolean linear, double value, double max_coor, double min_coor, double max, double min) {
		double plotvalue;
		if (linear) {
			plotvalue = value;
		} else {
			plotvalue = Math.log(value) / Math.log(10);
		}
		return (plotvalue - max) / (min - max) * (min_coor - max_coor) + max_coor;
	}
}
