/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**

 *
 * <code>DataSetBar</code> is class to add bar in the plot area for bar chart.
 * $Revision: 1.2 $  
 */

public class DataSetBar extends DataSet {
	static final long serialVersionUID = 8486538169507992998L;

	/**
	 * Independent axis
	 */
	protected AxisCategory indepAxis;
	
	/**
	 * dependent axis
	 */	
	protected AxisNumber depAxis;
	
	
	protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
	
	/**
	 * An array of sorted data points, 
	 * used only if the independent axis is a category axis
	 */	
	protected CategoricalData[] sortedDatapoints;
	
	
	protected int colorIndex;
	
	/**
	 * The list of categories, used only if the independent axis is a category axis
	 */	
	protected List categoryList;
	
	/**
	 * An array of positions that correspond to each category,
	 * used only if the independent axis is a category axis
	 */	
	protected double[] groupDataPositions;
	
	/**
	 * Maximum value of the dependent axis
	 */	
	protected double depAxisMax;
	
	/**
	 * Minimum value of the dependent axis
	 */	
	protected double depAxisMin;
	
	
	protected double axisLenght;
	
	/**
	 * A flag to show if the dependent axis scale is linear.  
	 * True if it is linear, false othersise.
	 */	
	protected boolean linear;
	
	/**
	 * Width for the each bar Max  = 40.00.  
	 */	
	protected double barWidth;
		
	protected double barPosition;
	protected double groupInterval;
	
	/**
	 * Text direction: true if LTR, false if RTL
	 */
	protected boolean isLTR = true;
	
	/**
	 * color palettes
	 */
	protected SVGColorPalettes palettes = null;
	
	/**
	 * @param input
	 * @param indepAxis
	 * @param depAxis
	 * @param dataset
	 * @param colorIndex
	 * @param barWidth
	 * @param xPosition
	 * @param groupInterval
	 */
	public DataSetBar(
		Chart input, 
		boolean isLTR,
		AxisCategory indepAxis, 
		AxisNumber depAxis, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, 
		int datasetIndex,
		int colorIndex,
		double barWidth,
		double barPosition, 
		double groupInterval, 
		SVGColorPalettes palettes,
		NLString nls) {
			
		super(input, nls);
		this.indepAxis = indepAxis;
		this.depAxis = depAxis;
		this.dataset = dataset;
		this.barWidth = barWidth;
		this.datasetIndex = datasetIndex;
		this.colorIndex = colorIndex;
		this.groupInterval = groupInterval;
		this.barPosition = barPosition;
		this.palettes = palettes;
		this.isLTR = isLTR;
		
		sortDataPoints();
		
		groupDataPositions = indepAxis.getGroupDataPositions();
		this.axisLenght = indepAxis.getAxisLength();
		depAxisMax = depAxis.getMax();
		depAxisMin = depAxis.getMin();
		linear = depAxis.isLinear();
	}

	/**
	 * Sets independent axis
	 * @param axis independent axis
	 */	
	public void setIndepAxis(AxisCategory axis) {
		indepAxis = axis;
	}
	
	/**
	 * Sets dependent axis
	 * @param axis dependent axis
	 */
	public void setDepAxis(AxisNumber axis) {
		depAxis = axis;
	}
	
	/**
	 * Sets the dataset to be plotted
	 * @param dataset
	 */
	public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
		this.dataset = dataset;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		
		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);
		
		// create bar group
		SVGBase[] barpart = new SVGBase[1];
		setChildren(barpart);
		
		SVGGroup barset = new SVGGroup();
		int partNum = sortedDatapoints.length + 2; // n points + a Bar (a group of bars segments) + text
		SVGBase[] barparts = new SVGBase[partNum];
	
		SVGGroup dataColourGroup = new SVGGroup();
		SVGBase[] dataColourGroupChild = new SVGBase[1];
		dataColourGroupChild[0] = dataColourGroup;
		dataColourGroup.setChildren(barparts);
		dataColourGroup.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			dataColourGroup.setFill(dataSetColor);
			dataColourGroup.setStroke(dataSetColor);
		}
	
		barpart[0] = barset;
	
		barset.setChildren(dataColourGroupChild);
		barset.setIdentifier(dataset.getId());
		barset.setStyleClass("bars" + colorIndex);
	
		double previousX = 0;
		double previousY = 0;
		double curX, curY;
		double min = Math.pow(10.0, depAxisMin);
		double value = linear ? 0.0 : min;
		if(indepAxis.getAxisOrientation() == HORIZONTAL){
			double zero = getCoordinate(linear, value, 0.0, Double.parseDouble(getHeight()), depAxisMax, depAxisMin);
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp;
				if (isLTR) {
					dp = sortedDatapoints[i];
				} else {
					dp = sortedDatapoints[categoryList.size() - i - 1];
				}
				if (dp == null || (!linear && dp.getValue() <= 0) ) {
					continue;
				} 
				SVGGroup pointGroup = new SVGGroup();
				pointGroup.setIdentifier(dp.getId() );
				SVGBase[] point = new SVGBase[3];
				pointGroup.setChildren(point);
			
				// A Group wrapper to hold the data value text
				SVGGroup pointGroupWrapper = new SVGGroup();
				SVGBase[] pointWrapper = new SVGBase[2];
				pointWrapper[0] = pointGroup;
				pointGroupWrapper.setChildren(pointWrapper);
	
				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);
	
				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				curX = barPosition + ((double)i*groupInterval); 
				curY = getCoordinate(linear, dp.getValue(), 0.0, Double.parseDouble(getHeight()), depAxisMax, depAxisMin);
				barparts[i+1] = pointGroupWrapper;
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText(depAxis.formatValue(dp.getValue()));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setStyleClass("anchorAtMiddle");
					barTextSegment.setVisibility("hidden");
					barTextSegment.setXCoordinate(Double.toString(curX));
					if(dp.getValue() < 0.0){
						barTextSegment.setYCoordinate(Double.toString(curY + BASE_FONT_SIZE + 2.0));
					}else{
						barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
					}
					barTextSegment.setIdentifier(tooltipID);
					
					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaForeground_"+dataset.getId()+"');");

					SVGLine barSegment = new SVGLine();
					barSegment.setX1(Double.toString(curX));
					barSegment.setY1(Double.toString(zero));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					point[0] = barSegment;
					pointWrapper[1] = barGroup;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;
				} 
				previousX = curX;
				previousY = curY;
			}
		}else{
			double zero;
			if (isLTR) {
				zero = getCoordinate(linear, value, Double.parseDouble(getWidth()), 0.0, depAxisMax, depAxisMin);
			} else {
				zero = getCoordinate(linear, value, 0.0, Double.parseDouble(getWidth()), depAxisMax, depAxisMin);
			}
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp = sortedDatapoints[i];
				if (dp == null || (!linear && dp.getValue() <= 0) ) {
					continue;
				} 
				// add the shape for the datapoint
				SVGGroup pointGroup = new SVGGroup();
				pointGroup.setIdentifier(dp.getId() );				
				SVGBase[] point = new SVGBase[3];
				pointGroup.setChildren(point);
				
				// A Group wrapper to hold the data value text
				SVGGroup pointGroupWrapper = new SVGGroup();
				SVGBase[] pointWrapper = new SVGBase[2];
				pointWrapper[0] = pointGroup;
				pointGroupWrapper.setChildren(pointWrapper);
	
				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);
	
				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				curY = indepAxis.getAxisLength() - (barPosition + ((double)i*groupInterval));
				if (isLTR) {
					curX = getCoordinate(linear, dp.getValue(), depAxis.getAxisLength(), 0.0, depAxisMax, depAxisMin); 
				} else {
					curX = getCoordinate(linear, dp.getValue(), 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
				}
				
				barparts[i+1] = pointGroupWrapper;
	
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText(depAxis.formatValue(dp.getValue()));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setStyleClass("anchorAtStart");
					barTextSegment.setVisibility("hidden");
					if (isLTR) { 
						if(dp.getValue() < 0.0){
							barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
							barTextSegment.setStyleClass("anchorAtEnd");
						}else{
							barTextSegment.setXCoordinate(Double.toString(curX + 2.0));
							barTextSegment.setStyleClass("anchorAtStart");
						}
					} else {
						if(dp.getValue() < 0.0){
							barTextSegment.setXCoordinate(Double.toString(curX + 2.0));
							barTextSegment.setStyleClass("anchorAtStart");
						}else{
							barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
							barTextSegment.setStyleClass("anchorAtEnd");
						}
					}
					barTextSegment.setYCoordinate(Double.toString(curY + (BASE_FONT_SIZE/2.0)));
					barTextSegment.setIdentifier(tooltipID);
	
					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaForeground_"+dataset.getId()+"');");
										
					SVGLine barSegment = new SVGLine();
					barSegment.setX1(Double.toString(zero));
					barSegment.setY1(Double.toString(curY));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					point[0] = barSegment;
					pointWrapper[1] = barGroup;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;
				} 
				previousX = curX;
				previousY = curY;
			}
		}
	}

	/**
	 * Sort data points by category id
	 * The order of categories follow the order specified in the category 
	 * section of the input xml.
	 */
	protected void sortDataPoints() {
		Data data = input.getData();
		
		List datapoints = dataset.getDataPoint();
		
		if (data != null) {
			Categories categories = data.getCategories();
			if (categories != null) {
				categoryList = categories.getCategory();
				sortedDatapoints = new CategoricalData[categoryList.size()];
				for (Iterator i=datapoints.iterator(); i.hasNext(); ) {
					CategoricalData dp = (CategoricalData) i.next();
					int index = categoryList.indexOf(dp.getCategoryId());
					sortedDatapoints[index] = dp;
				}
			}
		}
	}

}
