/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetBar3D.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeComponentTransfer;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeFunc;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

 
/**
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class DataSetBar3D extends DataSetBar {
	static final long serialVersionUID = -4921885635575271217L;
	protected double y3Doffset;
	protected double x3Doffset;
	/**
	 * @param input
	 * @param indepAxis
	 * @param depAxis
	 * @param dataset
	 * @param colorIndex
	 * @param barWidth
	 * @param xPosition
	 * @param groupInterval
	 */
	public DataSetBar3D(
		Chart input, 
		boolean isLTR,
		AxisCategory indepAxis, 
		AxisNumber depAxis, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, 
		int datasetIndex,
		int colorIndex,
		double barWidth,
		double barPosition, 
		double groupInterval, double x3Doffset, double y3Doffset, 
		SVGColorPalettes palettes, 
		NLString nls) {
			
		super(input, isLTR, indepAxis, depAxis, dataset, datasetIndex, colorIndex, barWidth, barPosition, groupInterval, palettes, nls);
		this.y3Doffset = y3Doffset;
		this.x3Doffset = x3Doffset;
		
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		
		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);
		
		// create bar group
		SVGBase[] barpart = new SVGBase[1];
		setChildren(barpart);
		
		SVGGroup barset = new SVGGroup();
		int partNum = sortedDatapoints.length + 2; // n points + a Bar (a group of bars segments) + text
		SVGBase[] barparts = new SVGBase[partNum];

		SVGGroup dataColourGroup = new SVGGroup();
		SVGBase[] dataColourGroupChild = new SVGBase[1];
		dataColourGroupChild[0] = dataColourGroup;
		dataColourGroup.setChildren(barparts);
		dataColourGroup.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			dataColourGroup.setFill(dataSetColor);
			dataColourGroup.setStroke(dataSetColor);
		}
	

		barpart[0] = barset;

		barset.setChildren(dataColourGroupChild);
		barset.setIdentifier(dataset.getId());
		barset.setStyleClass("bars" + colorIndex);

		
				
		//add 3d filters
		
			SVGFilter filter = new SVGFilter();
			filter.setIdentifier("right-dimension");

			SVGFeComponentTransfer[] feComponentTransferPart = new SVGFeComponentTransfer[1];
			SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
			feComponentTransferPart[0] = feComponentTransfer;			
			filter.setChildren(feComponentTransferPart);
			
			SVGFeFunc[] feFuncPart = new SVGFeFunc[3];
			SVGFeFunc feFunc = new SVGFeFunc("R");
			feFunc.setSlope("1");
			feFunc.setIntercept("-0.1");
			feFunc.setType("linear");
			feFuncPart[0] = feFunc;
			
			feFunc = new SVGFeFunc("G");
			feFunc.setSlope("1");
			feFunc.setIntercept("-0.1");
			feFunc.setType("linear");
			feFuncPart[1] = feFunc;
			
			feFunc = new SVGFeFunc("B");
			feFunc.setSlope("1");
			feFunc.setIntercept("-0.1");
			feFunc.setType("linear");
			feFuncPart[2] = feFunc;
			
			feComponentTransfer.setChildren(feFuncPart);
			
			addDefinition(filter);				

		
			filter = new SVGFilter();
			filter.setIdentifier("top-dimension");

			feComponentTransferPart = new SVGFeComponentTransfer[1];
			feComponentTransfer = new SVGFeComponentTransfer();
			feComponentTransferPart[0] = feComponentTransfer;			
			filter.setChildren(feComponentTransferPart);
			
			feFuncPart = new SVGFeFunc[3];
			feFunc = new SVGFeFunc("R");
			feFunc.setSlope("1");
			feFunc.setIntercept("0.1");
			feFunc.setType("linear");
			feFuncPart[0] = feFunc;
			
			feFunc = new SVGFeFunc("G");
			feFunc.setSlope("1");
			feFunc.setIntercept("0.1");
			feFunc.setType("linear");
			feFuncPart[1] = feFunc;
			
			feFunc = new SVGFeFunc("B");
			feFunc.setSlope("1");
			feFunc.setIntercept("0.1");
			feFunc.setType("linear");
			feFuncPart[2] = feFunc;
			
			feComponentTransfer.setChildren(feFuncPart);
			
			addDefinition(filter);				
		
		//end of add 3d filters

		double previousX = 0;
		double previousY = 0;
		double curX, curY;
		double min = Math.pow(10.0, depAxisMin);
		double value = linear ? 0.0 : min;
		if(indepAxis.getAxisOrientation() == HORIZONTAL){
			double zero = getCoordinate(linear, value, 0.0, Double.parseDouble(getHeight())-Math.abs(y3Doffset), depAxisMax, depAxisMin);
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp;
				if (isLTR) {
					dp = sortedDatapoints[i];
				} else {
					dp = sortedDatapoints[categoryList.size() - i - 1];
				}
				if (dp == null || (!linear && dp.getValue() <= 0)  || (!linear && dp.getValue() < min)  || (linear && dp.getValue() < depAxisMin) ) {
					continue;
				} 
				SVGGroup pointGroup = new SVGGroup();
				pointGroup.setIdentifier(dp.getId() );
				SVGBase[] point = new SVGBase[3];
				pointGroup.setChildren(point);
			
				// A Group wrapper to hold the data value text
				SVGGroup pointGroupWrapper = new SVGGroup();
				SVGBase[] pointWrapper = new SVGBase[2];
				pointWrapper[1] = pointGroup;
				pointGroupWrapper.setChildren(pointWrapper);

				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup,depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				curX = barPosition + ((double)i*groupInterval); 
				curY = getCoordinate(linear, dp.getValue(), 0.0, Double.parseDouble(getHeight())-Math.abs(y3Doffset), depAxisMax, depAxisMin);
				barparts[i+1] = pointGroupWrapper;
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText(depAxis.formatValue(dp.getValue()));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setStyleClass("anchorAtMiddle");
					barTextSegment.setVisibility("hidden");
					barTextSegment.setXCoordinate(Double.toString(curX));
					if(dp.getValue() < 0.0){
						barTextSegment.setYCoordinate(Double.toString(curY + BASE_FONT_SIZE+y3Doffset+2.0));
					}else{
						barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
					}
					barTextSegment.setIdentifier(tooltipID);
					
					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaForeground_"+dataset.getId()+"');");

					Line3D barSegment = new Line3D();
					barSegment.setIsNeg(dp.getValue() < 0.0);
					barSegment.setIsLTR(isLTR);
					barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
					barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
					barSegment.setIsHorizontal(true);
					barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					barSegment.setLinear(linear);
					barSegment.setYMax(Double.parseDouble(getHeight()));
					barSegment.setYMin(0);
					barSegment.setZeroYCoord(zero);
					barSegment.setY3Doffset(y3Doffset);
					barSegment.setX3Doffset(x3Doffset);
					barSegment.setX1(Double.toString(curX));
					barSegment.setY1(Double.toString(zero));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					barSegment.setTopDimensionFilter("url(#top-dimension)");
					barSegment.setRightDimensionFilter("url(#right-dimension)");
					
					point[0] = barSegment;					
					pointWrapper[0] = barGroup;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;
				} 
				previousX = curX;
				previousY = curY;
			}
		}else{
			double zero;
			if (isLTR) {
				zero = getCoordinate(linear, value, Double.parseDouble(getWidth())-Math.abs(x3Doffset), 0.0, depAxisMax, depAxisMin);
			} else {
				zero = getCoordinate(linear, value, 0.0, Double.parseDouble(getWidth())-Math.abs(x3Doffset), depAxisMax, depAxisMin);
			}
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp = sortedDatapoints[i];
				if (dp == null || (!linear && dp.getValue() <= 0)  || (!linear && dp.getValue() < min)  || (linear && dp.getValue() < depAxisMin) ) {
					continue;
				} 
				// add the shape for the datapoint
				SVGGroup pointGroup = new SVGGroup();
				pointGroup.setIdentifier(dp.getId() );				
				SVGBase[] point = new SVGBase[3];
				pointGroup.setChildren(point);
				
				// A Group wrapper to hold the data value text
				SVGGroup pointGroupWrapper = new SVGGroup();
				SVGBase[] pointWrapper = new SVGBase[2];
				pointWrapper[1] = pointGroup;
				pointGroupWrapper.setChildren(pointWrapper);

				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				curY = indepAxis.getAxisLength() - (barPosition + ((double)i*groupInterval));
				if (isLTR) {
					curX = getCoordinate(linear, dp.getValue(), depAxis.getAxisLength(), 0.0, depAxisMax, depAxisMin); 
				} else {
					curX = getCoordinate(linear, dp.getValue(), 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
				}
				
				barparts[i+1] = pointGroupWrapper;
	
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText(depAxis.formatValue(dp.getValue()));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setStyleClass("anchorAtStart");
					barTextSegment.setVisibility("hidden");
					if (isLTR) { 
						if(dp.getValue() < 0.0){
							barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
							barTextSegment.setStyleClass("anchorAtEnd");
						}else{
							barTextSegment.setXCoordinate(Double.toString(curX + 2.0+x3Doffset));
							barTextSegment.setStyleClass("anchorAtStart");
						}
					} else {
						if(dp.getValue() < 0.0){
							barTextSegment.setXCoordinate(Double.toString(curX + 2.0+x3Doffset));
							barTextSegment.setStyleClass("anchorAtStart");
						}else{
							barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
							barTextSegment.setStyleClass("anchorAtEnd");
						}
					}
					barTextSegment.setYCoordinate(Double.toString(curY + (BASE_FONT_SIZE/2.0)+y3Doffset));
					barTextSegment.setIdentifier(tooltipID);

					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaForeground_"+dataset.getId()+"');");
										
					Line3D barSegment = new Line3D();
					barSegment.setIsNeg(dp.getValue() < 0.0);
					barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
					barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
					barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					barSegment.setIsLTR(isLTR);
					barSegment.setLinear(linear);
					barSegment.setXMax(depAxis.getAxisLength());
					barSegment.setIsHorizontal(false);					
					barSegment.setXMin(0);
					barSegment.setZeroXCoord(zero);
					barSegment.setY3Doffset(y3Doffset);
					barSegment.setX3Doffset(x3Doffset);
					barSegment.setX1(Double.toString(zero));
					barSegment.setY1(Double.toString(curY));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					barSegment.setTopDimensionFilter("url(#top-dimension)");
					barSegment.setRightDimensionFilter("url(#right-dimension)");
					point[0] = barSegment;
					pointWrapper[0] = barGroup;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;
				} 
				previousX = curX;
				previousY = curY;
			}
		}
	}



}
