/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLine.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLine.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * 
 */
public abstract class DataSetLine extends DataSet {

	/**
	 * Independent axis
	 */
	protected Axis indepAxis;
	
	/**
	 * dependent axis
	 */
	protected AxisNumber depAxis;
	
	/**
	 * An array of sorted data points, 
	 * used only if the independent axis is a category axis
	 */
	protected CategoricalData[] sortedDatapoints;
	
	
	protected int colorIndex;
	
	/**
	 * The list of categories, used only if the independent axis is a category axis
	 */
	protected List categoryList;
	
	/**
	 * An array of positions that correspond to each category,
	 * used only if the independent axis is a category axis
	 */
	protected double[] groupDataPositions;
	
	/**
	 * Maximum value of the dependent axis
	 */
	protected double indepAxisMax;
	
	/**
	 * Minimum value of the dependent axis
	 */
	protected double indepAxisMin;
	
	/**
	 * A flag to show if the dependent axis scale is linear.  
	 * True if it is linear, false othersise.
	 */
	protected boolean indepAxislinear;
	
	/**
	 * Maximum value of the dependent axis
	 */
	protected double depAxisMax;
	
	/**
	 * Minimum value of the dependent axis
	 */
	protected double depAxisMin;
	
	/**
	 * A flag to show if the dependent axis scale is linear.  
	 * True if it is linear, false othersise.
	 */
	protected boolean depAxislinear;
	
	/**
	 * A flag to show if the independent axis uses categories.
	 * True if independent axis is a category axis, false if it is a number axis.
	 */
	protected boolean useCategories;

	/**
	 * A flag to show if the area between the line and the horizontal axis (zero line)
	 * should be filled with color (for area charts)
	 */
	protected boolean showArea;
	
	/**
	 * A flag to indicate whether the shapes should be hidden or visible
	 */
	protected boolean showShapes;
	
	/**
	 * A flag to indicate whether the points should be connected
	 */
	protected boolean showLine;
	
	/**
	 * A flag to show whether shadows for points should be generated
	 */
	protected boolean generateShadows;
	
	/**
	 * Text direction: true if LTR, false if RTL
	 */
	protected boolean isLTR = true;
	
	/**
	 * color palettes
	 */
	protected SVGColorPalettes palettes;
	
	/**
	 * shape ID
	 */
	protected String shapeId;
	
	/**
	 * width of shape
	 */
	protected double shapeWidth;
	
	/**
	 * height of shape
	 */
	protected double shapeHeight;
	
	/**
	 * @param input
	 */
	public DataSetLine(
		Chart input, 
		boolean isLTR,
		Axis indepAxis, 
		AxisNumber depAxis, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, 
		int datasetIndex,
		int colorIndex, 
		SVGColorPalettes palettes, 
		String shapeId,
		double shapeWidth,
		double shapeHeight,
		NLString nls) {

		super(input, nls);
		this.indepAxis = indepAxis;
		this.depAxis = depAxis;
		this.dataset = dataset;
		this.datasetIndex = datasetIndex;
		this.colorIndex = colorIndex;
		this.palettes = palettes;
		this.shapeId = shapeId;
		this.shapeWidth = shapeWidth;
		this.shapeHeight = shapeHeight;
		this.isLTR = isLTR;
		
		if (indepAxis instanceof AxisCategory) {
			AxisCategory categoryAxis = (AxisCategory) indepAxis;
			sortDataPoints();
			groupDataPositions = categoryAxis.getGroupDataPositions();
			useCategories = true;
		} else {
			// a number axis
			AxisNumber numberAxis = (AxisNumber) indepAxis;
			indepAxisMax = numberAxis.getMax();
			indepAxisMin = numberAxis.getMin();
			indepAxislinear = numberAxis.isLinear();
			useCategories = false;
		}
		depAxisMax = depAxis.getMax();
		depAxisMin = depAxis.getMin();
		depAxislinear = depAxis.isLinear();
	}

	/**
	 * Sets independent axis
	 * @param axis independent axis
	 */	
	public void setIndepAxis(Axis axis) {
		indepAxis = axis;
	}
	
	/**
	 * Sets dependent axis
	 * @param axis dependent axis
	 */
	public void setDepAxis(AxisNumber axis) {
		depAxis = axis;
	}
	
	/**
	 * Sets the dataset to be plotted
	 * @param dataset
	 */
	public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
		this.dataset = dataset;
	}
	
	/**
	 * Sort data points by category id
	 * The order of categories follow the order specified in the category 
	 * section of the input xml.
	 */
	private void sortDataPoints() {
		Data data = input.getData();
		
		List datapoints = dataset.getDataPoint();
		
		if (data != null) {
			Categories categories = data.getCategories();
			if (categories != null) {
				categoryList = categories.getCategory();
				sortedDatapoints = new CategoricalData[categoryList.size()];
				for (Iterator i=datapoints.iterator(); i.hasNext(); ) {
					CategoricalData dp = (CategoricalData) i.next();
					int index = categoryList.indexOf(dp.getCategoryId());
					if (index != -1) {
						sortedDatapoints[index] = dp;
					} else {
						// The category id is invalid. I.e. the id may exist in the 
						// XML, but it is not an ID of a category.
						// In this case, ignore this point.
					}
				}
			}
		}
	}
}
