/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLineCategory.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLineCategory.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 * 
 */
public class DataSetLineCategory extends DataSetLine {
	static final long serialVersionUID = -4290054359843253354L;
	/**
	 * @param input
	 * @param indepAxis
	 * @param depAxis
	 * @param dataset
	 * @param colorIndex
	 * @param shape
	 * @param shapeWidth
	 * @param shapeHeight
	 */
	public DataSetLineCategory(
		Chart input,
		boolean isLTR,
		Axis indepAxis,
		AxisNumber depAxis,
		DataSet dataset,
		int datasetIndex,
		int colorIndex,
		SVGColorPalettes palettes,
		String shapeId,
		double shapeWidth,
		double shapeHeight,
		NLString nls) {
		super(
			input,
			isLTR,
			indepAxis,
			depAxis,
			dataset,
			datasetIndex,
			colorIndex,
			palettes,
			shapeId,
			shapeWidth,
			shapeHeight,
			nls);

		showArea = input.getType().equals(AREA_CHART) ? true : false;
		
		showShapes = true;
		if (input.getConfiguration() != null && input.getConfiguration().getShapes() !=null && input.getConfiguration().getShapes().getVisibility() != null){
			if (input.getConfiguration().getShapes().getVisibility().trim().equals(IConstants.VISIBLE))
				showShapes = true;
			else
				showShapes = false;
		}
		
		if (input.getType().equals(SCATTER_CHART)) {
			showLine = false;
			generateShadows = true;
		} else {
			showLine = true;
			generateShadows = false;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {

		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);
		
		// create line group
		SVGBase[] linepart = new SVGBase[1];
		setChildren(linepart);
		
		SVGGroup line = new SVGGroup();
		// number of parts: a line (a group of lines segments) + area (for area charts) + a group of shadows + n points + tooltips
		// draw area first, then line (if needed), then shadow (if needed), then shapes,
		// then tooltip (if needed)

		int partNum = sortedDatapoints.length + 4;
		SVGBase[] lineparts = new SVGBase[partNum];

		SVGGroup dataColourGroup = new SVGGroup();
		SVGBase[] dataColourGroupChild = new SVGBase[1];
		dataColourGroupChild[0] = dataColourGroup;
		dataColourGroup.setChildren(lineparts);
		dataColourGroup.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			dataColourGroup.setFill(dataSetColor);
			dataColourGroup.setStroke(dataSetColor);
		}
		
		linepart[0] = line;
		
		line.setChildren(dataColourGroupChild);
		line.setIdentifier(dataset.getId());
		line.setStyleClass("linestyle strokecolor" + colorIndex + " fillcolor" + colorIndex);
		line.setTransformation("translate("+PLOT_AREA_MARGIN+","+PLOT_AREA_MARGIN+")");
		
		SVGGroup lineGroup = new SVGGroup();
		// number of children equals number of line segments, each line joining 2 points is a line segment
		SVGBase[] lineSegments = new SVGBase[sortedDatapoints.length - 1];
		if (showLine) { 
			//lineGroup.setStyleClass("linestyle strokecolor" + colorIndex);
			lineGroup.setChildren(lineSegments);
			lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
			lineparts[1] = lineGroup;
		}
				
		//define filter this is used to highlight datasets
		if (generateShadows) {
			SVGFilter filter = new SVGFilter();
			filter.setHeight("200%");
			filter.setWidth("200%");
			filter.setX("-50%");
			filter.setY("-50%");
			filter.setIdentifier("drop-shadow");

			SVGFeGaussianBlur[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
			
			SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
			feGaussianBlur.setStdDeviation("3");
			feGaussianBlur.setIn("SourceAlpha");
			feGaussianBlur.setResult("blur");

			feGaussianBlurPart[0] = feGaussianBlur;			
			filter.setChildren(feGaussianBlurPart);
			
			addDefinition(filter);				
		}	
		
		// Handle data value toggle
		lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
		// Handle user tooltips
		lineparts[partNum-1] = EventTools.generateUserTooltip(lineGroup, dataset.getTooltip(), nls);

		// Handle user events
		EventTools.generateUserEvents(lineGroup, dataset.getEventHandler());
		
		// Handle accessibility
		EventTools.generateAccessibility(lineGroup, dataset.getAccessibility(), nls);

		// shadow group
		SVGGroup shadowGroup = new SVGGroup();
		SVGBase[] shadows = new SVGBase[sortedDatapoints.length];
		if (generateShadows) {
			shadowGroup.setChildren(shadows);
			shadowGroup.setVisibility("hidden");
			shadowGroup.setIdentifier("SVGGEN_shadowGroup" + dataset.getId());
			lineparts[2] = shadowGroup;
		}
		
		boolean firstPointDrawn = false;
		double previousX = 0;
		double previousY = 0;
		double curX = 0;
		double curY = 0;
		double zero_y = 0;
		StringBuffer pointCoordinates = new StringBuffer();
		int previousPointIndex = 0; // the index of the last point drawn

		for (int i=0; i<categoryList.size(); i++) {
			CategoricalData dp;
			if (isLTR) {
				dp = sortedDatapoints[i];
			} else {
				dp = sortedDatapoints[categoryList.size() - i - 1];
			}
			if (dp == null || (!depAxislinear && dp.getValue() <= 0) ) {
				continue;
			}

			// add the shape for the datapoint
			SVGGroup pointGroup = new SVGGroup();
			SVGBase[] point = new SVGBase[3];
			pointGroup.setChildren(point);

			// A Group wrapper to hold the data value text
			SVGGroup pointGroupWrapper = new SVGGroup();
			SVGBase[] pointWrapper = new SVGBase[2];
			pointWrapper[0] = pointGroup;
			pointGroupWrapper.setChildren(pointWrapper);

			// Handle data value toggle
			pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
			// Handle value tooltip
			point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
			// Handle user tooltips
			point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

			// Handle user events
			EventTools.generateUserEvents(pointGroup, dp.getEventHandler());

			// Handle accessibility
			EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
			SVGUse useShape = new SVGUse();
			useShape.setIdentifier(dp.getId());
			curX = groupDataPositions[i];
			curY = getCoordinate(depAxislinear, dp.getValue(), 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
			if (dp.getType().equals("hole")) {
				useShape.setHref("#SVGGEN_holeshape");
				useShape.setTransformation("translate(" + (curX - HOLE_RADIUS) + "," + (curY - HOLE_RADIUS) + ")");
			} else {
				useShape.setHref("#" + shapeId);
				useShape.setTransformation("translate(" + (curX - shapeWidth/2) + "," + (curY - shapeHeight/2) + ")");
			}
			
			if (showShapes)
				useShape.setVisibility("visible");
            else
            	useShape.setVisibility("hidden");
					
			//useShape.setStyleClass("fillcolor" + datasetIndex);
			if ((dp.getType().equals("hole")) || ((shapeId != null) && (!shapeId.trim().equals(""))))
				point[0] = useShape;
			lineparts[i+3] = pointGroupWrapper; // lineparts[0], lineparts[1], lineparts[2] are the area shade, the line, and the shadows (highlights)
			
			// Data value text
			SVGText valueText = new SVGText();
			valueText.setText(depAxis.formatValue(dp.getValue()));
			valueText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
			valueText.setXCoordinate(Double.toString(curX+5));
			valueText.setYCoordinate(Double.toString(curY));
			valueText.setVisibility("hidden");
			valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
			pointWrapper[1] = valueText;
			
			// add shadow (highlight)
			SVGUse shadowShape = new SVGUse();
			shadowShape.setHref("#" + shapeId);
			shadowShape.setTransformation("translate(" + (curX - shapeWidth/2) + "," + (curY - shapeHeight/2) + ")");
			shadowShape.setFilter("url(#drop-shadow)");
			shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
			if ((shapeId != null) && (!shapeId.trim().equals("")))
				shadows[i] = shadowShape;
			
			if (firstPointDrawn) {
				SVGPolyline lineSegment = new SVGPolyline();
				String points = previousX + " " + previousY + "," + curX + " " + curY;
				lineSegment.setPoints(points);
				if (dp.getType().equals("hole") || sortedDatapoints[previousPointIndex].getType().equals("hole")) {
					// set stroke style to dash line
					lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
				}
				lineSegments[i-1] = lineSegment;
			} else {
				firstPointDrawn = true;
				if (showArea) {
					// add the point below the first point on the zero line
					double value = depAxislinear ? 0.0 : Math.pow(10, depAxisMin);
					zero_y = getCoordinate(depAxislinear, value, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
					pointCoordinates.append(curX + " " + zero_y);
				}
			}
			
			if (showArea) {
				pointCoordinates.append(", " + curX + " " + curY);
			}
			previousX = curX;
			previousY = curY;
			previousPointIndex = i;
		}

		// lineparts[0] is the shade under the line
		// It is used by area charts only. In line charts, lineparts[0] = null;
		if (showArea) {
			SVGGroup areaGroup = new SVGGroup();
			areaGroup.setIdentifier("SVGGEN_area" + datasetIndex);
			// areaGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaBackground');");
			if (dataSetColor != null) {
				areaGroup.setFill(dataSetColor);
				areaGroup.setStroke(dataSetColor);
			} else {
				areaGroup.setStyleClass("fillcolor" + datasetIndex);
			}

			areaGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
			lineparts[0] = areaGroup;
			
			// append the coordinates of the point with the x value the same as 
			// the last point, and y value equal to zero.
			pointCoordinates.append(", " + curX + " " + zero_y);
			SVGPolygon area = new SVGPolygon();
			area.setIdentifier("SVGGEN_poly" + datasetIndex);
			area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
			area.setPoints(pointCoordinates.toString());
			
			SVGBase[] groupChild = new SVGBase[1];
			areaGroup.setChildren(groupChild);
			groupChild[0] = area;

			// Handle data value toggle
			areaGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
		}
	}
}
