/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLineContinuum.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetLineContinuum.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 * 
 */
public class DataSetLineContinuum extends DataSetLine {
	static final long serialVersionUID = -2024074715344317019L;

	/**
	 * @param input
	 * @param indepAxis
	 * @param depAxis
	 * @param dataset
	 * @param colorIndex
	 * @param shape
	 * @param shapeWidth
	 * @param shapeHeight
	 */
	public DataSetLineContinuum(
		Chart input,
		boolean isLTR,
		Axis indepAxis,
		AxisNumber depAxis,
		DataSet dataset,
		int datasetIndex,
		int colorIndex,
		SVGColorPalettes palettes,
		String shapeId,
		double shapeWidth,
		double shapeHeight,
		NLString nls
		) {
		super(
			input,
			isLTR,
			indepAxis,
			depAxis,
			dataset,
			datasetIndex,
			colorIndex,
			palettes,
			shapeId,
			shapeWidth,
			shapeHeight,
			nls);

		showArea = input.getType().equals(AREA_CHART) ? true : false;
		showShapes = true;
		if (input.getConfiguration() != null && input.getConfiguration().getShapes() !=null && input.getConfiguration().getShapes().getVisibility() != null){
			if (input.getConfiguration().getShapes().getVisibility().trim().equals(IConstants.VISIBLE))
				showShapes = true;
			else
				showShapes = false;
		}
		if (input.getType().equals(SCATTER_CHART)) {
			showLine = false;
			generateShadows = true;
		} else {
			showLine = true;
			generateShadows = false;
		}
	}


	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {

		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);
		
		double halfIndepAxisLength = indepAxis.getAxisLength() / 2;
		
		List datapointList = dataset.getCoordinates();
		
		// create line group
		SVGBase[] linepart = new SVGBase[1];
		setChildren(linepart);
		
		SVGGroup line = new SVGGroup();
		// number of parts: a line (a group of lines segments) + area (for area charts) + a group of shadows + n points + tooltips
		// draw area first, then line (if needed), then shadow (if needed), then shapes,
		// then tooltip (if needed)
		
		int partNum = datapointList.size() + 4;
		SVGBase[] lineparts = new SVGBase[partNum];

		SVGGroup dataColourGroup = new SVGGroup();
		SVGBase[] dataColourGroupChild = new SVGBase[1];
		dataColourGroupChild[0] = dataColourGroup;
		dataColourGroup.setChildren(lineparts);
		dataColourGroup.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			dataColourGroup.setFill(dataSetColor);
			dataColourGroup.setStroke(dataSetColor);
		}
		
		linepart[0] = line;
		
		line.setChildren(dataColourGroupChild);
		line.setIdentifier(dataset.getId());
		line.setStyleClass("linestyle strokecolor" + colorIndex + " fillcolor" + colorIndex);
		line.setTransformation("translate("+PLOT_AREA_MARGIN+","+PLOT_AREA_MARGIN+")");

		
		//define filter this is used to highlight datasets
		if (generateShadows) {
			SVGFilter filter = new SVGFilter();
			filter.setHeight("200%");
			filter.setWidth("200%");
			filter.setX("-50%");
			filter.setY("-50%");
			filter.setIdentifier("drop-shadow");

			SVGFeGaussianBlur[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
			
			SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
			feGaussianBlur.setStdDeviation("3");
			feGaussianBlur.setIn("SourceAlpha");
			feGaussianBlur.setResult("blur");

			feGaussianBlurPart[0] = feGaussianBlur;			
			filter.setChildren(feGaussianBlurPart);
			
			addDefinition(filter);
		}	
				
		SVGGroup lineGroup = new SVGGroup();
		// number of children equals number of line segments, each line joining 2 points is a line segment
		SVGBase[] lineSegments = new SVGBase[datapointList.size() - 1];
		if (showLine) { 
			lineGroup.setChildren(lineSegments);
			lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
		}
		lineparts[1] = lineGroup;
		
		// Handle data value toggle
		lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
		// Handle user tooltips
		lineparts[partNum-1] = EventTools.generateUserTooltip(lineGroup, dataset.getTooltip(), nls);

		// Handle user events
		EventTools.generateUserEvents(lineGroup, dataset.getEventHandler());
		
		// Handle accessibility
		EventTools.generateAccessibility(lineGroup, dataset.getAccessibility(), nls);
		
		// shadow group
		SVGGroup shadowGroup = new SVGGroup();
		SVGBase[] shadows = new SVGBase[datapointList.size()];
		if (generateShadows) {
			shadowGroup.setChildren(shadows);
			shadowGroup.setVisibility("hidden");
			shadowGroup.setIdentifier("SVGGEN_" + "shadowGroup" + dataset.getId());
			lineparts[2] = shadowGroup;
		}
		
		boolean firstPointDrawn = false;
		double previousX = 0;
		double previousY = 0;
		double curX = 0;
		double curY = 0;
		double zero_y = 0;
		boolean curPointIsHole = false;
		boolean previousPointIsHole = false;
		int partIndex = 0;
		StringBuffer pointCoordinates = new StringBuffer();

		// Cast independent axis to AxisNumber type to get formatter.
		AxisNumber numberIndepAxis = null;
		if (indepAxis instanceof AxisNumber) {
			numberIndepAxis = (AxisNumber) indepAxis;
		}
		Utilities.assertion(numberIndepAxis != null);

		for (Iterator i=datapointList.iterator(); i.hasNext(); partIndex++) {
			Coordinates dp = (Coordinates) i.next();
			if (dp == null || 
				(!indepAxislinear && dp.getValue1() <= 0) || 
				(!depAxislinear && dp.getValue2() <= 0)) {
				continue;
			} 
			
			// add the shape for the datapoint
			SVGGroup pointGroup = new SVGGroup();
			SVGBase[] point = new SVGBase[3];
			pointGroup.setChildren(point);
			
			// A Group wrapper to hold the data value text
			SVGGroup pointGroupWrapper = new SVGGroup();
			SVGBase[] pointWrapper = new SVGBase[2];
			pointWrapper[0] = pointGroup;
			pointGroupWrapper.setChildren(pointWrapper);

			// Handle data value toggle
			pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
			// Handle value tooltip
			point[2] = EventTools.generateValueTooltip(pointGroup, numberIndepAxis.formatValue(dp.getValue1())+","+depAxis.formatValue(dp.getValue2()));
			
			// Handle user tooltips
			point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

			// Handle user events
			EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
			
			// Handle accessibility
			EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
			SVGUse useShape = new SVGUse();
			useShape.setIdentifier(dp.getId());
			//useShape.setStyleClass("fillcolor" + datasetIndex);
			
			if (isLTR) {
				curX = getCoordinate(indepAxislinear, dp.getValue1(), indepAxis.getAxisLength(), 0.0, indepAxisMax, indepAxisMin);
			} else {
				curX = getCoordinate(indepAxislinear, dp.getValue1(), 0.0, indepAxis.getAxisLength(), indepAxisMax, indepAxisMin);
			}
			curY = getCoordinate(depAxislinear, dp.getValue2(), 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);

			if (dp.getType().equals("hole")) {
				useShape.setHref("#SVGGEN_holeshape");
				useShape.setTransformation("translate(" + (curX - HOLE_RADIUS) + "," + (curY - HOLE_RADIUS) + ")");
			} else {
				useShape.setHref("#" + shapeId);
				useShape.setTransformation("translate(" + (curX - shapeWidth/2) + "," + (curY - shapeHeight/2) + ")");
			}
			if (showShapes)
				useShape.setVisibility("visible");
            else
            	useShape.setVisibility("hidden");

			if ((dp.getType().equals("hole")) || ((shapeId != null) && (!shapeId.trim().equals(""))))
				point[0] = useShape;
			// partIndex+3 because the first part is the area shade and the second part is the line, third part is the shadows (highlights).
			lineparts[partIndex+3] = pointGroupWrapper; 
			
			// Data value text
			String textLabelStyle;
			double labelXCoor;
			double labelYCoor;
			// If the point is on the right half of the graph, draw the value label on the left side of the
			// point.  Otherwise, draw the label on the right side of the point.  The purpose is to avoid
			// the value label be cut off by the left and right boundary of the plot area SVG.
/*			if (curX > halfIndepAxisLength) {
				textLabelStyle = "font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black";
				labelXCoor = curX - 5;
			} else {
				textLabelStyle = "font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black";
				labelXCoor = curX + 5;
			} */
			textLabelStyle = "font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black";
			if (curX < 10)
				labelXCoor = curX + 5;
			else if (curX > (indepAxis.getAxisLength() - 10))
				labelXCoor = curX - 30;
			else
				labelXCoor = curX - 5;
			// For small values of curY (less than 5), the shape is on the border of the grid.
			// In other to show the value label, shift the label down a little to avoid being cut
			// off by the boundary of the svg.
			//labelYCoor = (curY < 10) ? curY + 15 : curY - 5;
			if (curY < 10)
				labelYCoor = curY + 13;
			else if (curY > (depAxis.getAxisLength() - 10))
				labelYCoor = curY - 5;
			else {
				if (curY > previousY )
					labelYCoor = curY + 13;
				else
					labelYCoor = curY - 5;
			}
			
			SVGText valueText = new SVGText();
			valueText.setText(numberIndepAxis.formatValue(dp.getValue1()) + "," + depAxis.formatValue(dp.getValue2()));
			valueText.setXCoordinate(Double.toString(labelXCoor));
			valueText.setYCoordinate(Double.toString(labelYCoor));
			valueText.setVisibility("hidden");
			valueText.setStyle(textLabelStyle);
			valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
			pointWrapper[1] = valueText;

			// add shadow (highlight)			
			SVGUse shadowShape = new SVGUse();
			shadowShape.setHref("#" + shapeId);
			shadowShape.setTransformation("translate(" + (curX - shapeWidth/2) + "," + (curY - shapeHeight/2) + ")");
			shadowShape.setFilter("url(#drop-shadow)");			
			shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
			if ((shapeId != null) && (!shapeId.trim().equals("")))
				shadows[partIndex] = shadowShape;
			
			if (firstPointDrawn) {
				SVGPolyline lineSegment = new SVGPolyline();
				String points = previousX + " " + previousY + "," + curX + " " + curY;
				lineSegment.setPoints(points);
				curPointIsHole = dp.getType().equals("hole") ? true : false;
				if (curPointIsHole || previousPointIsHole) {
					// set stroke style to dash line
					lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
				}
				lineSegments[partIndex-1] = lineSegment;
			} else {
				firstPointDrawn = true;
				if (showArea) {
					// add the point below the first point on the zero line
					double value = depAxislinear ? 0.0 : Math.pow(10, depAxisMin);
					zero_y = getCoordinate(depAxislinear, value, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
					pointCoordinates.append(curX + " " + zero_y);
				}
			}

			if (showArea) {
				pointCoordinates.append(", " + curX + " " + curY);
			}
			previousX = curX;
			previousY = curY;
			previousPointIsHole = curPointIsHole;
		}

		// lineparts[0] is the shade under the line
		// It is used by area charts only. In line charts, lineparts[0] = null;
		if (showArea) {
			SVGGroup areaGroup = new SVGGroup();
			areaGroup.setIdentifier("SVGGEN_area" + datasetIndex);
			// areaGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaBackground');");
			if (dataSetColor != null) {
				areaGroup.setFill(dataSetColor);
				areaGroup.setStroke(dataSetColor);
			} else {
				areaGroup.setStyleClass("fillcolor" + datasetIndex);
			}
			areaGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
			lineparts[0] = areaGroup;

			// append the coordinates of the point with the x value the same as 
			// the last point, and y value equal to zero.
				pointCoordinates.append(", " + curX + " " + zero_y);
			SVGPolygon area = new SVGPolygon();
			area.setIdentifier("SVGGEN_poly" + datasetIndex);
			area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
			area.setPoints(pointCoordinates.toString());
			
			SVGBase[] groupChild = new SVGBase[1];
			areaGroup.setChildren(groupChild);
			groupChild[0] = area;
		}
	}
}
