/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetPie.java,v 1.5 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;


/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetPie.java,v 1.5 2008/12/12 22:22:09 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
import java.util.Date;
import java.util.List;
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;


/**
 * <code>DataSetPie</code> is class to add meter graph area in meter chart.
 *
  
 * $Revision: 1.5 $  
 */
public class DataSetPie extends DataSet {
	static final long serialVersionUID = 853001416600124209L;

	protected CategoricalData[] sortedDatapoints;
	protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
	protected List categoryList;
	protected double cx;
	protected double cy;
	protected double radius;
	protected int datasetIndex;
	protected int colorIndex;
	protected double pieValue;
	protected double previousDegree;
	
	// constants for determining tick direction
	protected final int NINETY_DEG = 1;
	protected final int NEGATIVE_NINETY_DEG = 2;    
	protected final int ONE_EIGHTY_DEG = 3;		  
	protected final int ZERO_DEG = 4;

	/**
	 * Locale for formatting. Default is the default on machine
	 */
//	Locale locale = Locale.getDefault();
	protected ULocale locale = null;
	
	/**
	 * Percent formatter
	 */
	protected com.ibm.icu.text.NumberFormat percentFormatter = null;
	
	/**
	 * Date formatter
	 */
	protected DateFormat dateFormatter = null;		

	/**
	 * Number formatter for big numbers
	 */
	protected DecimalFormat bigNumberFormatter = null;
		
	/**
	 * Number formatter for small numbers
	 */
	private com.ibm.icu.text.NumberFormat numberFormatter = null;
	
	/**
	 * color palettes
	 */
	protected SVGColorPalettes palettes = null;
	
	/**
	 * @param input
	 * @param cx
	 * @param cy
	 * @param radius
	 */
	public DataSetPie(
		Chart input, 
		double cx, 
		double cy, 
		double radius, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset,
		int datasetIndex,
		int colorIndex,
		CategoricalData[] sortedDatapoints,
		double pieValue,
		double previousDegree,
		ULocale locale,
		SVGColorPalettes palettes,
		NLString nls) {
		super(input, nls);
		this.datasetIndex = datasetIndex;
		this.cx = cx;
		this.cy = cy;
		this.radius = radius;
		this.dataset = dataset;		
		this.datasetIndex = datasetIndex;
		this.colorIndex = colorIndex;
		this.sortedDatapoints = sortedDatapoints;
		this.pieValue = pieValue;
		this.previousDegree = previousDegree; 
		this.palettes = palettes;
		this.locale = locale;
		setFormatter();
	}

	/**
	 * @param input
	 */
	public DataSetPie(Chart input,
		double x,
		double y,
		double width,
		double height,
		NLString nls) {
		super(input, x, y, width, height, nls);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {

		double sliceValue = 0;
		double percent = 0;	
		double degree = 0;
		double radian = 0;
		double xPosition = 0;
		double yPosition = 0;		
				
		// groups for toggling values and percentages visibility		
		// slice value
				
		SVGBase[] piepart = new SVGBase[1]; //pieset 
		setChildren(piepart);
		SVGGroup pieset = new SVGGroup();
		
		int partNum = 5; // 
		SVGBase[] pieparts = new SVGBase[partNum];		
		piepart[0] = pieset;

		pieset.setChildren(pieparts);
		pieset.setIdentifier(dataset.getId());

		if(sortedDatapoints[0] != null){ 
			CategoricalData dp = sortedDatapoints[0];
			
			if(dp != null && dp.getValue() > 0){

				sliceValue = dp.getValue();	

				percent = (pieValue > 0) ? sliceValue / pieValue : 0;				
				// calculate the degrees of the percentage
				degree = percent * 360;
				radian = degree * 0.01745329252;
				// find the x and y position based on the radius and the degrees
				xPosition = (Math.cos(radian)) * radius;
				yPosition = (Math.sin(radian)) * radius;
				String translateString = "translate(" + cx + "," + cy + ")";		
				String transformation =(datasetIndex ==0) ? translateString : translateString + " rotate(-" + previousDegree + ")";			
				// calculate the arc path			
				String path = "M " + radius + " 0 ";
				if (degree == 360) {
					path += " A "
						  + radius
						  + " "
						  + radius
						  + " 0 0 0 "
						  + -radius
						  + " 0 "
						  + " A "
						  + radius
						  + " "
						  + radius
						  + " 0 0 0 "
						  + radius
						  + " 0 ";
				}
				else if (degree != 0) {
					path += " A "
						  + radius
						  + " "
						  + radius
						  + " 0 " + ((degree < 180) ? 0 : 1) + " 0 "
						  + (xPosition)
						  + " "
						  + (-yPosition);
				}
	
				path += " L 0 0  Z";
				// add the datapoint
				SVGGroup pointGroup = new SVGGroup();
				pointGroup.setIdentifier("pieColour" + datasetIndex);
				pointGroup.setStyleClass("dataset" + datasetIndex);

				SVGBase[] point = new SVGBase[5];
				pointGroup.setChildren(point);	
				
				SVGPath pieSegment = new SVGPath();
				pieSegment.setPathData(path);
				pieSegment.setTransform(transformation);
				String dataSetColor = palettes.getDataSetColor(dataset.getId());
				if (dataSetColor != null) {
					pieSegment.setFill(dataSetColor);
				}
				point[0] = pieSegment;
				pieparts[0] = pointGroup;
				
				String percentageLabel = formatPercentage(percent);
				String sliceValueLabel = formatNumber(sliceValue);
			
				// percentage and value - need to separate these			
				String label = percentageLabel + ",  " + sliceValueLabel;
				
				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavaluePie(evt,'SVGGEN_datasetGroup')");
			
				// Mouse moveover event
				String tooltipNum = EventTools.getUniqueID();			
				
				SVGGroup toolTipGroup = new SVGGroup();
				SVGBase[] toolTips = new SVGBase[2];
				toolTipGroup.setChildren(toolTips);
				toolTipGroup.setVisibility("hidden");
						
				SVGText pieVText = new SVGText();
				pieVText.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum + "text");
				pieVText.setText(sliceValueLabel);
				toolTips[0] = pieVText;
							
				SVGRectangle tooltipRect = new SVGRectangle();
				tooltipRect.setIdentifier("SVGGEN_tooltip_exactValue" + tooltipNum +  "rect");
				tooltipRect.setXCoordinate("0");
				tooltipRect.setYCoordinate("0");
				tooltipRect.setWidth("0");
				tooltipRect.setHeight("0");
				toolTips[1] = tooltipRect;
			
				point[2] = toolTipGroup;
				

				toolTipGroup = new SVGGroup();
				toolTips = new SVGBase[2];
				toolTipGroup.setChildren(toolTips);
				toolTipGroup.setVisibility("hidden");
						
				SVGText piePText = new SVGText();
				piePText.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum + "text");
				piePText.setText(percentageLabel);
				toolTips[0] = piePText;
			
				tooltipRect = new SVGRectangle();
				tooltipRect.setIdentifier("SVGGEN_tooltip_percentValue" + tooltipNum +  "rect");
				tooltipRect.setXCoordinate("0");
				tooltipRect.setYCoordinate("0");
				tooltipRect.setWidth("0");
				tooltipRect.setHeight("0");
				toolTips[1] = tooltipRect;
			
				point[3] = toolTipGroup;
				
				
				toolTipGroup = new SVGGroup();
				toolTips = new SVGBase[2];
				toolTipGroup.setChildren(toolTips);
				toolTipGroup.setVisibility("hidden");
						
				SVGText pieBText = new SVGText();
				pieBText.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum + "text");
				pieBText.setText(label);				
				toolTips[0] = pieBText;
			
				tooltipRect = new SVGRectangle();
				tooltipRect.setIdentifier("SVGGEN_tooltip_bothValues" + tooltipNum +  "rect");
				tooltipRect.setXCoordinate("0");
				tooltipRect.setYCoordinate("0");
				tooltipRect.setWidth("0");
				tooltipRect.setHeight("0");
				toolTips[1] = tooltipRect;
			
				point[4] = toolTipGroup;

								
				pointGroup.addEvent("onmouseover", "SVGGEN_showTooltipPie(evt,'"+tooltipNum+"')");
				pointGroup.addEvent("onmouseout", "SVGGEN_hideTooltipPie(evt,'"+tooltipNum+"')");
				
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());

				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
				
				double rad = (degree / 2 + previousDegree) * 0.01745329252;
				double xpos = (Math.cos(-1 * rad)) * radius;
				double ypos = (Math.sin(-1 * rad)) * radius;		
		
				String rotateString = EMPTY_STRING;
				int rotateFlag = 0;
				
				// adjust the tick rotation value
				if (cy + ypos > cy && cy + ypos >= cy + 7.0/8.0 * radius) {
					// ypos is near the bottom of the pie chart
					rotateString = "rotate(" + (90) + "," + xpos + "," + ypos + ")";
					rotateFlag = NINETY_DEG;	
				} else if (cy + ypos < cy && cy + ypos <= cy - 7.0/8.0 * radius) {  
					 // ypos is near the top of the pie chart
					rotateString = "rotate(" + (-90) + "," + xpos + "," + ypos + ")";
					rotateFlag = NEGATIVE_NINETY_DEG;
				} else if (cx + xpos < cx) {  
					// if the tick is on the left side of the pie chart
					rotateString = "rotate(" + (180) + "," + xpos + "," + ypos + ")";	
					rotateFlag = ONE_EIGHTY_DEG;
				} else {
					rotateFlag = ZERO_DEG;	
				}
				
				String stylesheetClass;
				// all text labels will be anchored at start if they are located on
				// right side of the circle; otherwise, the labels will be anchored 
				// at end.
				if (cx + xpos >= cx) {
					stylesheetClass = "pieValues anchorAtStart";							
				} else {
					stylesheetClass = "pieValues anchorAtEnd";
				}		
				Vector labelPosVec = calculateLabelPositions(cx, xpos, ypos, rotateFlag, label);
				double labelXPos = Double.parseDouble(labelPosVec.firstElement().toString());
				double labelYPos = Double.parseDouble(labelPosVec.lastElement().toString());
				SVGUse tickUse = new SVGUse();

				tickUse.setIdentifier("SVGGEN_datavalue_tick" + EventTools.getUniqueID());
				tickUse.setHref("#tickline");
				tickUse.setXCoordinate(Double.toString(xpos));
				tickUse.setYCoordinate(Double.toString(ypos));
				tickUse.setTransformation(translateString + rotateString);
				pieparts[4] = tickUse;

				// Mouse click event
				SVGText pieMCVText = new SVGText();
				pieMCVText.setXCoordinate(Double.toString(labelXPos));
				pieMCVText.setYCoordinate(Double.toString(-1 * labelYPos));
				pieMCVText.setIdentifier("SVGGEN_datavalue_exac" + EventTools.getUniqueID());
				pieMCVText.setStyleClass(stylesheetClass);
				pieMCVText.setTransformation(translateString);
				pieMCVText.setVisibility("hidden");
				pieMCVText.setText(sliceValueLabel);
				pieMCVText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
				pieparts[1] = pieMCVText;
				
				SVGText pieMCPText = new SVGText();
				pieMCPText.setXCoordinate(Double.toString(labelXPos));
				pieMCPText.setYCoordinate(Double.toString(-1 * labelYPos));
				pieMCPText.setIdentifier("SVGGEN_datavalue_perc" + EventTools.getUniqueID());
				pieMCPText.setStyleClass(stylesheetClass);
				pieMCPText.setTransformation(translateString);				
				pieMCPText.setVisibility("hidden");
				pieMCPText.setText(percentageLabel);
				pieMCPText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
				pieparts[2] = pieMCPText;
				
				SVGText pieMCBText = new SVGText();
				pieMCBText.setXCoordinate(Double.toString(labelXPos));
				pieMCBText.setYCoordinate(Double.toString(-1 * labelYPos));
				pieMCBText.setIdentifier("SVGGEN_datavalue_both" + EventTools.getUniqueID());
				pieMCBText.setStyleClass(stylesheetClass);
				pieMCBText.setTransformation(translateString);						
				pieMCBText.setVisibility("visible");
				pieMCBText.setText(label);
				pieMCBText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
				pieparts[3] = pieMCBText;
			}
		}
	}
	

	// determine value and percentage label position	
	protected Vector calculateLabelPositions(double cx, double xpos, double ypos, int rotateFlag, String label) {
		double labelXPos = 0;
		double labelYPos = 0;		
		
		// store the label x and y positions into a vector
		Vector labelVec = new Vector(2);  
			
		if (cx + xpos < cx) {   // if the label is located on the left side of the circle				
			if (rotateFlag == NEGATIVE_NINETY_DEG) {
				labelXPos = xpos + 2; 
				labelYPos = -ypos + 12;
			} else if (rotateFlag == NINETY_DEG) {
				labelXPos = xpos + 2;
				labelYPos = -ypos - 20;	
			} else if (rotateFlag == ONE_EIGHTY_DEG) {	
				labelXPos = xpos - 10;
				labelYPos = -ypos - 1;
			}
		} else {   // if the label is located on the right side of the circle
			if (rotateFlag == NEGATIVE_NINETY_DEG) {
				labelXPos = xpos - 3;
				labelYPos = -ypos + 12;	
			} else if (rotateFlag == NINETY_DEG) {
				labelXPos = xpos - 3;
				labelYPos = -ypos - 20;	
			} else if (rotateFlag == ZERO_DEG) {
				labelXPos = xpos + 10;
				labelYPos = -ypos - 1 ;
			}
		}

		labelVec.add(new Double(labelXPos));
		labelVec.add(new Double(labelYPos));
		
		return labelVec;
	}

	/**
	 * Set the number and date formatters
	 */
	private void setFormatter()
	{
		com.ibm.icu.text.NumberFormat nf;
		if(locale == null){
			locale = ULocale.getDefault();
		}

		Configuration config = input.getConfiguration();
		if (config != null) {
			DataValue dataValueDef = config.getDataValue();
			if (dataValueDef != null) {
				NumberFormat numFormat = dataValueDef.getNumberFormat();
				if (numFormat != null) {
					if (locale != null) {
						numberFormatter = com.ibm.icu.text.NumberFormat.getInstance(locale);
					} else {
						numberFormatter = com.ibm.icu.text.NumberFormat.getInstance();
					}
					
					if (numberFormatter instanceof DecimalFormat) {
						((DecimalFormat) numberFormatter).applyPattern(numFormat.getPattern());
					}
				}
			}
		}

		nf = com.ibm.icu.text.NumberFormat.getInstance(locale);
		if (nf instanceof DecimalFormat) {
			bigNumberFormatter = (DecimalFormat) nf;
			bigNumberFormatter.applyPattern("0.##E0");
		}
        
		percentFormatter = com.ibm.icu.text.NumberFormat.getPercentInstance(locale);
		percentFormatter.setMinimumFractionDigits(1);
		dateFormatter = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, locale);
	}
	/**
	 * Set the number and date formatters
	 */
	public static String formatValue(ULocale locale, Chart input, double percentage, double sliceValue)
	{
		com.ibm.icu.text.NumberFormat nf;
		com.ibm.icu.text.NumberFormat numberFormatter = null;
		com.ibm.icu.text.NumberFormat percentFormatter = null;
		DecimalFormat bigNumberFormatter;
		DateFormat dateFormatter;
		if(locale == null){
			locale = ULocale.getDefault();
		}

		Configuration config = input.getConfiguration();
		if (config != null) {
			DataValue dataValueDef = config.getDataValue();
			if (dataValueDef != null) {
				NumberFormat numFormat = dataValueDef.getNumberFormat();
				if (numFormat != null) {
					if (locale != null) {
						numberFormatter = com.ibm.icu.text.NumberFormat.getInstance(locale);
					} else {
						numberFormatter = com.ibm.icu.text.NumberFormat.getInstance();
					}
					
					if (numberFormatter instanceof DecimalFormat) {
						((DecimalFormat) numberFormatter).applyPattern(numFormat.getPattern());
					}
				}
			}
		}

		if (locale != null)
			nf = com.ibm.icu.text.NumberFormat.getInstance(locale);
		else
			nf = com.ibm.icu.text.NumberFormat.getInstance();
		if (nf instanceof DecimalFormat) {
			bigNumberFormatter = (DecimalFormat) nf;
			bigNumberFormatter.applyPattern("0.##E0");
		}
        
		percentFormatter = com.ibm.icu.text.NumberFormat.getPercentInstance(locale);
		percentFormatter.setMinimumFractionDigits(1);
		dateFormatter = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, locale);
		String labelText;
		if (numberFormatter != null) {
			labelText = numberFormatter.format(sliceValue);
		} else {
			labelText = Double.toString(sliceValue);
		}
		if ((input.getConfiguration().getDataValue().getPercentageVisibility().equals(IConstants.VISIBLE)) && (input.getConfiguration().getDataValue().getValueVisibility().equals(IConstants.VISIBLE))) 
			return percentFormatter.format(percentage) + ",  " + labelText;
		else if ((input.getConfiguration().getDataValue().getValueVisibility().equals(IConstants.VISIBLE))) 
			return labelText;
		else if ((input.getConfiguration().getDataValue().getPercentageVisibility().equals(IConstants.VISIBLE))) 
			return percentFormatter.format(percentage);
		else 
			return percentFormatter.format(percentage) + ",  " + labelText;
		
	}	
	
	/**
	 * Format a number in the percent format for the locale set in this object
	 */
	public String formatPercentage(double d) {
		return percentFormatter.format(d);
	}
	
	/**
	 * Format a date in the format for the locale set in this object
	 */
	public String formatDate(Date d) {
		return dateFormatter.format(d);
	}
	
	/**
	 * Format a number in the format for the locale set in this object
	 */
	public String formatNumber(double value) {
		String labelText;
		if (numberFormatter != null) {
			labelText = numberFormatter.format(value);
		} else {
			labelText = Double.toString(value);
		}
		return labelText;
		
//		DecimalFormat df;
//		df = ((d > 100000) || (d < -100000)) ? bigNumberFormatter : numberFormatter;
//		return df.format(d);
	}
	
}
