/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetPie3D.java,v 1.3 2008/12/12 22:22:09 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetPie3D.java,v 1.3 2008/12/12 22:22:09 jcayne Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


 
import java.util.Vector;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

import com.ibm.icu.util.ULocale;



/**
 * <code>DataSetPie3D</code> class draws a pie chart in 3-D in the plot area.  The depth of the
 * pie chart is a percentage of the radius of the pie chart.  The 3-D pie chart effect
 * is achieved by tilting the pie by 60 degrees about the z-axis.  
 *
 */
public class DataSetPie3D extends DataSetPie {
    protected double depth = 0;
    static final long serialVersionUID = -967686245106472449L;
    /**
     * Constructor
     * 
     * @param input chart data input
     * @param cx x offset to display the pie chart
     * @param cy y offset to display the pie chart
     * @param radius the radius of the pie
     * 
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie
     */
    public DataSetPie3D(Chart input, double cx, double cy, double radius,
        org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex,
        int colorIndex, CategoricalData[] sortedDatapoints, double pieValue,
        double previousDegree, ULocale locale, SVGColorPalettes palettes, NLString nls) {
        super(input, cx, cy, radius, dataset, datasetIndex, colorIndex,
            sortedDatapoints, pieValue, previousDegree, locale, palettes, nls);
    }

    /**
     * Constructor
     * 
     * @param input chart data input
     * @param x the x offset to display the pie chart
     * @param y the y offset to display the pie chart
     * @param width the width of the pie
     * @param height the height of the pie
     * 
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie
     */
    public DataSetPie3D(Chart input, double x, double y, double width,
        double height, NLString nls) {
        super(input, x, y, width, height, nls);
    }

    /**
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
     */
    protected void constructPart() {
        double sliceValue = 0;
        double percent = 0;
        double degree = 0;
        double radian = 0;
        double xPosition = 0;
        double previousX = 0;
        double previousY = 0;
        double yPosition = 0;
        double yDepthPosition = 0;
        double xDepthPosition = 0;
        double previousDepthX = 0;
        double previousDepthY = 0;

        //add 3d filters
/*        
        SVGFilter filter = new SVGFilter();
        filter.setIdentifier("pie-shade");

        SVGFeComponentTransfer[] feComponentTransferPart = new SVGFeComponentTransfer[1];
        SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);

        SVGFeFunc[] feFuncPart = new SVGFeFunc[3];
        SVGFeFunc feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.4");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;

        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.2");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;

        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.4");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;

        feComponentTransfer.setChildren(feFuncPart);

        addDefinition(filter);
*/        
        
        //end of add 3d filters				
        // groups for toggling values and percentages visibility		
        // slice value
        SVGBase[] piepart = new SVGBase[1]; //pieset 
        setChildren(piepart);

        SVGGroup pieset = new SVGGroup();

        int partNum = 5; // 
        SVGBase[] pieparts = new SVGBase[partNum];
        piepart[0] = pieset;

        pieset.setChildren(pieparts);
        pieset.setIdentifier(dataset.getId());

        if (sortedDatapoints[0] != null) {
            CategoricalData dp = sortedDatapoints[0];

            if ((dp != null) && (dp.getValue() > 0)) {
                sliceValue = dp.getValue();

                percent = (pieValue > 0) ? (sliceValue / pieValue) : 0;

                // calculate the degrees of the percentage
                degree = percent * 360;
                radian = (degree + previousDegree) * 0.01745329252;

                //The depth is 30% of the radius
                depth = radius * .3;

                // find the x and y position based on the radius and the degrees
                xPosition = (Math.cos(radian)) * radius;
                yPosition = (Math.sin(radian)) * radius * (Math.cos(Math.PI / 3));

                String translateString = "translate(" + cx + "," + cy + ")";

                //				String transformation =(datasetIndex ==0) ? translateString : translateString + " rotate(-" + previousDegree + ")";			
                String transformation = (datasetIndex == 0) ? translateString
                                                            : translateString;
                previousX = (Math.cos(previousDegree * 0.01745329252)) * radius;
                previousY = (Math.sin(previousDegree * 0.01745329252)) * radius * (Math.cos(Math.PI / 3));

                //3-D effects.  Need to determine if the points lie below the negative x-axis.   We do not want to draw shading figures if the 
                //pie segmen lies above the positive x axis.
                previousDepthY = previousY;
                previousDepthX = previousX;
                yDepthPosition = yPosition;
                xDepthPosition = xPosition;

                if (previousY >= 0) {
                    previousDepthY = 0;

                    if (previousX <= 0) {
                        previousDepthX = -radius;
                    } else {
                        previousDepthX = -radius;
                    }
                }

                if (yPosition >= 0) {
                    yDepthPosition = 0;

                    if (xPosition <= 0) {
                        xDepthPosition = -radius;
                    } else {
                        xDepthPosition = radius;
                    }
                }

                if (previousDepthX == xDepthPosition) {
                    previousDepthX = -xDepthPosition;
                }

                // calculate the arc path
                String depthPath = "M " + previousDepthX + " " +
                    (-previousDepthY + depth) + " ";
                String path = "M " + previousX + " " + (-previousY) + " ";

                if (degree == 360) {
                    path += (" A " + radius + " " + (radius / 2) + " 0 0 0 " +
                    -radius + " 0 " + " A " + radius + " " + (radius / 2) +
                    " 0 0 0 " + radius + " 0 ");
                    depthPath = "M " + (-radius) + " " + (depth) + " ";
                    depthPath += (" A " + radius + " " + (radius / 2) + " 0 " +
                    ((degree < 180) ? 0 : 1) + " 0 " + radius + " " + (depth));
                    depthPath += (" L " + radius + " 0" + " A " + radius + " " +
                    (radius / 2) + " 0 " + ((degree < 180) ? 0 : 1) + " 1 " +
                    (-radius) + " " + "0 Z");
                } else if (degree != 0) {
                    path += (" A " + radius + " " + (radius / 2) + " 0 " +
                    ((degree < 180) ? 0 : 1) + " 0 " + (xPosition) + " " +
                    (-yPosition));
                    depthPath += (" A " + radius + " " + (radius / 2) + " 0 " +
                    "0 0 " + (xDepthPosition) + " " +
                    (-yDepthPosition + depth));
                    depthPath += (" L " + xDepthPosition + " " +
                    (-yDepthPosition));
                    depthPath += (" A " + radius + " " + (radius / 2) + " 0 " +
                    "0 1 " + (previousDepthX) + " " +
                    (-previousDepthY) + " Z");
                }

                path += " L 0 0  Z";

                // add the datapoint
                SVGGroup pointGroup = new SVGGroup();
                pointGroup.setIdentifier("pieColour" + datasetIndex);
                pointGroup.setStyleClass("dataset" + datasetIndex);

                SVGBase[] point = new SVGBase[5];
                pointGroup.setChildren(point);

                SVGGroup pieGroup = new SVGGroup();
                pieGroup.setIdentifier(this.getIdentifier());
				String dataSetColor = palettes.getDataSetColor(dataset.getId());
				if (dataSetColor != null) {
					pieGroup.setFill(dataSetColor);
				}

                SVGBase[] pieParts = new SVGBase[2];
                pieGroup.setChildren(pieParts);

                SVGPath pieSegment = new SVGPath();
                pieSegment.setPathData(path);
                pieSegment.setTransform(transformation);

                //dont want to draw shading if the section is above the x axis
                if (!((previousDepthX == radius) &&
                        (xDepthPosition == -radius))) {
                    if (((previousY < 0) || (yPosition < 0)) ||
                            (degree >= 180)) {
                        SVGPath shadeSegment = new SVGPath();
                        shadeSegment.setPathData(depthPath);
                        shadeSegment.setTransform(transformation);
//                        shadeSegment.setFilter("url(#pie-shade)");
                        shadeSegment.setStyle("fill-opacity:0.7");
                        pieParts[0] = shadeSegment;
                    }
                }

                pieParts[1] = pieSegment;

                point[0] = pieGroup;
                pieparts[0] = pointGroup;

                String percentageLabel = formatPercentage(percent);
                String sliceValueLabel = formatNumber(sliceValue);

                // percentage and value - need to separate these			
                String label = percentageLabel + ",  " + sliceValueLabel;

                // Handle data value toggle
                pointGroup.addEvent("onclick",
                    "SVGGEN_toggleVisibilityDatavaluePie(evt,'SVGGEN_datasetGroup')");

                // Mouse moveover event
                String tooltipNum = EventTools.getUniqueID();

                SVGGroup toolTipGroup = new SVGGroup();
                SVGBase[] toolTips = new SVGBase[2];
                toolTipGroup.setChildren(toolTips);
                toolTipGroup.setVisibility("hidden");

                SVGText pieVText = new SVGText();
                pieVText.setIdentifier("SVGGEN_tooltip_exactValue" +
                    tooltipNum + "text");
                pieVText.setText(sliceValueLabel);
                toolTips[0] = pieVText;

                SVGRectangle tooltipRect = new SVGRectangle();
                tooltipRect.setIdentifier("SVGGEN_tooltip_exactValue" +
                    tooltipNum + "rect");
                tooltipRect.setXCoordinate("0");
                tooltipRect.setYCoordinate("0");
                tooltipRect.setWidth("0");
                tooltipRect.setHeight("0");
                toolTips[1] = tooltipRect;

                point[2] = toolTipGroup;

                toolTipGroup = new SVGGroup();
                toolTips = new SVGBase[2];
                toolTipGroup.setChildren(toolTips);
                toolTipGroup.setVisibility("hidden");

                SVGText piePText = new SVGText();
                piePText.setIdentifier("SVGGEN_tooltip_percentValue" +
                    tooltipNum + "text");
                piePText.setText(percentageLabel);
                toolTips[0] = piePText;

                tooltipRect = new SVGRectangle();
                tooltipRect.setIdentifier("SVGGEN_tooltip_percentValue" +
                    tooltipNum + "rect");
                tooltipRect.setXCoordinate("0");
                tooltipRect.setYCoordinate("0");
                tooltipRect.setWidth("0");
                tooltipRect.setHeight("0");
                toolTips[1] = tooltipRect;

                point[3] = toolTipGroup;

                toolTipGroup = new SVGGroup();
                toolTips = new SVGBase[2];
                toolTipGroup.setChildren(toolTips);
                toolTipGroup.setVisibility("hidden");

                SVGText pieBText = new SVGText();
                pieBText.setIdentifier("SVGGEN_tooltip_bothValues" +
                    tooltipNum + "text");
                pieBText.setText(label);
                toolTips[0] = pieBText;

                tooltipRect = new SVGRectangle();
                tooltipRect.setIdentifier("SVGGEN_tooltip_bothValues" +
                    tooltipNum + "rect");
                tooltipRect.setXCoordinate("0");
                tooltipRect.setYCoordinate("0");
                tooltipRect.setWidth("0");
                tooltipRect.setHeight("0");
                toolTips[1] = tooltipRect;

                point[4] = toolTipGroup;

                pointGroup.addEvent("onmouseover",
                    "SVGGEN_showTooltipPie(evt,'" + tooltipNum + "')");
                pointGroup.addEvent("onmouseout",
                    "SVGGEN_hideTooltipPie(evt,'" + tooltipNum + "')");

                // Handle user tooltips
                point[1] = EventTools.generateUserTooltip(pointGroup,
                        dp.getTooltip(), nls);

                // Handle user events
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());

                // Handle accessibility
                EventTools.generateAccessibility(pointGroup,
                    dp.getAccessibility(), nls);

                double rad = ((degree / 2) + previousDegree) * 0.01745329252;
                double xpos = (Math.cos(-1 * rad)) * radius;
                double ypos = (Math.sin(-1 * rad)) * radius * Math.cos(Math.PI / 3);

		        if (ypos > 0) {
	              ypos += depth;
        		}
                String rotateString = EMPTY_STRING;
                int rotateFlag = 0;

                // adjust the tick rotation value
                if (((cy + ypos) > cy) &&
                        ((cy + ypos) >= (cy + (7.0 / 8.0 * radius)))) {
                    // ypos is near the bottom of the pie chart
                    rotateString = "rotate(" + (90) + "," + xpos + "," + ypos +
                        ")";
                    rotateFlag = NINETY_DEG;
                } else if (((cy + ypos) < cy) &&
                        ((cy + ypos) <= (cy - (7.0 / 8.0 * radius)))) {
                    // ypos is near the top of the pie chart
                    rotateString = "rotate(" + (-90) + "," + xpos + "," + ypos +
                        ")";
                    rotateFlag = NEGATIVE_NINETY_DEG;
                } else if ((cx + xpos) < cx) {
                    // if the tick is on the left side of the pie chart
                    rotateString = "rotate(" + (180) + "," + xpos + "," + ypos +
                        ")";
                    rotateFlag = ONE_EIGHTY_DEG;
                } else {
                    rotateFlag = ZERO_DEG;
                }

                String stylesheetClass;

                // all text labels will be anchored at start if they are located on
                // right side of the circle; otherwise, the labels will be anchored 
                // at end.
                if ((cx + xpos) >= cx) {
                    stylesheetClass = "pieValues anchorAtStart";
                } else {
                    stylesheetClass = "pieValues anchorAtEnd";
                }

                Vector labelPosVec = calculateLabelPositions(cx, xpos, ypos,
                        rotateFlag, label);
                double labelXPos = Double.parseDouble(labelPosVec.firstElement()
                                                                 .toString());
                double labelYPos = Double.parseDouble(labelPosVec.lastElement()
                                                                 .toString());
                SVGUse tickUse = new SVGUse();

                tickUse.setIdentifier("SVGGEN_datavalue_tick" +
                    EventTools.getUniqueID());
                tickUse.setHref("#tickline");
                tickUse.setXCoordinate(Double.toString(xpos));
                tickUse.setYCoordinate(Double.toString(ypos));
                tickUse.setTransformation(translateString + rotateString);
                pieparts[4] = tickUse;

                // Mouse click event
                SVGText pieMCVText = new SVGText();
                pieMCVText.setXCoordinate(Double.toString(labelXPos));
                pieMCVText.setYCoordinate(Double.toString(-1 * labelYPos));
                pieMCVText.setIdentifier("SVGGEN_datavalue_exac" +
                    EventTools.getUniqueID());
                pieMCVText.setStyleClass(stylesheetClass);
                pieMCVText.setTransformation(translateString);
                pieMCVText.setVisibility("hidden");
                pieMCVText.setText(sliceValueLabel);
				pieMCVText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                pieparts[1] = pieMCVText;

                SVGText pieMCPText = new SVGText();
                pieMCPText.setXCoordinate(Double.toString(labelXPos));
                pieMCPText.setYCoordinate(Double.toString(-1 * labelYPos));
                pieMCPText.setIdentifier("SVGGEN_datavalue_perc" +
                    EventTools.getUniqueID());
                pieMCPText.setStyleClass(stylesheetClass);
                pieMCPText.setTransformation(translateString);
                pieMCPText.setVisibility("hidden");
                pieMCPText.setText(percentageLabel);
				pieMCPText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                pieparts[2] = pieMCPText;

                SVGText pieMCBText = new SVGText();
                pieMCBText.setXCoordinate(Double.toString(labelXPos));
                pieMCBText.setYCoordinate(Double.toString(-1 * labelYPos));
                pieMCBText.setIdentifier("SVGGEN_datavalue_both" +
                    EventTools.getUniqueID());
                pieMCBText.setStyleClass(stylesheetClass);
                pieMCBText.setTransformation(translateString);
                pieMCBText.setVisibility("visible");
                pieMCBText.setText(label);
				pieMCBText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                pieparts[3] = pieMCBText;
            }
        }
    }

	// determine value and percentage label position	
	protected Vector calculateLabelPositions(double cx, double xpos, double ypos, int rotateFlag, String label) {
		double labelXPos = 0;
		double labelYPos = 0;		
		
		// store the label x and y positions into a vector
		Vector labelVec = new Vector(2);  


		//if the label is located on the bottom
        if (ypos > 0) {
              ypos += 10;
        }
        else{
              ypos -= 3;
        }
			
		if (cx + xpos < cx) {   // if the label is located on the left side of the circle				
			if (rotateFlag == NEGATIVE_NINETY_DEG) {
				labelXPos = xpos + 2; 
				labelYPos = -ypos + 12;
			} else if (rotateFlag == NINETY_DEG) {
				labelXPos = xpos + 2;
				labelYPos = -ypos - 20;	
			} else if (rotateFlag == ONE_EIGHTY_DEG) {	
				labelXPos = xpos - 10;
				labelYPos = -ypos - 1;
			}
		} else {   // if the label is located on the right side of the circle
			if (rotateFlag == NEGATIVE_NINETY_DEG) {
				labelXPos = xpos - 3;
				labelYPos = -ypos + 12;	
			} else if (rotateFlag == NINETY_DEG) {
				labelXPos = xpos - 3;
				labelYPos = -ypos - 20;	
			} else if (rotateFlag == ZERO_DEG) {
				labelXPos = xpos + 10;
				labelYPos = -ypos - 1 ;
			}
		}

		labelVec.add(new Double(labelXPos));
		labelVec.add(new Double(labelYPos));
		
		return labelVec;
	}
    
}
