/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackAreaCategory.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackAreaCategory.java,v 1.3 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**
 *
 */
public class DataSetStackAreaCategory extends DataSetStackArea  {
	static final long serialVersionUID = -6828040412250730478L;
	double[] accumulatedHighValues;
	double[] accumulatedLowValues;	
		
	/**
	 * @param input
	 * @param isLTR
	 * @param indepAxis
	 * @param depAxis
	 * @param dataset
	 * @param datasetIndex
	 * @param colorIndex
	 * @param shapeIndex
	 * @param shapes
	 */
	public DataSetStackAreaCategory(
		Chart input,
		boolean isLTR,
		Axis indepAxis,
		AxisNumber depAxis,
		DataSet dataset,
		int datasetIndex,
		int colorIndex,
		SVGColorPalettes palettes,
		String shapeId,
		double shapeWidth,
		double shapeHeight,
		double[] accumulatedHighValues,
		double[] accumulatedLowValues,
		NLString nls) {
		super(
			input,
			isLTR,
			indepAxis,
			depAxis,
			dataset,
			datasetIndex,
			colorIndex,
			palettes,
			shapeId,
			shapeWidth,
			shapeHeight,
			nls);
		this.accumulatedHighValues = accumulatedHighValues;
		this.accumulatedLowValues = accumulatedLowValues;
		showArea = input.getType().equals(STACK_AREA_CHART) ? true : false;
		showLine = true;
		generateShadows = false;

	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		double previousSet = 0.0;
		double firstNlast = 0.0;
		double min = Math.pow(10.0, depAxisMin);
		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);
		
		// create line group
		SVGBase[] linepart = new SVGBase[2];
		setChildren(linepart);
		
		SVGGroup line = new SVGGroup();
		// number of parts: a line (a group of lines segments) + area (for area charts) + a group of shadows + n points + tooltips
		// draw area first, then line (if needed), then shadow (if needed), then shapes,
		// then tooltip (if needed)

		int partNum = sortedDatapoints.length + 4;
		SVGBase[] lineparts = new SVGBase[partNum];

		SVGGroup dataColourGroup = new SVGGroup();
		SVGBase[] dataColourGroupChild = new SVGBase[1];
		dataColourGroupChild[0] = dataColourGroup;
		dataColourGroup.setChildren(lineparts);
		dataColourGroup.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			dataColourGroup.setFill(dataSetColor);
			dataColourGroup.setStroke(dataSetColor);
		}

		linepart[0] = line;
		
		line.setChildren(dataColourGroupChild);
		line.setIdentifier(dataset.getId());
		line.setStyleClass("linestyle strokecolor" + colorIndex + " fillcolor" + colorIndex);
		line.setTransformation("translate("+PLOT_AREA_MARGIN+","+PLOT_AREA_MARGIN+")");
		
		SVGGroup lineGroup = new SVGGroup();
		lineGroup.setIdentifier("SVGGEN_lineGroup" + datasetIndex);
		// number of children equals number of line segments, each line joining 2 points is a line segment
		SVGBase[] lineSegments = new SVGBase[sortedDatapoints.length - 1];
		if (showLine) { 
			//lineGroup.setStyleClass("linestyle strokecolor" + colorIndex);
			lineGroup.setChildren(lineSegments);
			lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
			lineparts[1] = lineGroup;
		}
				
		//define filter this is used to highlight datasets
		if (generateShadows) {
			SVGFilter filter = new SVGFilter();
			filter.setHeight("200%");
			filter.setWidth("200%");
			filter.setX("-50%");
			filter.setY("-50%");
			filter.setIdentifier("drop-shadow");

			SVGFeGaussianBlur[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
			
			SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
			feGaussianBlur.setStdDeviation("3");
			feGaussianBlur.setIn("SourceAlpha");
			feGaussianBlur.setResult("blur");

			feGaussianBlurPart[0] = feGaussianBlur;			
			filter.setChildren(feGaussianBlurPart);
			
			addDefinition(filter);				
		}	
		
		// Handle data value toggle
		lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
		// Handle user tooltips
		lineparts[partNum-1] = EventTools.generateUserTooltip(lineGroup, dataset.getTooltip(), nls);

		// Handle user events
		EventTools.generateUserEvents(lineGroup, dataset.getEventHandler());
		
		// Handle accessibility
		EventTools.generateAccessibility(lineGroup, dataset.getAccessibility(), nls);

		// shadow group
		SVGGroup shadowGroup = new SVGGroup();
		SVGBase[] shadows = new SVGBase[sortedDatapoints.length];
		if (generateShadows) {
			shadowGroup.setChildren(shadows);
			shadowGroup.setVisibility("hidden");
			shadowGroup.setIdentifier("SVGGEN_shadowGroup" + dataset.getId());
			lineparts[2] = shadowGroup;
		}
		
		SVGScript scriptEmitter = new SVGScript();
		boolean firstPointDrawn = false;
		double previousX = 0;
		double previousY = 0;
		double curX = 0;
		double curY = 0;
		double zero_y = 0;
		int index = datasetIndex + 1;
		String str = depAxislinear ? "true" : "false";
		String stackPointCoordinates = null;
		StringBuffer pointCoordinates = new StringBuffer();
		StringBuffer shapesWidth = new StringBuffer("var width"+index+" =  new Array(");
		StringBuffer shapesHeight = new StringBuffer("var height"+index+" =  new Array(");
		StringBuffer xPoints;
		if(datasetIndex==0){
			xPoints = new StringBuffer("var xpts =  new Array(");
		}else{
			xPoints = new StringBuffer("xpts =  new Array(");
		}
		StringBuffer yPoints = new StringBuffer("var ypts" + index + " =  new Array(");
		String defaultValues = ("var linear = " + str + "; var max_coor = 0.0; var min_coor = " + depAxis.getAxisLength()+"; var max = " + depAxisMax + "; var min = " + depAxisMin+"; ");
		int previousPointIndex = 0; // the index of the last point drawn
		double value = depAxislinear ? 0.0 : min;
		for (int i=0; i<categoryList.size(); i++) {
			double width = shapeWidth;
			double height = shapeHeight;
			curX = groupDataPositions[i];
			CategoricalData dp;
			if (isLTR) {
				dp = sortedDatapoints[i];
			} else {
				dp = sortedDatapoints[categoryList.size() - i - 1];
			}
			double yRValue;// = dp.getValue();
			double yValue;
			//if log scale and datapoint is missing or negative, plot the last dataset's point with hole. 
			if (dp == null || (!depAxislinear && dp.getValue() <= 0) ) {
				if(!depAxislinear){
					if(datasetIndex==0){
						yValue = min;
						accumulatedHighValues[i] = 0.0;
						yRValue = 0.0;
					}else{
						yValue = min;
						accumulatedHighValues[i] = 0.0;
						yRValue = 0.0;
					}
				}else{
					if(datasetIndex==0){
						yValue = value;
						accumulatedHighValues[i] = yValue;
						yRValue = value;
					}else{
						yValue = sortedDatapoints[previousPointIndex].getValue();
						accumulatedHighValues[i] = yValue;
						yRValue = value;
					}
				}
			}else{
				yValue =  dp.getValue() + accumulatedHighValues[i];
				yRValue =  dp.getValue();
			}

			// add the shape for the datapoint
			SVGGroup pointGroup = new SVGGroup();

			SVGBase[] point = new SVGBase[3];
			pointGroup.setChildren(point);

			// A Group wrapper to hold the data value text
			SVGGroup pointGroupWrapper = new SVGGroup();
			pointGroupWrapper.setIdentifier("SVGGEN_pointGroupWrapper" + (i+1));
			SVGBase[] pointWrapper = new SVGBase[2];
			pointWrapper[0] = pointGroup;
			pointGroupWrapper.setChildren(pointWrapper);

			// Handle data value toggle
			pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			SVGUse useShape = new SVGUse();			
			if ((dp == null) || (!depAxislinear && dp.getValue() <= 0)){
//				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(value));
				//Handle user tooltips
//				point[1] = EventTools.generateUserTooltip(pointGroup, sortedDatapoints[previousPointIndex].getTooltip());
				// Handle user events
//				EventTools.generateUserEvents(pointGroup, sortedDatapoints[previousPointIndex].getEventHandler());
				// Handle accessibility
//				EventTools.generateAccessibility(pointGroup, sortedDatapoints[previousPointIndex].getAccessibility());
				useShape.setIdentifier(sortedDatapoints[previousPointIndex].getId());				
			}else{
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
//				Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);
				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
				useShape.setIdentifier(dp.getId());
			}
			
			double lastYValue = 0.0; 

			//get the base value for next point to plot.
			if(!depAxislinear){
				if(accumulatedHighValues[i] != 0.0){
					if (dp.getValue() > 0){
						value = accumulatedHighValues[i];
						accumulatedHighValues[i] = yValue;
					}else{
						value = min;
					}
				}else{
					if(sortedDatapoints[previousPointIndex] != null){
						value = min;
					}else{
						value = min;
					}
					if ((dp != null) && (dp.getValue() >= 0)){
						accumulatedHighValues[i] = yValue;
					}else{
						accumulatedHighValues[i] = 0.0;
					}
				}
			}else{
				value = accumulatedHighValues[i];	
				accumulatedHighValues[i] = yValue;				
			}
			lastYValue = getCoordinate(depAxislinear, value, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
		
			curY = getCoordinate(depAxislinear, yValue, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);

			if(datasetIndex == 0){
				firstNlast = getCoordinate(depAxislinear, value, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
				previousSet = (curY*2);
			}else{
				previousSet = lastYValue;
			}

//			double width = 2*HOLE_RADIUS;//shapes.getShapeWidth(shapeIndex);
//			double height = 2*HOLE_RADIUS;//shapes.getShapeHeight(shapeIndex);
													
			if (dp == null || (!depAxislinear && dp.getValue() <= 0) ) {
				useShape.setHref("#SVGGEN_holeshape");
				useShape.setTransformation("translate(" + (curX - HOLE_RADIUS) + "," + (curY - HOLE_RADIUS) + ")");
				width = 2*HOLE_RADIUS;
				height = 2*HOLE_RADIUS;
			}else if (dp.getType().equals("hole")) {
				useShape.setHref("#SVGGEN_holeshape");
				useShape.setTransformation("translate(" + (curX - HOLE_RADIUS) + "," + (curY - HOLE_RADIUS) + ")");
				width = 2*HOLE_RADIUS;
				height = 2*HOLE_RADIUS;
			} else {
				useShape.setHref("#" + shapeId);
				useShape.setTransformation("translate(" + (curX - width/2) + "," + (curY - height/2) + ")");
			}
			//useShape.setStyleClass("fillcolor" + datasetIndex);
			point[0] = useShape;
			lineparts[i+3] = pointGroupWrapper; // lineparts[0], lineparts[1], lineparts[2] are the area shade, the line, and the shadows (highlights)
			
			// Data value text
			SVGText valueText = new SVGText();
			if (dp == null || (!depAxislinear && dp.getValue() <= 0) ) {
				valueText.setText("");
			}else{
				valueText.setText(depAxis.formatValue(dp.getValue()));
			}
			valueText.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
			valueText.setXCoordinate(Double.toString(curX+5));
			valueText.setYCoordinate(Double.toString(curY));
			valueText.setVisibility("hidden");
			valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
			pointWrapper[1] = valueText;
			
			// add shadow (highlight)
			SVGUse shadowShape = new SVGUse();
			shadowShape.setHref("#" + shapeId);
			shadowShape.setTransformation("translate(" + (curX - width/2) + "," + (curY - height/2) + ")");
			shadowShape.setFilter("url(#drop-shadow)");
			shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
			shadows[i] = shadowShape;
			if (firstPointDrawn) {
				if(!depAxislinear){
					yPoints.append("," + (yRValue));
				}else{
					yPoints.append("," + (previousSet - curY));
				}
				xPoints.append("," + curX);
				shapesWidth.append(", " + width/2);
				shapesHeight.append(", " +height/2);
				stackPointCoordinates = (curX + " " + lastYValue + ",") + stackPointCoordinates;
				SVGPolyline lineSegment = new SVGPolyline();
				lineSegment.setIdentifier("SVGGEN_Line" + i);
				String points = previousX + " " + previousY + "," + curX + " " + curY;
				lineSegment.setPoints(points);
//				// set stroke style to dash line
				if(dp != null){
					if (dp.getType().equals("hole")){
						lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
					}
					if(!depAxislinear && dp.getValue() <= 0){
						lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
					}
				}else{
					 lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
				}
				if(sortedDatapoints[previousPointIndex] != null){
					if (sortedDatapoints[previousPointIndex].getType().equals("hole")){
						 lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
					}
					if(!depAxislinear && sortedDatapoints[previousPointIndex].getValue() <= 0){
						lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
					}
				}else{
					 lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
				}

				lineSegments[i-1] = lineSegment;
			} else {
				firstPointDrawn = true;
				if (showArea) {
					// add the point below the first point on the zero line
					if(!depAxislinear){
						yPoints.append(value + "," + yRValue);
					}else{
						yPoints.append(firstNlast + "," + (previousSet - curY));
					}
					xPoints.append(curX + "," + curX);
					shapesWidth.append(width/2);
					shapesHeight.append(height/2);
					zero_y = lastYValue;//getCoordinate(depAxislinear, value, 0.0, depAxis.getAxisLength(), depAxisMax, depAxisMin);
					pointCoordinates.append(curX + " " + zero_y);
					stackPointCoordinates = (curX + " " + lastYValue + ",");
				}
			}

			if (showArea) {
				pointCoordinates.append(", " + curX + " " + curY);
			}
			previousX = curX;
			previousY = curY;
			previousPointIndex = i;
		}
		xPoints.append("," + curX + ");");
		if(!depAxislinear){
			yPoints.append(","+value+");");
		}else{
			yPoints.append("," + (firstNlast) + ");");
		}
		shapesWidth.append(");");
		shapesHeight.append(");");
		EventTools.generateStackAreaProcessedData(scriptEmitter, xPoints.toString() + yPoints.toString() + defaultValues + shapesWidth.toString() + shapesHeight.toString());// + yPreviousPoints.toString() + yPreviousSetPreviousPoints.toString() + yPreviousSetPoints.toString());
		linepart[1] = scriptEmitter;
		// lineparts[0] is the shade under the line
		// It is used by area charts only. In line charts, lineparts[0] = null;
		if (showArea) {
			SVGGroup areaGroup = new SVGGroup();
			areaGroup.setIdentifier("SVGGEN_area" + datasetIndex);
			// areaGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotareaBackground');");
			if (dataSetColor != null) {
				areaGroup.setFill(dataSetColor);
				areaGroup.setStroke(dataSetColor);
			} else {
				areaGroup.setStyleClass("fillcolor" + datasetIndex);
			}

			lineparts[0] = areaGroup;
			
			// append the coordinates of the point with the x value the same as 
			// the last point, and y value equal to zero.
//			pointCoordinates.append(", " + curX + " " + zero_y);
			SVGPolygon area = new SVGPolygon();
			area.setIdentifier("SVGGEN_poly" + datasetIndex);
			area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
			area.setPoints(stackPointCoordinates + pointCoordinates.toString());
			SVGBase[] groupChild = new SVGBase[1];
			areaGroup.setChildren(groupChild);
			groupChild[0] = area;

			// Handle data value toggle
			areaGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
		}
	}
}
