/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;


/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;


/**

 *
 * <code>DataSetStackBar</code> is class to add stack bar in the plot area for stack bar chart. 
 * $Revision: 1.2 $  
 */
public class DataSetStackBar extends DataSet {
	static final long serialVersionUID = 4550173625267433013L;
	protected AxisCategory indepAxis;
	protected AxisNumber depAxis;
	protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
	protected CategoricalData[] sortedDatapoints;
	protected int colorIndex;
	
	protected List categoryList;
	protected double[] groupDataPositions;
	protected double depAxisMax;
	protected double depAxisMin;
	protected double axisLenght;
	protected boolean linear;
	protected double barWidth;	
	protected double[] accumulatedHighValues;
	protected double[] accumulatedLowValues;	
	protected int datasetIndex;

	/**
	 * Text direction: true if LTR, false if RTL
	 */
	protected boolean isLTR = true;
	
	/**
	 * color palettes
	 */
	protected SVGColorPalettes palettes;
	
	/**
	 * @param input
	 */
	public DataSetStackBar(
		Chart input, 
		boolean isLTR,
		AxisCategory indepAxis, 
		AxisNumber depAxis, 
		org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, 
		int datasetIndex,
		int colorIndex,
		double barWidth,
		double[] accumulatedLowValues,
		double[] accumulatedHighValues,
		SVGColorPalettes palettes, 
		NLString nls)  {
		super(input, nls);
		this.indepAxis = indepAxis;
		this.depAxis = depAxis;
		this.dataset = dataset;
		this.datasetIndex = datasetIndex;
		this.barWidth = barWidth;
		this.colorIndex = colorIndex;
		this.accumulatedHighValues = accumulatedHighValues;
		this.accumulatedLowValues = accumulatedLowValues;
		this.isLTR = isLTR;		
		this.palettes = palettes;
		linear = depAxis.isLinear();
		sortDataPoints();
		groupDataPositions = indepAxis.getGroupDataPositions();
		this.axisLenght = indepAxis.getAxisLength();
		depAxisMax = depAxis.getMax();
		depAxisMin = depAxis.getMin();
	}

	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public DataSetStackBar(
		Chart input,
		double x,
		double y,
		double width,
		double height,
		NLString nls) {
		super(input, x, y, width, height, nls);
	}
	
	public void setIndepAxis(AxisCategory axis) {
		indepAxis = axis;
	}
	
	public void setDepAxis(AxisNumber axis) {
		depAxis = axis;
	}
	
	public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
		this.dataset = dataset;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
	 */
	protected void constructPart() {
		Utilities.assertion(dataset != null);
		Utilities.assertion(dataset.getDataPoint() != null);

		// create bar group
		SVGBase[] barpart = new SVGBase[2];
		setChildren(barpart);

		SVGGroup barGroup1 = new SVGGroup();
		SVGBase[] barGroupChild = new SVGBase[1];
		barpart[0] = barGroup1;
		barGroup1.setChildren(barGroupChild);
		barGroup1.setIdentifier(dataset.getId());
		barGroup1.setStyleClass("bars" + colorIndex);
		
		SVGGroup barset = new SVGGroup();
		int partNum = sortedDatapoints.length + 1; // n points + a line (a group of lines segments)
		SVGBase[] barparts = new SVGBase[partNum];
		barGroupChild[0] = barset;
		barset.setChildren(barparts);
		//barset.setStyleClass("bars" + colorIndex);
		String dataSetColor = palettes.getDataSetColor(dataset.getId());
		if (dataSetColor != null) {
			barset.setFill(dataSetColor);
			barset.setStroke(dataSetColor);
		}

		barset.setIdentifier("SVGGEN_dataColour" + datasetIndex);
		double min = Math.pow(10.0, depAxisMin);
		double previousX = 0;
		double previousY = 0;
		double curX, curY;
		double groupPosition[] = indepAxis.groupDataPositions;
		if(indepAxis.getAxisOrientation() == HORIZONTAL){
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp;
				if (isLTR) {
					dp = sortedDatapoints[i];
				} else {
					dp = sortedDatapoints[categoryList.size() - i - 1];
				}
				if (dp == null || (!linear && dp.getValue() <= 0) ) {
					continue;
				} 
				// add the shape for the datapoint
				SVGGroup pointGroup = new SVGGroup();
				SVGBase[] point = new SVGBase[4];
				pointGroup.setChildren(point);
				
				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				pointGroup.setIdentifier(dp.getId());
				double yValue =  dp.getValue();
				double lastYValue = 0.0; 
				curX = groupPosition[i];
				if(yValue>=0.0){
					yValue =  dp.getValue() + accumulatedHighValues[i];
					double value = 0.0;
					if(!linear){
						if(accumulatedHighValues[i] == 0.0){
							value = min;
						}else{
							value = accumulatedHighValues[i];
						}
					}else{
						value = accumulatedHighValues[i];					
					}
					lastYValue = getCoordinate(linear, value, 0.0, Double.parseDouble(getHeight()), depAxisMax, depAxisMin);
					accumulatedHighValues[i] = yValue;
				}else{
					yValue =  dp.getValue() + accumulatedLowValues[i];	
					lastYValue = getCoordinate(linear, accumulatedLowValues[i], 0.0, Double.parseDouble(getHeight()), depAxisMax, depAxisMin);
					accumulatedLowValues[i] = yValue;			
				}
				curY = getCoordinate(linear, yValue, 0.0, Double.parseDouble(getHeight()), depAxisMax, depAxisMin);
				barparts[i+1] = pointGroup;
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText(depAxis.formatValue(dp.getValue()));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setStyleClass("anchorAtMiddle");
					barTextSegment.setVisibility("hidden");
					barTextSegment.setXCoordinate(Double.toString(curX));
					if(dp.getValue() < 0.0){
						barTextSegment.setYCoordinate(Double.toString(curY + BASE_FONT_SIZE));
						
					}else{
						barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
					}
					barTextSegment.setIdentifier(tooltipID);	

					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotBarsForeground');");

					SVGLine barSegment = new SVGLine();
					barSegment.setX1(Double.toString(curX));
					barSegment.setY1(Double.toString(lastYValue));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					point[0] = barSegment;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;					
				} 
				
				previousX = curX;
				previousY = curY;
			}
		}else{
			for (int i=0; i<categoryList.size(); i++) {
				CategoricalData dp = sortedDatapoints[i];
				if (dp == null || (!linear && dp.getValue() <= 0) ) {
					continue;
				} 
				SVGGroup pointGroup = new SVGGroup();
				SVGBase[] point = new SVGBase[3];
				pointGroup.setChildren(point);
				
				// Handle data value toggle
				pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
			
				// Handle value tooltip
				point[2] = EventTools.generateValueTooltip(pointGroup, depAxis.formatValue(dp.getValue()));
			
				// Handle user tooltips
				point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), nls);

				// Handle user events
				EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
				
				// Handle accessibility
				EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), nls);
			
				pointGroup.setIdentifier(dp.getId());
				double xValue =  dp.getValue();
				double lastXValue = 0.0; 
				curY = indepAxis.getAxisLength()- groupPosition[i];
				double value = 0.0;
				if(!linear){
					if(accumulatedHighValues[i] == 0.0){
						value = min;
					}else{
						value = accumulatedHighValues[i];
					}
				}else{
					value = accumulatedHighValues[i];					
				}
				if(xValue>=0.0){
					xValue =  dp.getValue() + accumulatedHighValues[i];
					if (isLTR) {
						lastXValue = getCoordinate(linear, value, Double.parseDouble(getWidth()), 0.0, depAxisMax, depAxisMin);
					} else {
						lastXValue = getCoordinate(linear, value, 0.0, Double.parseDouble(getWidth()), depAxisMax, depAxisMin);
					}
					accumulatedHighValues[i] = xValue;
				}else{
					xValue =  dp.getValue() + accumulatedLowValues[i];
					if (isLTR) {
						lastXValue = getCoordinate(linear, accumulatedLowValues[i], Double.parseDouble(getWidth()), 0.0, depAxisMax, depAxisMin);	
					} else {
						lastXValue = getCoordinate(linear, accumulatedLowValues[i], 0.0, Double.parseDouble(getWidth()), depAxisMax, depAxisMin);
					}
					accumulatedLowValues[i] = xValue;			
				}
				if (isLTR) {
					curX = getCoordinate(linear, xValue, Double.parseDouble(getWidth()), 0.0, depAxisMax, depAxisMin);			
				} else {
					curX = getCoordinate(linear, xValue, 0.0, Double.parseDouble(getWidth()), depAxisMax, depAxisMin);			
				}

				barparts[i+1] = pointGroup;
				if (i >= 0) {
					SVGText barTextSegment = new SVGText();
					String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
					barTextSegment.setText((depAxis.formatValue(dp.getValue())));
					barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
					barTextSegment.setVisibility("hidden");
					barTextSegment.setXCoordinate(Double.toString(curX));
					if(dp.getValue() < 0.0){
						barTextSegment.setStyleClass("anchorAtEnd");
					}else{
						barTextSegment.setStyleClass("anchorAtStart");
					}
					barTextSegment.setIdentifier(tooltipID);

					SVGGroup barGroup = new SVGGroup();
					barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
					// barGroup.addEvent("onload", "SVGGEN_moveNode(evt, 'SVGGEN_plotBarsForeground');");

					SVGLine barSegment = new SVGLine();
					barSegment.setX1(Double.toString(lastXValue));
					barSegment.setY1(Double.toString(curY));
					barSegment.setX2(Double.toString(curX));
					barSegment.setY2(Double.toString(curY));
					barSegment.setStrokeWidth(Double.toString(barWidth));
					point[0] = barSegment;
					
					SVGBase[] groupChild = new SVGBase[1];
					barGroup.setChildren(groupChild);
					groupChild[0] = barTextSegment;
				} 
				
				previousX = curX;
				previousY = curY;
			}
		}
	}

	/**
	 * Sort data points by category id
	 * The order of categories follow the order specified in the category 
	 * section of the input xml.
	 */
	private void sortDataPoints() {
		Data data = input.getData();
		
		List datapoints = dataset.getDataPoint();
		
		if (data != null) {
			Categories categories = data.getCategories();
			if (categories != null) {
				categoryList = categories.getCategory();
				sortedDatapoints = new CategoricalData[categoryList.size()];
				for (Iterator i=datapoints.iterator(); i.hasNext(); ) {
					CategoricalData dp = (CategoricalData) i.next();
					int index = categoryList.indexOf(dp.getCategoryId());
					sortedDatapoints[index] = dp;
				}

				for (int i=0; i<categoryList.size(); i++) {
					CategoricalData dp;
					dp = sortedDatapoints[i];
					if (dp == null || (!linear && dp.getValue() <= 0) ) {
						continue;
					}
					if(dp.getValue()>=0.0){
						if (!isLTR && indepAxis.getAxisOrientation() == HORIZONTAL) {
							if (Double.isNaN(accumulatedHighValues[categoryList.size() - i - 1])) 
								accumulatedHighValues[categoryList.size() - i - 1] = dp.getValue();
							else
								accumulatedHighValues[categoryList.size() - i - 1] += dp.getValue();
						}else{
							if (Double.isNaN(accumulatedHighValues[i])) 
								accumulatedHighValues[i] = dp.getValue();
							else
								accumulatedHighValues[i] += dp.getValue();							
						}
					}else{
						if (!isLTR && indepAxis.getAxisOrientation() == HORIZONTAL) {
							if (Double.isNaN(accumulatedLowValues[categoryList.size() - i - 1])) 
								accumulatedLowValues[categoryList.size() - i - 1]	= dp.getValue();
							else
								accumulatedLowValues[categoryList.size() - i - 1]	+= dp.getValue();
						}else{
							if (Double.isNaN(accumulatedLowValues[i])) 
								accumulatedLowValues[i]	= dp.getValue();
							else
								accumulatedLowValues[i]	+= dp.getValue();
						}
					}
				}			
			}
		}
	}

}

