/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackBar3D.java,v 1.3 2005/09/23 18:35:36 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataSetStackBar3D.java,v 1.3 2005/09/23 18:35:36 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeComponentTransfer;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeFunc;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * <code>DataSetStackBar3D</code> is class to add stack bar in the plot area for stack bar chart.  The
 * stack bars are drawn in a 3-D space. 
 */
public class DataSetStackBar3D extends DataSet {
	static final long serialVersionUID = 3424278988980540064L;
	protected double y3Doffset;
    protected double x3Doffset;
    protected Object category;
    protected List dataList;
    protected String[] colors;
    protected AxisCategory indepAxis;
    protected AxisNumber depAxis;
    protected CategoricalData[] sortedDatapoints;
    protected int colorIndex;
    protected int categoryIndex;
    protected List categoryList;
    protected double[] groupDataPositions;
    protected double depAxisMax;
    protected double depAxisMin;
    protected double axisLenght;
    protected boolean linear;
    protected double barWidth;
    protected double[] accumulatedHighValues;
    protected double[] accumulatedLowValues;
    protected int datasetIndex;
    protected boolean isLTR = true;
    protected SVGColorPalettes palettes;
    

    /**
     * Constructor
     * 
     * @param input
     * @param indepAxis
     * @param depAxis
     * @param dataset
     * @param colorIndex
     * @param barWidth
     * @param xPosition
     * @param groupInterval
     */
    public DataSetStackBar3D(String[] colors, Chart input, boolean isLTR,
        AxisCategory indepAxis, AxisNumber depAxis, List dataset,
        Object category, int categoryIndex, double barWidth,
        double[] accumulatedLowValues, double[] accumulatedHighValues,
        double x3Doffset, double y3Doffset, SVGColorPalettes palettes, NLString nls) {
        super(input, nls);
        this.indepAxis = indepAxis;
        this.depAxis = depAxis;
        this.dataList = dataset;
        this.barWidth = barWidth;
        this.accumulatedHighValues = accumulatedHighValues;
        this.accumulatedLowValues = accumulatedLowValues;
        this.isLTR = isLTR;
        linear = depAxis.isLinear();
        groupDataPositions = indepAxis.getGroupDataPositions();
        this.axisLenght = indepAxis.getAxisLength();
        depAxisMax = depAxis.getMax();
        this.categoryIndex = categoryIndex;
        depAxisMin = depAxis.getMin();
        this.y3Doffset = y3Doffset;
        this.category = category;
        this.x3Doffset = x3Doffset;
        this.colors = colors;
        this.palettes = palettes;
        sortDataPoints();
    }

    /* (non-Javadoc)
     * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPart#constructPart()
     */
    protected void constructPart() {
        // create bar group
        ArrayList lowValues = new ArrayList();
        ArrayList highValues = new ArrayList();
        SVGBase[] barpart = new SVGBase[2];
        setChildren(barpart);

        SVGGroup barGroup1 = new SVGGroup();
        SVGBase[] barGroupChild = new SVGBase[1];
        barpart[0] = barGroup1;
        barGroup1.setChildren(barGroupChild);
        barGroup1.setIdentifier(((Category) category).getId());

        SVGGroup barset = new SVGGroup();
        int partNum = sortedDatapoints.length + 1;

        // n points + a line (a group of lines segments)
        SVGBase[] barparts = new SVGBase[partNum+2];
        barGroupChild[0] = barset;
        barset.setChildren(barparts);

        //		barset.setStyleClass("bars" + colorIndex);
        //		barset.setIdentifier("SVGGEN_dataColour" + datasetIndex);

        //add 3d filters
        SVGFilter filter = new SVGFilter();
        filter.setIdentifier("right-dimension");

        SVGFeComponentTransfer[] feComponentTransferPart = new SVGFeComponentTransfer[1];
        SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);

        SVGFeFunc[] feFuncPart = new SVGFeFunc[3];
        SVGFeFunc feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;

        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;

        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;

        feComponentTransfer.setChildren(feFuncPart);

        addDefinition(filter);

        filter = new SVGFilter();
        filter.setIdentifier("top-dimension");

        feComponentTransferPart = new SVGFeComponentTransfer[1];
        feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);

        feFuncPart = new SVGFeFunc[3];
        feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;

        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;

        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;

        feComponentTransfer.setChildren(feFuncPart);

        addDefinition(filter);

        //end of add 3d filters
        double min = Math.pow(10.0, depAxisMin);
        double previousX = 0;
        double previousY = 0;
        double curX = 0;
        double curY = 0;
        double[] groupPosition = indepAxis.groupDataPositions;

        if (indepAxis.getAxisOrientation() == HORIZONTAL) {
            double zero = getCoordinate(linear, 0, 0.0,
                    Double.parseDouble(getHeight()) - Math.abs(y3Doffset),
                    depAxisMax, depAxisMin);

            for (Iterator iter = dataList.iterator(); iter.hasNext();) {
                org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) iter.next();
                int i = dataList.indexOf(dataset);
                int colorIndex = i % colors.length;
                CategoricalData dp;

                if (isLTR) {
                    dp = sortedDatapoints[i];
                } else {
                    dp = sortedDatapoints[dataList.size() - i - 1];
                }

				if (dp == null || (!linear && dp.getValue() <= 0) || dp.getValue() == 0) {
                    continue;
                }

                // add the shape for the datapoint
                SVGGroup pointGroup = new SVGGroup();
                SVGBase[] point = new SVGBase[4];
                pointGroup.setChildren(point);
                pointGroup.setStyleClass("bars" + colorIndex);
                pointGroup.setIdentifier(categoryIndex + "SVGGEN_dataColour" +
                    i);

                // Handle data value toggle
                pointGroup.addEvent("onclick",
                    "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");

                // Handle value tooltip
                point[2] = EventTools.generateValueTooltip(pointGroup,
                        depAxis.formatValue(dp.getValue()));

                // Handle user tooltips
                point[1] = EventTools.generateUserTooltip(pointGroup,
                        dp.getTooltip(), nls);

                // Handle user events
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());

                // Handle accessibility
                EventTools.generateAccessibility(pointGroup,
                    dp.getAccessibility(), nls);

                //				pointGroup.setIdentifier(dp.getId());
                double yValue = dp.getValue();
                double lastYValue = 0.0;
                curX = groupPosition[categoryIndex];

                if (yValue >= 0.0) {
                	highValues.add(pointGroup);
                    yValue = dp.getValue() +
                        accumulatedHighValues[categoryIndex];

                    double value = 0.0;

                    if (!linear) {
                        if (accumulatedHighValues[categoryIndex] == 0.0) {
                            value = min;
                        } else {
                            value = accumulatedHighValues[categoryIndex];
                        }
                    } else {
                        value = accumulatedHighValues[categoryIndex];
                    }

                    lastYValue = getCoordinate(linear, value, 0.0,
                            Double.parseDouble(getHeight()) -
                            Math.abs(y3Doffset), depAxisMax, depAxisMin);
                    accumulatedHighValues[categoryIndex] = yValue;
                } else {
                	lowValues.add(pointGroup);
                    yValue = dp.getValue() +
                        accumulatedLowValues[categoryIndex];
                    lastYValue = getCoordinate(linear,
                            accumulatedLowValues[categoryIndex], 0.0,
                            Double.parseDouble(getHeight()) -
                            Math.abs(y3Doffset), depAxisMax, depAxisMin);
                    accumulatedLowValues[categoryIndex] = yValue;
                }

				if ((!linear && dp.getValue() < min)  || (linear && dp.getValue() < depAxisMin) ) {
                    continue;
                }

                curY = getCoordinate(linear, yValue, 0.0,
                        Double.parseDouble(getHeight()) - Math.abs(y3Doffset),
                        depAxisMax, depAxisMin);
                barparts[i + 1] = pointGroup;

                if (categoryIndex >= 0) {
                    SVGText barTextSegment = new SVGText();
                    String tooltipID = "SVGGEN_datavalue_" + dataset.getId() +
                        "_" + EventTools.getUniqueID();
                    barTextSegment.setText(depAxis.formatValue(dp.getValue()));
                    barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                    barTextSegment.setStyleClass("anchorAtMiddle");
                    barTextSegment.setVisibility("hidden");
                    barTextSegment.setXCoordinate(Double.toString(curX));

                    if (dp.getValue() < 0.0) {
                        barTextSegment.setYCoordinate(Double.toString(curY +
                                BASE_FONT_SIZE + y3Doffset));
                    } else {
                        barTextSegment.setYCoordinate(Double.toString(curY -
                                2.0 + y3Doffset));
                    }

                    barTextSegment.setIdentifier(tooltipID);

                    Line3D barSegment = new Line3D();
					barSegment.setIsNeg(dp.getValue() < 0.0);
					barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
					barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                    barSegment.setIsHorizontal(true);
					//barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					barSegment.setIsLTR(isLTR);
                    barSegment.setLinear(linear);
                    barSegment.setYMax(Double.parseDouble(getHeight()));
                    barSegment.setYMin(0);
                    barSegment.setXMin(0);
                    barSegment.setXMax(Double.parseDouble(getWidth()));
                    barSegment.setZeroYCoord(zero);
                    barSegment.setY3Doffset(y3Doffset);
                    barSegment.setX3Doffset(x3Doffset);
                    barSegment.setX1(Double.toString(curX));
                    barSegment.setY1(Double.toString(lastYValue));
                    barSegment.setX2(Double.toString(curX));
                    barSegment.setY2(Double.toString(curY));
                    barSegment.setStrokeWidth(Double.toString(barWidth));
                    barSegment.setTopDimensionFilter("url(#top-dimension)");
                    barSegment.setRightDimensionFilter("url(#right-dimension)");
                    barSegment.setStacked(true);
					String dataSetColor = palettes.getDataSetColor(dataset.getId());
					if (dataSetColor != null) {
						barSegment.setStyleClass("linestyle3D");
						barSegment.setFill(dataSetColor);
					} else {
						barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					}


                    point[0] = barSegment;

                    SVGBase[] groupChild = new SVGBase[1];
                    groupChild[0] = barTextSegment;
                }

                previousX = curX;
                previousY = curY;
            }
    	    //Need to sort the bar group array so that the draw order is correct.  Otherwise the graph will look wrong
	        int i = 1;
    	    Iterator iter = null;
	        iter = lowValues.iterator();
	        while (iter.hasNext()){
    	    	barparts[i] = (SVGBase)iter.next();
	        	i++;
    	    }
	        iter = highValues.iterator();
	        while (iter.hasNext()){
        		barparts[i] = (SVGBase)iter.next();
    	    	i++;
	        }
            
        } else {
            double zero = 0.0;
            ArrayList drawLater = new ArrayList();
            int numOfDrawnBars = 0;
            for (Iterator iter = dataList.iterator(); iter.hasNext();) {
                org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) iter.next();
                int i = dataList.indexOf(dataset);
                int colorIndex = i % colors.length;

                CategoricalData dp = sortedDatapoints[i];

				if (dp == null || (!linear && dp.getValue() <= 0) || (dp.getValue() == 0)) {
                    continue;
                }

                SVGGroup pointGroup = new SVGGroup();
                pointGroup.setStyleClass("bars" + colorIndex);
                pointGroup.setIdentifier(categoryIndex + "SVGGEN_dataColour" +
                    i);

                SVGBase[] point = new SVGBase[3];
                pointGroup.setChildren(point);

                // Handle data value toggle
                pointGroup.addEvent("onclick",
                    "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");

                // Handle value tooltip
                point[2] = EventTools.generateValueTooltip(pointGroup,
                        depAxis.formatValue(dp.getValue()));

                // Handle user tooltips
                point[1] = EventTools.generateUserTooltip(pointGroup,
                        dp.getTooltip(), nls);

                // Handle user events
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());

                // Handle accessibility
                EventTools.generateAccessibility(pointGroup,
                    dp.getAccessibility(), nls);

                double xValue = dp.getValue();
                double lastXValue = 0.0;
                curY = indepAxis.getAxisLength() -
                    groupPosition[categoryIndex];

                double value = 0.0;

                if (!linear) {
                    if (accumulatedHighValues[categoryIndex] == 0.0) {
                        value = min;
                    } else {
                        value = accumulatedHighValues[categoryIndex];
                    }
                } else {
                    value = accumulatedHighValues[categoryIndex];
                }

                if (xValue >= 0.0) {
                	highValues.add(pointGroup);
                    xValue = dp.getValue() +
                        accumulatedHighValues[categoryIndex];

                    if (isLTR) {
                        lastXValue = getCoordinate(linear, value,
                                Double.parseDouble(getWidth()) - x3Doffset,
                                0.0, depAxisMax, depAxisMin);
                    } else {
                        lastXValue = getCoordinate(linear, value, 0.0,
                                Double.parseDouble(getWidth()) - x3Doffset,
                                depAxisMax, depAxisMin);
                    }

                    accumulatedHighValues[categoryIndex] = xValue;
                } else {
                	lowValues.add(pointGroup);
                    xValue = dp.getValue() +
                        accumulatedLowValues[categoryIndex];

                    if (isLTR) {
                        lastXValue = getCoordinate(linear,
                                accumulatedLowValues[categoryIndex],
                                Double.parseDouble(getWidth()) - x3Doffset,
                                0.0, depAxisMax, depAxisMin);
                    } else {
                        lastXValue = getCoordinate(linear,
                                accumulatedLowValues[categoryIndex], 0.0,
                                Double.parseDouble(getWidth()) - x3Doffset,
                                depAxisMax, depAxisMin);
                    }

                    accumulatedLowValues[categoryIndex] = xValue;
                }

				if ((!linear && dp.getValue() < min)  || (linear && dp.getValue() < depAxisMin) ) {
                    continue;
                }


                if (isLTR) {
                    curX = getCoordinate(linear, xValue,
                            Double.parseDouble(getWidth()) - x3Doffset, 0.0,
                            depAxisMax, depAxisMin);
                    zero = getCoordinate(linear, 0,
                            Double.parseDouble(getWidth()) - x3Doffset, 0.0,
                            depAxisMax, depAxisMin);
                } else {
                    curX = getCoordinate(linear, xValue, 0.0,
                            Double.parseDouble(getWidth()) - x3Doffset,
                            depAxisMax, depAxisMin);
                    zero = getCoordinate(linear, 0, 0.0,
                            Double.parseDouble(getWidth()) - x3Doffset,
                            depAxisMax, depAxisMin);
                }

				//for horizontal bidi charts the graph needs to be drawn in a certain order otherwise
				//the chart will not look 3-D.  Drawing 3-D elements on a 2-d canvas greatly depends on the draw
				//order
                barparts[i + 1] = pointGroup;

                if (categoryIndex >= 0){
                    SVGText barTextSegment = new SVGText();
                    String tooltipID = "SVGGEN_datavalue_" + dataset.getId() +
                        "_" + EventTools.getUniqueID();
                    barTextSegment.setText(depAxis.formatValue(dp.getValue()));
                    barTextSegment.setStyle("font-size:" + BASE_FONT_SIZE + "pt;stroke:none;fill:black");
                    barTextSegment.setVisibility("hidden");
                    barTextSegment.setXCoordinate(Double.toString(curX));

                    if (dp.getValue() < 0.0) {
                        barTextSegment.setStyleClass("anchorAtEnd");
                    } else {
                        barTextSegment.setStyleClass("anchorAtStart");
                    }

                    barTextSegment.setIdentifier(tooltipID);

                    SVGGroup barGroup = new SVGGroup();
                    barGroup.setStyleClass("bars" + colorIndex);
                    barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
                    // barGroup.addEvent("onload",
                    //    "SVGGEN_moveNode(evt, 'SVGGEN_plotBarsForeground');");

                    Line3D barSegment = new Line3D();
					barSegment.setIsNeg(dp.getValue() < 0.0);
					barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
					barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                    barSegment.setIsHorizontal(false);
					//barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					barSegment.setIsLTR(isLTR);
                    barSegment.setLinear(linear);
                    barSegment.setYMax(Double.parseDouble(getHeight()));
                    barSegment.setYMin(0);
                    barSegment.setXMin(0);
                    barSegment.setZeroXCoord(zero);
                    barSegment.setXMax(Double.parseDouble(getWidth()) -
                        x3Doffset);
                    barSegment.setY3Doffset(y3Doffset);
                    barSegment.setX3Doffset(x3Doffset);
                    barSegment.setX1(Double.toString(lastXValue));
                    barSegment.setY1(Double.toString(curY));
                    barSegment.setX2(Double.toString(curX));
                    barSegment.setY2(Double.toString(curY));
                    barSegment.setStrokeWidth(Double.toString(barWidth));
                    barSegment.setTopDimensionFilter("url(#top-dimension)");
                    barSegment.setRightDimensionFilter("url(#right-dimension)");
                    barSegment.setStacked(true);
					String dataSetColor = palettes.getDataSetColor(dataset.getId());
					if (dataSetColor != null) {
						barSegment.setStyleClass("linestyle3D");
						barSegment.setFill(dataSetColor);
					} else {
						barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
					}

                    point[0] = barSegment;

                    SVGBase[] groupChild = new SVGBase[1];
                    barGroup.setChildren(groupChild);
                    groupChild[0] = barTextSegment;
                }

                previousX = curX;
                previousY = curY;
            }
    	    //Need to sort the bar group array so that the draw order is correct.  Otherwise the graph will look wrong
	        int i = 1;
    	    Iterator iter = null;
    	    if (isLTR)
		        iter = lowValues.iterator();
    	    else
		        iter = highValues.iterator();
	        while (iter.hasNext()){
    	    	barparts[i] = (SVGBase)iter.next();
	        	i++;
    	    }
    	    if (isLTR)
		        iter = highValues.iterator();
    	    else{
   				double barInterval = indepAxis.getAxisLength() / (double)indepAxis.categoryList.size(); 

				barparts[i] = drawVerticalZeroLine(zero, curY, barInterval);
    	    	i++;
		        iter = lowValues.iterator();
    	    }
	        while (iter.hasNext()){
        		barparts[i] = (SVGBase)iter.next();
    	    	i++;
	        }
                        
        }
                
    }
    
    /**
     * Draw vertical "zero line".  Draws a solid line perpendicular to the
     * axis at the value 0.
     *
     * @param line_x
     * @return
     */
    protected SVGBase drawVerticalZeroLine(double line_x, double curY, double intervalWidth) {
    	height = intervalWidth;
    	curY = curY - intervalWidth/2+y3Doffset;
        SVGPolygon verticalZeroLineDef = new SVGPolygon();
        verticalZeroLineDef.setPoints(line_x+"," + (curY) + " " + (line_x+x3Doffset) +
            ","+(curY-(y3Doffset))+" " + (line_x+x3Doffset) + "," + (height + (curY-(y3Doffset))) + " "+line_x+"," + (curY+height));
        verticalZeroLineDef.setStyleClass("zero3DAxisLines");

        return verticalZeroLineDef;
    }

    

    /**
     * Sort data points by category id
     * The order of categories follow the order specified in the category
     * section of the input xml.
     */
    protected void sortDataPoints() {
        sortedDatapoints = new CategoricalData[dataList.size()];

        for (Iterator iter = dataList.iterator(); iter.hasNext();) {
            org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) iter.next();
            List datapoints = dataset.getDataPoint();
            int i = dataList.indexOf(dataset);

            for (Iterator dataIter = datapoints.iterator(); dataIter.hasNext();) {
                CategoricalData dp = (CategoricalData) dataIter.next();

                if (((Category) dp.getCategoryId()).getId().equals(((Category) category).getId())) {
                    sortedDatapoints[i] = dp;
                }
            }
        }

        CategoricalData dp;
        for (int i = 0; i < (sortedDatapoints.length); i++) {
            dp = sortedDatapoints[i];

            if (dp == null) {
                continue;
            }

            if (dp.getValue() >= 0.0) {
				if (Double.isNaN(accumulatedHighValues[categoryIndex])) 
					accumulatedHighValues[categoryIndex] = dp.getValue();
				else
					accumulatedHighValues[categoryIndex] += dp.getValue();
            } else {
				if (Double.isNaN(accumulatedLowValues[categoryIndex])) 
					accumulatedLowValues[categoryIndex] = dp.getValue();
				else
					accumulatedLowValues[categoryIndex] += dp.getValue();
            }
        }
    }

    //	}
}
