/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultResources.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.HashMap;
import java.util.List;

import org.eclipse.tptp.platform.report.chart.svg.internal.util.PalettesDOMDocument;
import org.w3c.dom.Element;


/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultResources.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/



/**
 * 
 */
public class DefaultResources {
	private String resourceDir = null;
	
	private boolean defaultShapesInitialized = false;
	private String[] defaultShapeIds;
	private double[] defaultShapeWidths;
	private double[] defaultShapeHeights;
	private Element[] defaultShapeDefinitions;

	private boolean defaultPalettesInitialized = false;
	private PalettesDOMDocument defaultPalettesDOM;
	private String defaultPalettesId;
	private HashMap defaultGraphicColorPalettes = null;
	private HashMap defaultPaletteDisplayNames = null;
	private String [] defaultColorPalettes = null;
	private Object  defaultPaletteSetId = null;
	private List defaultColorPaletteSet = null;
	private String defaultColorPaletteDisplayName = null;
	private String paletteResourceBundle = null;

	
	public DefaultResources() {
	}
	
	public DefaultResources(String resourceDir) {
		this.resourceDir = resourceDir;
	}

	/**
	 * @return
	 */
	public synchronized String[] getDefaultColorPalettes() {
		return defaultColorPalettes;
	}

	/**
	 * @return
	 */
	public synchronized List getDefaultColorPaletteSet() {
		return defaultColorPaletteSet;
	}

	/**
	 * @return
	 */
	public synchronized HashMap getDefaultGraphicColorPalettes() {
		return defaultGraphicColorPalettes;
	}

	/**
	 * @return
	 */
	public synchronized PalettesDOMDocument getDefaultPalettesDOM() {
		return defaultPalettesDOM;
	}

	/**
	 * @return
	 */
	public synchronized Object getDefaultPaletteSetId() {
		return defaultPaletteSetId;
	}

	/**
	 * @return
	 */
	public synchronized String getDefaultPalettesId() {
		return defaultPalettesId;
	}

	/**
	 * @return
	 */
	public synchronized boolean isDefaultPalettesInitialized() {
		return defaultPalettesInitialized;
	}

	/**
	 * @return
	 */
	public synchronized Element[] getDefaultShapeDefinitions() {
		return defaultShapeDefinitions;
	}

	/**
	 * @return
	 */
	public synchronized double[] getDefaultShapeHeights() {
		return defaultShapeHeights;
	}

	/**
	 * @return
	 */
	public synchronized String[] getDefaultShapeIds() {
		return defaultShapeIds;
	}

	/**
	 * @return
	 */
	public synchronized boolean isDefaultShapesInitialized() {
		return defaultShapesInitialized;
	}

	/**
	 * @return
	 */
	public synchronized double[] getDefaultShapeWidths() {
		return defaultShapeWidths;
	}

	/**
	 * @return
	 */
	public synchronized String getResourceDir() {
		return resourceDir;
	}

	/**
	 * @param strings
	 */
	public synchronized void setDefaultColorPalettes(String[] strings) {
		defaultColorPalettes = strings;
	}

	/**
	 * @param list
	 */
	public synchronized void setDefaultColorPaletteSet(List list) {
		defaultColorPaletteSet = list;
	}

	/**
	 * @param map
	 */
	public synchronized void setDefaultGraphicColorPalettes(HashMap map) {
		defaultGraphicColorPalettes = map;
	}

	/**
	 * @param document
	 */
	public synchronized void setDefaultPalettesDOM(PalettesDOMDocument document) {
		defaultPalettesDOM = document;
	}

	/**
	 * @param object
	 */
	public synchronized void setDefaultPaletteSetId(Object object) {
		defaultPaletteSetId = object;
	}

	/**
	 * @param string
	 */
	public synchronized void setDefaultPalettesId(String string) {
		defaultPalettesId = string;
	}

	/**
	 * @param b
	 */
	public synchronized void setDefaultPalettesInitialized(boolean b) {
		defaultPalettesInitialized = b;
	}

	/**
	 * @param elements
	 */
	public synchronized void setDefaultShapeDefinitions(Element[] elements) {
		defaultShapeDefinitions = elements;
	}

	/**
	 * @param ds
	 */
	public synchronized void setDefaultShapeHeights(double[] ds) {
		defaultShapeHeights = ds;
	}

	/**
	 * @param strings
	 */
	public synchronized void setDefaultShapeIds(String[] strings) {
		defaultShapeIds = strings;
	}

	/**
	 * @param b
	 */
	public synchronized void setDefaultShapesInitialized(boolean b) {
		defaultShapesInitialized = b;
	}

	/**
	 * @param ds
	 */
	public synchronized void setDefaultShapeWidths(double[] ds) {
		defaultShapeWidths = ds;
	}

	/**
	 * @param string
	 */
	public synchronized void setResourceDir(String string) {
		resourceDir = string;
	}

	/**
	 * @return
	 */
	public synchronized String getDefaultColorPaletteDisplayName() {
		return defaultColorPaletteDisplayName;
	}

	/**
	 * @param string
	 */
	public synchronized void setDefaultColorPaletteDisplayName(String newDefaultColorPaletteDisplayName) {
		defaultColorPaletteDisplayName = newDefaultColorPaletteDisplayName;
	}

	/**
	 * @return
	 */
	public synchronized HashMap getDefaultPaletteDisplayNames() {
		return defaultPaletteDisplayNames;
	}

	/**
	 * @param map
	 */
	public synchronized void setDefaultPaletteDisplayNames(HashMap newDefaultPaletteDisplayNames) {
		defaultPaletteDisplayNames = newDefaultPaletteDisplayNames;
	}

	/**
	 * @return
	 */
	public synchronized String getPaletteResourceBundle() {
		return paletteResourceBundle;
	}

	/**
	 * @param string
	 */
	public synchronized void setPaletteResourceBundle(String string) {
		paletteResourceBundle = string;
	}

}
