/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ECMAScriptGenerator.java,v 1.2 2005/09/23 17:19:25 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ECMAScriptGenerator.java,v 1.2 2005/09/23 17:19:25 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * <code>ECMAScriptGenerator</code> generates the (ECMA 1.0-compliant) JavaScript functions
 * needed to support browser-based user interaction with <code>GraphicDocumentGenerators</code> 
 * that generate Scalable Vector Graphics (SVG).
 * 
 * $Revision: 1.2 $
 * 
 */
public class ECMAScriptGenerator {
	private StringBuffer script;
	private static final String eol = "\n";
//	private static final String eol = "" ;
	
	/** 
	 * Generates browser information variables for use in browser specific code.
	 */
	public String generateClientSnifferVariables(){
		script = new StringBuffer("var SVGGEN_browserVersion = parseInt(parent.navigator.appVersion); ");
		script.append("var SVGGEN_isNN = parent.navigator.appName.indexOf(\"Netscape\")!= -1; ").append(eol);
		script.append("var SVGGEN_isIE = parent.navigator.appName.indexOf(\"Microsoft\")!= -1; ").append(eol);
				
		return script.toString();
	}	
	
	/** 
	 * Generates null browser information variables for use when SVG is transcoded to other formats
	 */
	public String generateNullClientSnifferVariables(){
		script = new StringBuffer("var SVGGEN_browserVersion = null;");
		script.append("var SVGGEN_isNN = false;").append(eol);
		script.append("var SVGGEN_isIE = false; ").append(eol);
				
		return script.toString();
	}	
	
	/** 
	 * Generates global variables for use in HTML functions.
	 */
	public String generateGlobalVariables(){		
		script = new StringBuffer("var SVGGEN_currentValues = null; ");
		script.append("var SVGGEN_palettes = null; ").append(eol);
		script.append("var SVGGEN_preferencePage = null;").append(eol);
		return script.toString();
	}
	
	/** 
	 * Generates an event handler which performs initialization functions.
	 * Typically assigned as the "onload" event handler. 
	 * 
	 * @param palettes the available data set color palettes 
	 * @param type		the graphic type
	 */
	public String generateInitFunction(String userPreferences, SVGColorPalettes palettes,
			String currentFont, 
			String cookieName, String type, List dataSetList, int numCat, int sets, String updatedUserPrefsVarName, 
			String svgDocumentVariable, String svgWindowVariable, boolean showShapes){

		HashMap paletteSet = palettes.getGraphicColorPalettes();
		String defaultPaletteName = null;
//		String defaultPaletteId = palettes.getPaletteId();	

		script = new StringBuffer();
		
		script.append("function SVGGEN_init(e){").append(eol);

		// Export useful references to the parent HTML 
		if (svgDocumentVariable != null) {
			script.append("  parent.");
			script.append(svgDocumentVariable);
			script.append(" = e.target.ownerDocument;").append(eol);
		}
		if (svgWindowVariable != null) {
			script.append("  parent.");
			script.append(svgWindowVariable);
			script.append(" = window;").append(eol);
		}
		
		// Corel plugin does not seem to initialize global variables correctly
		script.append("  SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("  SVGGEN_currentValues = null;").append(eol);
		if (showShapes)
			script.append("  SVGGEN_noShapes = false;").append(eol);
		else
			script.append("  SVGGEN_noShapes = true;").append(eol);
		
		// call all moveNode methods for area chart
		if (type.equals(IGraphicTypeConstants.AREA_CHART) || type.equals(IGraphicTypeConstants.STACK_AREA_CHART)){
			if (dataSetList != null)
				for (Iterator i = dataSetList.iterator(); i.hasNext(); ) {
					org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = 
					(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) i.next();
					int datasetIndex = dataSetList.indexOf(dataset);
						script.append("  SVGGEN_moveNode('SVGGEN_area" + datasetIndex + "', 'SVGGEN_plotareaBackground');").append(eol);
				}
		}
		
		// call all moveNode methods for bar chart
		if (type.equals(IGraphicTypeConstants.HBAR_CHART) || type.equals(IGraphicTypeConstants.HBAR_CHART3D) ||
			type.equals(IGraphicTypeConstants.VBAR_CHART) || type.equals(IGraphicTypeConstants.VBAR_CHART3D) ||
			type.equals(IGraphicTypeConstants.HSTACKBAR_CHART) || type.equals(IGraphicTypeConstants.HSTACKBAR_CHART3D) ||
			type.equals(IGraphicTypeConstants.VSTACKBAR_CHART) || type.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D)) {
			if (dataSetList != null) 
				for (Iterator i = dataSetList.iterator(); i.hasNext(); ) {
					org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset = 
					(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet) i.next();
					script.append("  for (var i = 0; i < " + numCat + "; i++)");
						script.append("  SVGGEN_moveNode('SVGGEN_bar_" + dataset.getId() + "', 'SVGGEN_plotareaForeground_" + dataset.getId() + "');").append(eol);
				}
		}
			
		// dynamically set the hover text box attributes (add 3 to each end for spacing)
//		script.append("var svgDocument = e.target.ownerDocument;").append(eol);
//		script.append("if (svgDocument != null) {").append(eol);
//		script.append("	var t = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
//		script.append("	var bbox;").append(eol);
//		script.append("	if (t != null) {").append(eol);
//		script.append("   bbox = t.getBBox();").append(eol);
//		script.append("	}").append(eol);
//		script.append(" var hoverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
//		script.append(" if (hoverBoxElement != null && bbox != null) {").append(eol);
//		script.append("   hoverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
//		script.append("   hoverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
//		script.append("   hoverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
//		script.append("   hoverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
//		script.append(" }").append(eol);
//		script.append(" var hoverGroup = svgDocument.getElementById('preferencesHoverText');").append(eol);
//		script.append(" if (hoverGroup != null) {").append(eol);
//		script.append("  hoverGroup.setAttribute('visibility', 'hidden');").append(eol);
//		script.append(" }").append(eol);
//		
//		
//		script.append("  var rectElement = null;").append(eol);
//		script.append("  for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
//		script.append("    var number = 0; ").append(eol);
//		script.append("    while ((rectElement = svgDocument.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
//		script.append("    var hoverBoxText = svgDocument.getElementById('textboxText' + i + number);").append(eol);
//		script.append("    if (hoverBoxText != null) { ").append(eol);
//		script.append("      hoverBoxText.setAttribute('visibility', 'visible');").append(eol);
//		script.append("      bbox = hoverBoxText.getBBox();").append(eol);
//		script.append("      var originalBoxY = rectElement.getAttribute('y');").append(eol);
//		script.append("      var originalBoxX = rectElement.getAttribute('x');").append(eol);
//	//	script.append("      if ( (parseFloat(originalBoxY) + bbox.height + 6) > ").append(gridYOffset + yAxisLength).append(") {").append(eol);
//	//	script.append("        rectElement.setAttribute('y', (originalBoxY - bbox.height - 6 - 1));").append(eol);
//	//	script.append("      }").append(eol);
//		script.append("      rectElement.setAttribute('width', bbox.width + 6);").append(eol);
//		script.append("      rectElement.setAttribute('height', bbox.height + 6);").append(eol);
//		script.append("      rectElement.setAttribute('visibility', 'visible');").append(eol);
//		script.append("      hoverBoxText.setAttribute('x', parseFloat(rectElement.getAttribute('x')) + (bbox.width + 6) / 2);").append(eol);
//		script.append("      hoverBoxText.setAttribute('y', parseFloat(rectElement.getAttribute('y')) + bbox.height + 3);").append(eol);
//		script.append("      hoverBoxText.setAttribute('visibility', 'visible');").append(eol);
//		script.append("    }").append(eol);
//		script.append("    number++;").append(eol);
//		script.append("    }").append(eol);
//		script.append("  }").append(eol);
//		
//		
//		script.append("}").append(eol);   // end of if svgDocument != null

		
		if (paletteSet == null || paletteSet.isEmpty()) {
			script.append("} ").append(eol);
			return script.toString();
		}			
		
		// create the colour palettes array		
		script.append("SVGGEN_palettes = new Array();").append(eol);
		
		
		Iterator keys = (paletteSet.keySet()).iterator();
		int i = 0;
		while (keys.hasNext()) {
			String id = (String)keys.next();
			String [] codes = (String [])paletteSet.get(id);
			
			script.append("SVGGEN_palettes[");
			script.append(i);
			script.append("] = [");
			// add the colour codes
			for (int j = 0; j < codes.length; j++) {
				script.append("\"");
				script.append(codes[j]);
				script.append("\", ");
			}		
			
			// add the palette name	
			script.append("\"");
			script.append(palettes.getPaletteDisplayName(id));
			script.append("\"");
			script.append("];").append(eol);
			i++;
			
			if (defaultPaletteName == null) {
				defaultPaletteName = palettes.getPaletteDisplayName(id);
			}
		}
		
		// get any user preferences previously saved to a cookie
		if (cookieName != null) {
			script.append("SVGGEN_currentValues = SVGGEN_getPreferences();").append(eol);
		}			
	    script.append("if (SVGGEN_currentValues != null) {").append(eol);
		script.append("SVGGEN_updateStyles(SVGGEN_currentValues, true);}").append(eol);
		
		// OR initialize the current values with the user preferences passed in
		if (userPreferences != null) {
			int numberOfPreferences = IGraphicDocumentStyle.NUMBER_OF_PREFERENCES;
			int lastCommaIndex = 0;
			int nextCommaIndex = 0;
			String userPreference = null;
			script.append("else {SVGGEN_currentValues = [\"");
			// first preference
			nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex);			
			userPreference = userPreferences.substring(lastCommaIndex,  nextCommaIndex);			
			script.append(userPreference);
			script.append("\",\"");			
			
			for (int k = 0; k < numberOfPreferences - 2; k++) {
				lastCommaIndex = nextCommaIndex;
				nextCommaIndex = userPreferences.indexOf(",", lastCommaIndex + 1);			
				userPreference = userPreferences.substring(lastCommaIndex + 1, nextCommaIndex);
				script.append(userPreference);
				script.append("\",\"");	
			}
			
			// last preference
			lastCommaIndex = nextCommaIndex;							
			userPreference = userPreferences.substring(lastCommaIndex + 1, userPreferences.length());
			script.append(userPreference);					
			script.append("\"];SVGGEN_updateStyles(SVGGEN_currentValues, true); }").append(eol);	
				
		}
		else {	
			// OR initialize the current values with the default settings		
			String defaultFont = IGraphicDocumentStyle.BASIC_FONTSTYLE;
			String newDefaultFont = defaultFont.substring(0, defaultFont.indexOf("font-family") + "font-family".length() + 1)
									+ currentFont 
									+ defaultFont.substring(defaultFont.indexOf("; fill"), defaultFont.length());
					
			script.append("else {SVGGEN_currentValues = [\"");
//			script.append(palettes.getPaletteId());
			script.append(palettes.getPaletteDisplayName());
			script.append("\",\"");
			script.append(IGraphicDocumentStyle.BASIC_FONTSIZE);
			script.append("\",\"");
			script.append(newDefaultFont);
			script.append("\",\"");
			script.append(IGraphicDocumentStyle.BASIC_SHOW_SHAPES);
			script.append("\",\"");
			// default for show values in pie chart is ON, all others OFF
			if (type.equals(IGraphicTypeConstants.PIE_CHART) || type.equals(IGraphicTypeConstants.PIE_CHART3D)) {
				script.append("1");
			}
			else {	
				script.append(IGraphicDocumentStyle.BASIC_SHOW_VALUES);
			}
			script.append("\",\"");
			script.append(IGraphicDocumentStyle.BASIC_SHOW_PERCENTS);
			script.append("\"];SVGGEN_updateStyles(SVGGEN_currentValues, true);}").append(eol);
			
		}
		if (updatedUserPrefsVarName != null) {			
			script.append("	parent.");
			script.append(updatedUserPrefsVarName);
			script.append(" = SVGGEN_currentValues;").append(eol);			
		}	
		
		if (type.equals(IGraphicTypeConstants.STACK_AREA_CHART)) {
			script.append("	SVGGEN_regen();");	
		}
		script.append("} ").append(eol);
		script.append("SVGGEN_defaultPaletteName = \"" + palettes.getPaletteDisplayName() + "\";").append(eol);
		script.append("function SVGGEN_getDefaultPaletteName() {").append(eol);
		script.append("return SVGGEN_defaultPaletteName;}").append(eol);
		return script.toString();
	}	
	
	/** 
	 * Generates a function which opens a new browser window on the content "url" + "src" 
	 * with the specified "name", "width" and "height". 
	 * 
	 * @param url		the URL to the folder which contains "src"
	 * @param src		the content file
	 * @param name		the name of the new window
	 * @param width	the width of the new window
	 * @param height	the height of the new window
	 */	
	public String generateOpenPreferencePageFunction(String url, String src, String name, String width, String height){

		script = new StringBuffer("function SVGGEN_openPreferencePage(){");
		// needed for basic types preference pages if using NS 4.7
//		if (src.indexOf(IUserPreferencesConstants.PREFS) == 0) {	
			script.append("if (SVGGEN_isNN) {SVGGEN_useNetscapePreferencePage();}").append(eol);
			script.append("else {").append(eol);
//		}
		script.append("if (SVGGEN_preferencePage) {SVGGEN_preferencePage = null;}").append(eol);
		script.append("SVGGEN_preferencePage=open('");
		script.append(url + src);
		script.append("','");
		script.append(name);
		script.append("', 'width=");
		script.append(width);
		script.append(",height=");
		script.append(height);
		script.append(",resizable");
		script.append("'); ").append(eol);
		script.append("SVGGEN_preferencePage.opener=window;} ").append(eol);
		script.append("} ").append(eol);
		

		script.append("function SVGGEN_PreferenceOnOut(evt,prefrectId){").append(eol);
		script.append("    var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("    var prefRect = svgDoc.getElementById(prefrectId);").append(eol);
		script.append("    prefRect.setAttribute(\"style\", \"stroke-width:1;stroke:#a0a0a4\");").append(eol);
		script.append("}").append(eol);
		script.append("").append(eol);
		script.append("function SVGGEN_PreferenceOnHover(evt,prefrectId){").append(eol);
		script.append("    var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("    var prefRect = svgDoc.getElementById(prefrectId);").append(eol);
		script.append("    prefRect.setAttribute(\"style\", \"stroke-width:1;stroke:#666666\");").append(eol);
		script.append("}").append(eol);
		
		// might want to move the preference page so it isn't blocking the widget, if possible
              
		return script.toString();
	}		
		
	/** 
	 * Generates a function which launches the NS 4.7 preference page.
	 * Extension classes should not use this for custom preference pages. 	
	 * 
	 * @param url		the URL to the folder which contains "src"
	 * @param src		the content file
	 * @param name		the name of the new window
	 */
	public String generateUseNetscapePreferencePage(String url, String src, String name, String pageWidth, String pageHeight){					
		String height = null;
		String ns_src = IUserPreferencesConstants.NS_PREFS;
		String width = IUserPreferencesConstants.NS_PREFS_WIDTH;
		String graphType = name;
			
		if (name.equals(IGraphicTypeConstants.LINE_CHART)) {
			height = IUserPreferencesConstants.NS_LINE_PREFS_HEIGHT;
		} else if (name.equals(IGraphicTypeConstants.AREA_CHART)) {
			height = IUserPreferencesConstants.NS_AREA_PREFS_HEIGHT;
		} else if (name.equals(IGraphicTypeConstants.STACK_AREA_CHART)) {
			height = IUserPreferencesConstants.NS_AREA_PREFS_HEIGHT;			
		} else if (name.equals(IGraphicTypeConstants.SCATTER_CHART)) {
			height = IUserPreferencesConstants.NS_SCATTER_PREFS_HEIGHT;			
		} else if (name.equals(IGraphicTypeConstants.VBAR_CHART)) {
			height = IUserPreferencesConstants.NS_BAR_PREFS_HEIGHT;
		} else if (name.equals(IGraphicTypeConstants.VSTACKBAR_CHART)) {
			height = IUserPreferencesConstants.NS_STACKBAR_PREFS_HEIGHT;
		} else if (name.equals(IGraphicTypeConstants.VBAR_CHART3D)) {
			height = IUserPreferencesConstants.NS_BAR_PREFS_HEIGHT3D;
		} else if (name.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D)) {
			height = IUserPreferencesConstants.NS_STACKBAR_PREFS_HEIGHT3D;
		} else if (name.equals(IGraphicTypeConstants.PIE_CHART)) {
			height = IUserPreferencesConstants.NS_PIE_PREFS_HEIGHT;
		} else if (name.equals(IGraphicTypeConstants.PIE_CHART3D)) {
			height = IUserPreferencesConstants.NS_PIE_PREFS_HEIGHT3D;
		} else if (name.equals(IGraphicTypeConstants.METER)) {
			height = IUserPreferencesConstants.NS_METER_PREFS_HEIGHT;
		} else {
			width = pageWidth;
			height = pageHeight;
		}
		
		if (name.equals(IGraphicTypeConstants.VBAR_CHART3D) || name.equals(IGraphicTypeConstants.HBAR_CHART3D) || name.equals(IGraphicTypeConstants.VBAR_CHART) || name.equals(IGraphicTypeConstants.HBAR_CHART)) { 
			graphType = "bar";
		}
		if (name.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D) || name.equals(IGraphicTypeConstants.HSTACKBAR_CHART3D) || name.equals(IGraphicTypeConstants.VSTACKBAR_CHART) || name.equals(IGraphicTypeConstants.HSTACKBAR_CHART)) {
			graphType = "stack";
		}
		if (name.equals(IGraphicTypeConstants.PIE_CHART) || name.equals(IGraphicTypeConstants.PIE_CHART3D) ) {
			graphType = "pie";
		}
		if (name.equals(IGraphicTypeConstants.STACK_AREA_CHART)  ) {
			graphType = "area";
		}
		
		script = new StringBuffer("function SVGGEN_useNetscapePreferencePage(){");
		script.append("if (SVGGEN_preferencePage) {SVGGEN_preferencePage = null;}").append(eol);
		script.append("SVGGEN_preferencePage=open('");
		script.append(url + ns_src);
		script.append("','");
		script.append(name);
		script.append("','");
		script.append("width=");
		script.append(width);
		script.append(",");
		script.append("height=");
		script.append(height);
		script.append(",top=0,left=0,screenx=0,screeny=0,toolbar=no,scrollbar=no'); ").append(eol);
		script.append("SVGGEN_preferencePage.prefType='");
		script.append(graphType);
		script.append("'; SVGGEN_preferencePage.opener=window;");
		script.append("}").append(eol);
		
		return script.toString();
	}			
			
		
	/** 
	 * Generates a function which returns the set of available palettes. 	
	 */
	public String generateGetPalettesFunction(){
		script = new StringBuffer("function SVGGEN_getPalettes(){").append(eol);
		script.append("return SVGGEN_palettes;").append(eol);
		script.append("} ").append(eol);
		
		return script.toString();
	}			
		
	/** 
	 * Generates a function which returns an array of the current preference values			
	 */
	public String generateGetCurrentValuesFunction(){
		script = new StringBuffer("var SVGGEN_current = new Array();").append(eol);
		// assemble the values
		script.append("function SVGGEN_getCurrentValues() {").append(eol);
		script.append("for (var i = 0; i < 6; i++) {SVGGEN_current[i] = SVGGEN_currentValues[i];}").append(eol);
		// find the first colour of the current palette
		script.append("for (var i = 0; i < SVGGEN_palettes.length; i++) {").append(eol);
		script.append("if (SVGGEN_palettes[i][SVGGEN_palettes[i].length - 1] == SVGGEN_current[0]) {").append(eol);
		script.append(" SVGGEN_current[6] = SVGGEN_palettes[i][0];}}").append(eol);
		script.append("return SVGGEN_current;").append(eol);
		script.append("} ").append(eol);
		
		return script.toString();
	}
		
	/** 
	 * Generates an event handler which toggles the visibility attribute of the group/element 
	 * with the specified "id". 
	 * 
	 * @param type the graphic type
	 */
	public String generateToggleVisibilityFunction(int sets, String type, boolean showShapes){
		script = new StringBuffer("var SVGGEN_values=1, SVGGEN_percents=1;var SVGGEN_textboxState = new Array();");
		script.append("for (var i = 0; i < ").append(sets).append("; i++) {SVGGEN_textboxState[i] = 0;}").append(eol);
		
		if (type.equals(IGraphicTypeConstants.PIE_CHART) || type.equals(IGraphicTypeConstants.PIE_CHART3D)) {
			// set all object visibility to the specified value
//			script.append("var SVGGEN_noValues = true;").append(eol);
//			script.append("var SVGGEN_noPercent = true;").append(eol);
//			script.append("function SVGGEN_toggleDataPoint(id, value) {").append(eol);
//			script.append("  if((SVGGEN_noValues == true) && (SVGGEN_noPercent == true)){").append(eol);
//			script.append("  	SVGGEN_setVisibility('tickline'+ id, value);").append(eol);
//			script.append("	 	SVGGEN_setVisibility('bLabel' + id, value);").append(eol);	
//			script.append("  	if (value == 'hidden') {").append(eol);
//			script.append("			document.getElementById('bLabel'+id).removeAttribute(\"visibility\");").append(eol);
//			script.append("			document.getElementById('tickline'+id).removeAttribute(\"visibility\");").append(eol);
//			script.append("		}").append(eol);
//			script.append("	}").append(eol);
//			script.append("}").append(eol);	
			
//			script.append("function SVGGEN_toggleVisibility2(id) {").append(eol);
//			script.append("  SVGGEN_setVisibility('tickline', 'hidden');").append(eol);
//			script.append("  if (SVGGEN_isVisible('bothValues')) {").append(eol);
//			script.append("    SVGGEN_setVisibility('bothValues', 'hidden');").append(eol);
//			script.append("  } else if (SVGGEN_isVisible('percentValues')) {").append(eol);
//			script.append("	   SVGGEN_setVisibility('percentValues', 'hidden');").append(eol);
//			script.append("  } else if (SVGGEN_isVisible('exactValues')) {").append(eol);
//			script.append("	   SVGGEN_setVisibility('exactValues', 'hidden');").append(eol);
//			script.append("  } else {").append(eol);
//			script.append("    SVGGEN_setVisibility('tickline', 'visible');").append(eol);
//			script.append("    if ((SVGGEN_values == 1 && SVGGEN_percents == 1) || (SVGGEN_values == 0 && SVGGEN_percents == 0)) { ").append(eol);
//			script.append("      SVGGEN_setVisibility('bothValues', 'visible');").append(eol);
//			script.append("    } else if (SVGGEN_values == 1) {").append(eol);
//			script.append("	     SVGGEN_setVisibility('exactValues', 'visible');").append(eol);
//			script.append("    } else if (SVGGEN_percents == 1) {").append(eol);
//			script.append("	     SVGGEN_setVisibility('percentValues', 'visible');").append(eol);
//			script.append("    }").append(eol);
//			script.append("  }").append(eol);
//			script.append("}").append(eol);
		}
		else if ((type.equals(IGraphicTypeConstants.LINE_CHART)) || (type.equals(IGraphicTypeConstants.AREA_CHART)) || (type.equals(IGraphicTypeConstants.SCATTER_CHART))  || (type.equals(IGraphicTypeConstants.STACK_AREA_CHART)) ) {		
			if (showShapes)
				script.append("var SVGGEN_noShapes = false;").append(eol);
			else
				script.append("var SVGGEN_noShapes = true;").append(eol);
//			script.append("var SVGGEN_noValues = true;").append(eol);			
//			script.append("function SVGGEN_changeAllTextBoxes(state) {").append(eol);
//			script.append("  for (var i = 0; i < ").append(sets).append("; i++) {");
//			script.append("    var boxId = \"textbox\" + i;").append(eol);
//			script.append("    if (document.getElementById(boxId) != null) {").append(eol);
//			script.append("      if (SVGGEN_isVisible('dataColour'+i)){").append(eol);
//			//
//			script.append("        SVGGEN_setVisibility(boxId, state);").append(eol);
//			script.append("        var number = 0;").append(eol);
//			script.append("        while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
//			script.append("          SVGGEN_setVisibility('textboxText' + i + number, state);").append(eol);
//			script.append("          SVGGEN_setVisibility('textboxRect' + i + number, state);").append(eol);
//			script.append("          number++;").append(eol);
//			script.append("        }").append(eol);
//			//
//			script.append("      }").append(eol);
//			script.append("      if (state == 'hidden') {SVGGEN_textboxState[i] = 0;}").append(eol);
//			script.append("      else if (state == 'visible') {SVGGEN_textboxState[i] = 1;}").append(eol);
//			script.append("    }").append(eol);
//			script.append("  }").append(eol);
//			script.append("}").append(eol);
			
//			script.append("function SVGGEN_toggleDataPoint(id, value) {").append(eol);
//			script.append(" if(SVGGEN_noValues){").append(eol);
//			script.append("	SVGGEN_setVisibility('textboxText' + id.substring(9,id.length), value);").append(eol);	
//			script.append("	SVGGEN_setVisibility('textboxRect' + id.substring(9,id.length), value);").append(eol);
//			
//			script.append("		if(value == 'hidden'){").append(eol);
//			script.append("			document.getElementById('textboxText' + id.substring(9,id.length)).removeAttribute(\"visibility\");").append(eol);
//			script.append("			document.getElementById('textboxRect' + id.substring(9,id.length)).removeAttribute(\"visibility\");").append(eol);			
//			script.append("		}").append(eol);
//						
//				
//			script.append("	}").append(eol);	
//			script.append("}").append(eol);	
							
//			script.append("function SVGGEN_toggleVisibility2(id) {").append(eol);
//			script.append("  if (id.substring(0,10) == 'dataColour') {").append(eol);
//			script.append("	   var lineId = id.substring(10,id.length);").append(eol);
//			script.append("    if (SVGGEN_isVisible(\"dataColour\" + lineId) ) {").append(eol);
//			script.append(" 	 SVGGEN_setVisibility(\"dataColour\" + lineId, 'hidden');").append(eol);
//			script.append("		 SVGGEN_setVisibility(\"textbox\" + lineId, 'hidden');").append(eol);
//			// start
//			script.append("      var number = 0;").append(eol);
//			script.append("      while (svgDocument.getElementById('textboxText' + lineId + number) != null) {").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxText' + lineId + number, 'hidden');").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxRect' + lineId + number, 'hidden');").append(eol);
//			script.append("        number++;").append(eol);
//			script.append("      }").append(eol);
//			// end
//			script.append("	   } else if (!SVGGEN_isVisible(\"dataColour\" + lineId)) {").append(eol);
//			script.append("	     SVGGEN_setVisibility(\"dataColour\" + lineId, 'visible');").append(eol);
//			script.append("		 var state = SVGGEN_textboxState[lineId] == 0 ? 'hidden' : 'visible';	").append(eol);
//			script.append("		 SVGGEN_setVisibility(\"textbox\" + lineId, state);").append(eol);
//			//start
//			script.append("      var number = 0;").append(eol);
//			script.append("      while (svgDocument.getElementById('textboxText' + lineId + number) != null) {").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxText' + lineId + number, state);").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxRect' + lineId + number, state);").append(eol);
//			script.append("        number++;").append(eol);
//			script.append("      }").append(eol);
//			// end
//			
//			script.append("	   }").append(eol);
//			// turn on/off the shapes on a line
//			if (type.equals(IGraphicTypeConstants.AREA_CHART)) {
//				script.append("    var group = document.getElementById('dataColourS'+lineId);").append(eol);
//			}else{
//				script.append("    var group = document.getElementById(id);").append(eol);
//			}
//			script.append("    if (group != null) {").append(eol);
//			script.append("      var useElementGroup = group.getElementsByTagName('use');").append(eol);
//			script.append("      if (useElementGroup != null) {").append(eol);
//			script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
//			if (type.equals(IGraphicTypeConstants.SCATTER_CHART)) {
//				script.append("          useElementGroup.item(j).setAttribute('visibility', (SVGGEN_isVisible(id) ? 'visible':'hidden') );").append(eol);
//			}else{
//				script.append("          useElementGroup.item(j).setAttribute('visibility', (SVGGEN_isVisible(id) && SVGGEN_noShapes == false ? 'visible':'hidden') );").append(eol);
//			}
//			script.append("        }").append(eol);
//			script.append("      }").append(eol);
//			script.append("    }").append(eol);
//			script.append("  } else if (id.substring(0,7) == 'textbox') {").append(eol);
//			script.append("    if (SVGGEN_isVisible(\"dataColour\" + id.substring(7,id.length))) {").append(eol);
//			script.append("      SVGGEN_changeAllTextBoxes(SVGGEN_isVisible(id) ? 'hidden':'visible');").append(eol);
//			script.append("    }").append(eol);
//			script.append("  }").append(eol);
//			script.append("}").append(eol);
			if (type.equals(IGraphicTypeConstants.SCATTER_CHART)) {
				script.append("function SVGGEN_toggleShadow(id, state) {").append(eol);
				script.append("    var group = document.getElementById(id);").append(eol);
				script.append("    if (group != null) {").append(eol);
				script.append("      var useElementGroup = group.getElementsByTagName('use');").append(eol);
				script.append("      if (useElementGroup != null) {").append(eol);
				script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
				script.append("         if(useElementGroup.item(j).getAttribute('xlink:href').substring(1,8) == 'flyover'){").append(eol);
				script.append("				useElementGroup.item(j).setAttribute('visibility', state);").append(eol);
				script.append("	        }else{").append(eol);
				script.append("		        if(useElementGroup.item(j).getAttribute('visibility') == 'hidden'){").append(eol);
				script.append("		        	state = 'hidden';").append(eol);
				script.append("        		}").append(eol);
				script.append("    		}").append(eol);				
				script.append("        }").append(eol);
				script.append("      }").append(eol);	
				script.append("    }").append(eol);					
				script.append("}").append(eol);
			}
		}
		else if (type.equals(IGraphicTypeConstants.VSTACKBAR_CHART)) {	
//			script.append("var SVGGEN_noValues = true;").append(eol);				
//			script.append("function SVGGEN_toggleVisibility2(id) {").append(eol);
//			script.append("  SVGGEN_setVisibility('exactValues', SVGGEN_isVisible('exactValues')?'hidden':'visible');").append(eol);
//			script.append("  for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);  // turn on/off all boxes
//			script.append("    var textBoxSet = document.getElementById(\"textbox\" + i);").append(eol);
//			script.append("    var state = SVGGEN_isVisible('exactValues')?'visible':'hidden';").append(eol);
//			script.append("    if (textBoxSet != null) { ").append(eol);
//			script.append("      textBoxSet.setAttribute('visibility', SVGGEN_isVisible('exactValues')?'visible':'hidden');").append(eol);
//			script.append("      var number = 0;").append(eol);
//			script.append("      while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxText' + i + number, state);").append(eol);
//			script.append("        SVGGEN_setVisibility('textboxRect' + i + number, state);").append(eol);
//			script.append("        number++;").append(eol);
//			script.append("      }").append(eol);
//			script.append("	   }").append(eol);
//			script.append("	 }").append(eol);
//			script.append("}").append(eol);
			
//			script.append("function SVGGEN_toggleDataPoint(id, value) {").append(eol);
//			script.append(" if(SVGGEN_noValues){").append(eol);	
//			script.append("	SVGGEN_setVisibility('textboxText' + id.substring(9,id.length), value);").append(eol);	
//			script.append("	SVGGEN_setVisibility('textboxRect' + id.substring(9,id.length), value);").append(eol);	
//			script.append("		if(value == 'hidden'){").append(eol);
//			script.append("			document.getElementById('textboxText' + id.substring(9,id.length)).removeAttribute(\"visibility\");").append(eol);
//			script.append("			document.getElementById('textboxRect' + id.substring(9,id.length)).removeAttribute(\"visibility\");").append(eol);			
//			script.append("		}").append(eol);
//			script.append("	}").append(eol);	
//			script.append("}").append(eol);	
			
		}
		else {	// functions for Group and bar chart
//			script.append("var SVGGEN_noValues = true;").append(eol);
//			script.append("function SVGGEN_toggleDataPoint(id, value) {").append(eol);
//			script.append("if(SVGGEN_noValues){").append(eol);
//		 
//			script.append("		SVGGEN_setVisibility(id,value);").append(eol);
//			script.append("		if(value == 'hidden'){").append(eol);
//			script.append("			document.getElementById(id).removeAttribute(\"visibility\");").append(eol);
//			script.append("		}").append(eol);
//			script.append("	}").append(eol);
//			script.append("}").append(eol);

//			script.append("function SVGGEN_toggleVisibility2(id) {").append(eol);
//			script.append(" if(SVGGEN_isVisible(id)){").append(eol);
//			script.append("		SVGGEN_setVisibility(id,'hidden');").append(eol);
//			script.append("		if(id.substring(0, 4) == 'text'){").append(eol);
//			script.append("			document.getElementById(id).removeAttribute(\"visibility\");").append(eol);
//			script.append("		}").append(eol);
//			script.append("	}").append(eol);														
//			script.append(" else{SVGGEN_setVisibility(id,'visible');}").append(eol);
//			script.append("}").append(eol);
		}		
		
		// check if an object is visible, also check parents of the object
		script.append("function SVGGEN_isVisible(id) {").append(eol);
		script.append("  var obj = document.getElementById(id);").append(eol);
		script.append("  if (obj.getAttribute('visibility') == 'hidden') return false;").append(eol);
		script.append("  obj = obj.parentNode;").append(eol);
		script.append("  while (obj != document) {").append(eol);
		script.append("    if (obj.getAttribute('visibility') == 'hidden') return false;").append(eol);
		script.append("      obj = obj.parentNode;").append(eol);
		script.append("  }").append(eol);
		script.append("  return true;").append(eol);
		script.append("}").append(eol);
		
		// set a particular object visibility
		script.append("function SVGGEN_setVisibility(id, value) {").append(eol);
		script.append(" document.getElementById(id).setAttribute(\"visibility\",value);").append(eol);
		script.append("} ").append(eol);
			
		return script.toString();
	}
		
	/**
	 * Generates helper functions used for XY-style charts.
	 */	
	public String generateXYChartHelperFunctions() {
		script = new StringBuffer("function SVGGEN_resizeAndRepositionTextBox(textBox, newX, newY, newWidth, newHeight) {");
		script.append(" textBox.setAttribute('x', newX);").append(eol);
		script.append(" textBox.setAttribute('y', newY);").append(eol);
		script.append("	textBox.setAttribute('width', newWidth);").append(eol);
		script.append("	textBox.setAttribute('height', newHeight);").append(eol);
		script.append("} ").append(eol);
		
		script.append("function resizeTextBox(textBox, newWidth, newHeight) {").append(eol);
		script.append("	textBox.setAttribute('width', newWidth);").append(eol);
		script.append("	textBox.setAttribute('height', newHeight);").append(eol);
		script.append("} ").append(eol);
		
		script.append("function repositionText(text, newX, newY) {").append(eol);
		script.append("	text.setAttribute('x', newX);").append(eol);
		script.append("	text.setAttribute('y', newY);").append(eol);
		script.append("} ").append(eol);
				
		return script.toString();
	}
					
	/**
	 * Generates helper functions used for pie charts.
	 */				
	public String generatePieChartHelperFunctions() {
		script = new StringBuffer("");
		script.append("function SVGGEN_changeTextColour(bothElement, percentTextElement, exactTextElement, palette) {").append(eol);
		script.append("  for (var i = 0, j = palette.length - 1; i < percentTextElement.length; i++, j = palette.length - 1) {").append(eol);
		script.append("    if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
		script.append("    bothElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
		script.append("	   percentTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
		script.append("	   exactTextElement.item(i).setAttribute('style', \"fill:\" + palette[j]);").append(eol);
		script.append("  }").append(eol);
		script.append("} ").append(eol);
			
		return script.toString();
	}	
	
	/** 
	 * Generates a function which resets the graphic user preference styles
	 * to their former values. 
	 */
	public String generateResetStylesFunction(){		
		script = new StringBuffer("function SVGGEN_resetStyles(){");
		script.append("SVGGEN_updateStyles(SVGGEN_currentValues, true);").append(eol);
		script.append("} ").append(eol);
		
		return script.toString();
	}	
	
	/** 
	 * Generates a function which updates the graphic legend with user preference styles.
	 *  	
	 * @param sets 		the number of data sets displayed by the graphic legend
	 * @param type 		the graphic type
	 */
	public String generateUpdateLegendStylesFunction(int sets, String type){		
		script = new StringBuffer();
		script.append("function SVGGEN_updateLegendStyles(newStyles, preview) {").append(eol);

		script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
		// legend title
		script.append("var group = document.getElementById('SVGGEN_legendTitle');").append(eol);
		script.append("if (group != null){").append(eol);
		script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize + 2) + \"pt; \" + newStyles[2]);}").append(eol);
		// legend data
		script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
		script.append("var group = document.getElementById('SVGGEN_legendData' + i);").append(eol);
		script.append("if (group != null){").append(eol);
		script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
		script.append("}").append(eol);
		
		script.append("var group = document.getElementById(\"legendFlyoverData\");").append(eol);
		script.append("if (group != null){").append(eol);
		script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
		
		
		// only line chart has shapes		
		if ((type.equals(IGraphicTypeConstants.LINE_CHART)) || (type.equals(IGraphicTypeConstants.AREA_CHART)) || (type.equals(IGraphicTypeConstants.SCATTER_CHART)) || (type.equals(IGraphicTypeConstants.STACK_AREA_CHART)) ) {		
			script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
			script.append("  var squareshape = document.getElementById('SVGGEN_legendsquareshapeWithoutLine' + i);").append(eol);
			script.append("  var shape = document.getElementById('SVGGEN_legendShape' + i);").append(eol);
			script.append("  shape.setAttribute('visibility', (newStyles[3] == '0' ? 'hidden' : 'visible'));").append(eol);
			script.append("  squareshape.setAttribute('visibility', (newStyles[3] == '0' ? 'visible' : 'hidden'));").append(eol);
			script.append("}").append(eol);
		}
		script.append("}").append(eol);
		return script.toString();
		
	}	
	
	/** 
	 * Generates a function which updates the graphic with user preference styles.
	 *  	
	 * @param sets 		the number of data sets displayed by the graphic
	 * @param type 		the graphic type
	 */
	public String generateUpdateStylesFunction(int sets, String cookieName, String type, boolean hasLegend, String updatedUserPrefsVarName, int numOfCategories, boolean showUserPref){		
		script = new StringBuffer();
		script.append("function SVGGEN_getTextElement(myGroup) { return myGroup.getElementsByTagName('text'); }").append(eol);
		
		// newStyles is an array and looks like: {palette name, font size, font text, shape, showValues, showPercents} 
		script.append("function SVGGEN_updateStyles(newStyles, preview) {").append(eol);

		if (showUserPref) {
			
		script.append("if (newStyles == null || newStyles.length < 6) {return;}").append(eol);
		// get the chosen colour palette
		script.append("var paletteName=newStyles[0];").append(eol);
//		script.append("SVGGEN_noValues = newStyles[4] == '0' ? true : false;").append(eol);
//		if (type.equals(IGraphicTypeConstants.PIE_CHART)){
//			script.append("SVGGEN_noPercent = newStyles[5] == '0' ? true : false;").append(eol);
//		}

		// use the first one if we get messed up here
		script.append("var palette= SVGGEN_palettes[0];").append(eol);
		script.append("for (var i = 0; i < SVGGEN_palettes.length; i++) {").append(eol);
		script.append("if (SVGGEN_palettes[i][SVGGEN_palettes[i].length-1] == paletteName) {").append(eol);
		script.append(" palette = SVGGEN_palettes[i];}}").append(eol);
		// update the color groups with the new palette, wrapping if not enough colours		
		script.append("for (var i=0, j=palette.length-1; i<" + sets + ";i++, j=palette.length-1) {").append(eol);
		script.append("  if (((i+1) % j) == 0) {j = palette.length - 2;} else {j=((i+1)%j)-1;}").append(eol);
		
		
		if (type.equals(IGraphicTypeConstants.HSTACKBAR_CHART3D) || type.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D))  {				
			script.append("for (var y=0; y<" + numOfCategories + ";y++) {").append(eol);
			script.append("var group = document.getElementById(y+'SVGGEN_dataColour' + i);");
	 	 }
		else{
			script.append("  var group = document.getElementById('SVGGEN_dataColour' + i);").append(eol);
		}
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute('style', 'stroke:' + palette[j] + '; fill:' + palette[j]);").append(eol);
		script.append("    var useElementGroup = group.getElementsByTagName('use');").append(eol);
		script.append("    if (useElementGroup != null) {").append(eol);
		script.append("      for (var k = 0; k < useElementGroup.length; k++) {").append(eol);
		script.append("        useElementGroup.item(k).setAttribute('style', 'stroke:' + palette[j] + '; fill:' + palette[j]);").append(eol);
		script.append("      }").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		if (type.equals(IGraphicTypeConstants.HSTACKBAR_CHART3D) || type.equals(IGraphicTypeConstants.VSTACKBAR_CHART3D))  {				
			script.append("  }").append(eol);
	 	}
		
		if (type.equals(IGraphicTypeConstants.AREA_CHART) || type.equals(IGraphicTypeConstants.STACK_AREA_CHART))  {				
			script.append("  var group = document.getElementById('SVGGEN_area' + i);").append(eol);
			script.append("  if (group != null){").append(eol);
			script.append("    group.setAttribute(\"style\",\"stroke:\" + palette[j] + \"; fill:\" + palette[j]);}").append(eol);
			
		}
		script.append("  group = document.getElementById('SVGGEN_legendsquareshapeWithoutLine' + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
		
		script.append("  group = document.getElementById('SVGGEN_legendShape' + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
		
//		if ((type.equals(IGraphicTypeConstants.LINE_CHART)) || (type.equals(IGraphicTypeConstants.AREA_CHART)) || (type.equals(IGraphicTypeConstants.SCATTER_CHART))) {		
//			script.append("  group = document.getElementById('SVGGEN_legendShape' + i);").append(eol);
//			script.append("  if (group != null){").append(eol);
//			script.append("    group.setAttribute(\"style\",\"fill:\" + palette[j]);}").append(eol);
//		}
		
		script.append("  group = document.getElementById(\"pieColour\" + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
		script.append("  group = document.getElementById(\"percentValues\" + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\", \"stroke:\" + \"black\" + \"; fill: \" + palette[j]);}").append(eol);
		script.append("  group = document.getElementById(\"bothValues\" + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\", \"stroke:\" + palette[j] + \"; fill: \" + palette[j]);}").append(eol);
		script.append("  group = document.getElementById(\"line\" + i);").append(eol);
		script.append("  if (group != null){").append(eol);
		script.append("    group.setAttribute(\"style\", \"fill: \" + palette[j]);}").append(eol);
		script.append("}").append(eol);
				
		}
		
		// update the font group with the new font attributes, e.g., "size:11pt; weight:normal;
		// family:Arial, sans-serif; stroke:#000000; "
		
		script.append("var fontSize=parseInt(newStyles[1]);").append(eol);
		// chart title
		script.append("var group = document.getElementById('SVGGEN_graphTitle');").append(eol);
		script.append("var graphTitleStyle = 'font-weight:bold; ' + newStyles[2].substring(newStyles[2].indexOf('font-style'), newStyles[2].length);").append(eol);
		script.append("if (group != null){").append(eol);
		script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+3) + \"pt; \" + graphTitleStyle);}").append(eol);
		// timestamp
		script.append("var group = document.getElementById('SVGGEN_timeStamp');").append(eol);
		script.append("if (group != null){").append(eol);
		script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");").append(eol);
		script.append(" group.setAttribute(\"y\", fontSize + 5);}").append(eol);
		
		// Update fontSize and style		
		script.append("SVGGEN_updateFontStyleAll(document, fontSize, newStyles[2]);").append(eol);
		
		if (!type.equals(IGraphicTypeConstants.METER)) {
			// legend specific
			if (hasLegend) {
				script.append("SVGGEN_updateLegendStyles(newStyles, preview);").append(eol);
			}
			
			if (!type.equals(IGraphicTypeConstants.PIE_CHART) && !type.equals(IGraphicTypeConstants.PIE_CHART3D)) {
				// x-axis data
				script.append("var group = document.getElementById(\"dataValues0\");").append(eol);
				script.append("if (group != null){").append(eol);
				script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
				// y-axis data
				script.append("var group = document.getElementById(\"dataValues1\");").append(eol);
				script.append("if (group != null){").append(eol);
				script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \" + newStyles[2]);}").append(eol);
					
				// resize textboxes and text inside textboxes
				script.append("var datasetGroup = document.getElementById('SVGGEN_datasetGroup');").append(eol);
				script.append("if (datasetGroup != null) {").append(eol);
				script.append("  if (newStyles[4] == 0) {").append(eol);
				script.append("    SVGGEN_toggleVisibilityDatavalue2(datasetGroup, 'hidden');").append(eol);
				script.append("  } else {").append(eol);
				script.append("    SVGGEN_toggleVisibilityDatavalue2(datasetGroup, 'visible');").append(eol);
				script.append("  }").append(eol);
				script.append("}").append(eol);
//				script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
//				script.append("var number = 0; var rectElement = null; var textElement = null;").append(eol);
//				script.append("while ((rectElement = document.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
//				script.append("  textElement = document.getElementById(\"textboxText\" + i + number);").append(eol);
//				//
//				script.append("    if (textElement != null) {").append(eol);
//				script.append("      textElement.setAttribute('style', 'font-size:' + fontSize + 'pt');").append(eol);
//				script.append("      textElement.setAttribute('visibility', 'visible');").append(eol);
//				script.append("      rectElement.setAttribute('visibility', 'visible');").append(eol);
//				script.append("      var bbox = textElement.getBBox(); ").append(eol);
//				script.append("      var originalBoxY = rectElement.getAttribute('y');").append(eol);
//				script.append("      var originalBoxX = rectElement.getAttribute('x');");
//				script.append("      if ( (parseFloat(originalBoxY) + bbox.height + 6) > ").append(gridYOffset + yAxisLength).append(") {");
//				script.append("        rectElement.setAttribute('y', (originalBoxY - bbox.height - 6));").append(eol);
//				script.append("      }").append(eol);
//				script.append("      rectElement.setAttribute('width', bbox.width + 6);").append(eol);
//				script.append("      rectElement.setAttribute('height', bbox.height + 6);").append(eol);
//				script.append("      textElement.setAttribute('x', parseFloat(rectElement.getAttribute('x')) + (bbox.width + 6) / 2.0);").append(eol);
//				script.append("      textElement.setAttribute('y', parseFloat(rectElement.getAttribute('y')) + bbox.height + 3);").append(eol);
//				script.append("      if (newStyles[4] == '0' || !SVGGEN_isVisible('dataColour' + i)) {").append(eol);
//				script.append("        textElement.setAttribute('visibility', 'hidden');").append(eol);
//				script.append("        rectElement.setAttribute('visibility', 'hidden');").append(eol);
//				script.append("      }").append(eol);
//				script.append("    }").append(eol);
//				script.append("    ++number;").append(eol);
//				//			
//				script.append("  }").append(eol);  // end: for 
//				script.append("}").append(eol);  // end for 
			}			
			else {	
				// percentages
				script.append("var group = document.getElementById(\"percentValues\");").append(eol);
				script.append("if (group != null){").append(eol);
				script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
				
				// both values 
				script.append("var bothGroup = document.getElementById(\"bothValues\");").append(eol);
				script.append("if (bothGroup != null){").append(eol);
				script.append(" bothGroup.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
			}
			
			// x-axis label
			script.append("var group = document.getElementById('SVGGEN_labelsValues0');").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"text-anchor:middle; font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
			// y-axis label
			script.append("var group = document.getElementById('SVGGEN_labelsValues1');").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
			// secondary y-axis label
			script.append("var group = document.getElementById('SVGGEN_labelsValues2');").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize+2) + \"pt; \" + newStyles[2]);}").append(eol);
			// exact values
			script.append("var group = document.getElementById(\"exactValues\");").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + fontSize + \"pt; \");}").append(eol);
			
		}		
		else {
			script.append("var rateDefStyle = newStyles[2].substring(newStyles[2].indexOf('font-style'), newStyles[2].length);").append(eol);
			// minmaxRate
			script.append("var group = document.getElementById(\"minmaxRate\");").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \" + rateDefStyle);}").append(eol);
			// rateDefinition	
			script.append("var group = document.getElementById(\"rateDefinition\");").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \" + rateDefStyle);}").append(eol);
			// critDiv	
			script.append("var group = document.getElementById(\"critDiv\");").append(eol);
			script.append("if (group != null){").append(eol);
			script.append(" group.setAttribute(\"style\",\"font-size:\" + (fontSize) + \"pt; \");}").append(eol);
			// meter label
			script.append("var group = document.getElementById(\"meterLabel\");").append(eol);
			script.append("if (group != null){ ").append(eol);
			script.append("   var tmpText = group.getElementsByTagName('text');").append(eol);
			script.append("   for (var i = 0; i < tmpText.length; i++) {").append(eol);
			script.append("     tmpText.item(i).setAttribute('style', 'font-size: ' + (fontSize) + 'pt; ');").append(eol);
			script.append("   }").append(eol);
			script.append("}").append(eol);
		}	
		
		// Show shapes
		if ((type.equals(IGraphicTypeConstants.LINE_CHART)) || (type.equals(IGraphicTypeConstants.AREA_CHART)) || (type.equals(IGraphicTypeConstants.SCATTER_CHART)) || (type.equals(IGraphicTypeConstants.STACK_AREA_CHART)) )  {
			script.append("for (var i = 0; i < " + sets + "; i++){").append(eol);
//			if(type.equals(IGraphicTypeConstants.AREA_CHART)){
//				script.append("  var group = document.getElementById('dataColourS' + i);").append(eol);
//			}else{
				script.append("  var group = document.getElementById('SVGGEN_dataColour' + i);").append(eol);
//			}
			script.append("  if (group != null) {").append(eol);
			script.append("    var useElementGroup = group.getElementsByTagName('use');").append(eol);
			script.append("    if (useElementGroup != null) {").append(eol);
			script.append("      for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
			if (type.equals(IGraphicTypeConstants.SCATTER_CHART)) {
				script.append("       if(useElementGroup.item(j).getAttribute('id') == null || useElementGroup.item(j).getAttribute('id').substring(0,18) != 'SVGGEN_shadowShape'){").append(eol);
				script.append("	        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && SVGGEN_isVisible('SVGGEN_dataColour'+i) ? 'visible' : 'hidden') );").append(eol);
				script.append("	      }").append(eol);
			}else{
				script.append("        useElementGroup.item(j).setAttribute('visibility', (newStyles[3] == '1' && SVGGEN_isVisible('SVGGEN_dataColour'+i) ? 'visible' : 'hidden') );").append(eol);
			}
			script.append("      }").append(eol);
			script.append("    }").append(eol);
			script.append("  }").append(eol);
			script.append("  SVGGEN_noShapes = newStyles[3] == '0' ? true : false;").append(eol);
//			script.append("  SVGGEN_noValues = newStyles[4] == '0' ? true : false;").append(eol);			
			script.append("}").append(eol);
		}
		
		// show/hide values 
		if (type.equals(IGraphicTypeConstants.PIE_CHART) || type.equals(IGraphicTypeConstants.PIE_CHART3D)) {	
			script.append("var bothGroup=document.getElementById('bothValues');var perGroup=document.getElementById('percentValues');var eGroup=document.getElementById('exactValues');").append(eol);
			script.append("if (bothGroup != null)").append(eol);
			script.append("  SVGGEN_changeTextColour(SVGGEN_getTextElement(bothGroup), SVGGEN_getTextElement(perGroup), SVGGEN_getTextElement(eGroup), palette);").append(eol);
			script.append("SVGGEN_toggleVisibilityDatavaluePie2(document, 'hidden');").append(eol);
			script.append("SVGGEN_values = (newStyles[4] == '0' ? 0 : 1);").append(eol);
			script.append("SVGGEN_percents = (newStyles[5] == '0' ? 0 : 1);").append(eol);
			script.append("if (SVGGEN_values == 1 || SVGGEN_percents == 1)").append(eol);
			script.append("  SVGGEN_toggleVisibilityDatavaluePie2(document, 'visible');").append(eol);
//			script.append("SVGGEN_setVisibility('tickline', (SVGGEN_values==0 && SVGGEN_percents==0 ? 'hidden':'visible'));").append(eol);
//			script.append("eGroup.setAttribute('visibility', (SVGGEN_values==1 && SVGGEN_percents==0 ? 'visible':'hidden'));").append(eol);
//			script.append("perGroup.setAttribute('visibility', (SVGGEN_values==0 && SVGGEN_percents==1 ? 'visible':'hidden'));").append(eol);
//			script.append("bothGroup.setAttribute('visibility', (SVGGEN_values==1 && SVGGEN_percents==1 ? 'visible':'hidden'));").append(eol);
		}
		else if ((type.equals(IGraphicTypeConstants.LINE_CHART)) || (type.equals(IGraphicTypeConstants.AREA_CHART)) || (type.equals(IGraphicTypeConstants.SCATTER_CHART))  || (type.equals(IGraphicTypeConstants.STACK_AREA_CHART))) {										
			script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
			script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
			script.append("    SVGGEN_textboxState[i] = parseInt(newStyles[4]);").append(eol);
			script.append("    if (SVGGEN_isVisible('dataColour'+i)) {").append(eol);
			script.append("      SVGGEN_setVisibility(\"textbox\"+i, newStyles[4]=='0' ? 'hidden':'visible');").append(eol);
			script.append("      var number = 0; ").append(eol);
			script.append("      while ((hoverBoxElement = svgDocument.getElementById(\"textboxRect\" + i + number)) != null) {").append(eol);
			script.append("        var hoverBoxText = svgDocument.getElementById('textboxText' + i + number);").append(eol);
			script.append("        if (hoverBoxText != null) {").append(eol);
			script.append("          hoverBoxText.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
			script.append("          hoverBoxElement.setAttribute('visibility', (parseInt(newStyles[4]) == 0 ? 'hidden':'visible') );").append(eol);
			script.append("        }").append(eol);
			script.append("        number++;").append(eol);
			script.append("      }").append(eol);
			script.append("    }").append(eol);
			script.append("	 }").append(eol);
			script.append("}").append(eol);
		}
		else if (type.equals(IGraphicTypeConstants.VSTACKBAR_CHART)) {		
			script.append("var showAllState = newStyles[4]=='0' ? 'hidden':'visible';").append(eol);
			script.append("var eGroup = document.getElementById('exactValues');").append(eol);
			script.append("if (eGroup!=null) {eGroup.setAttribute('visibility',showAllState);}").append(eol);
			script.append("for (var i = 0; i < ").append(sets).append("; i++) {").append(eol);
			script.append("  if (document.getElementById(\"textbox\" + i) != null) {").append(eol);
			script.append("    SVGGEN_setVisibility(\"textbox\"+i, showAllState);").append(eol);
			script.append("      var number = 0;").append(eol);
			script.append("      while (svgDocument.getElementById('textboxText' + i + number) != null) {").append(eol);
			script.append("        SVGGEN_setVisibility('textboxText' + i + number, showAllState);").append(eol);
			script.append("        SVGGEN_setVisibility('textboxRect' + i + number, showAllState);").append(eol);
			script.append("        number++;").append(eol);
			script.append("      }").append(eol);
			script.append("  }").append(eol);
			script.append("}").append(eol);
		}
//		else if (type.equals(IGraphicTypeConstants.BAR_CHART)) {
//			script.append("  SVGGEN_noValues = newStyles[4] == '0' ? true : false;").append(eol);	
//		}
		else if (!type.equals(IGraphicTypeConstants.METER)) {			
			script.append("var eGroup = document.getElementById(\"exactValues\");").append(eol);
			script.append("if (eGroup != null){").append(eol);
 			script.append("eGroup.setAttribute('visibility', (newStyles[4]=='0'? 'hidden':'visible') );").append(eol);
 	        script.append("}").append(eol);
		}
	
		// update current values if this is not just a preview
		script.append("if (!preview) {for(var i=0; i<6; i++) {SVGGEN_currentValues[i] = newStyles[i];}").append(eol);
		if (cookieName != null) {
			script.append("SVGGEN_storePreferences(SVGGEN_currentValues);").append(eol);
		}
		
		// export the updated preferences, if a variable name is made available
 		if (updatedUserPrefsVarName != null) {			
			script.append("  top.");
			script.append(updatedUserPrefsVarName);
			script.append(" = SVGGEN_getUserPreferences();").append(eol);			
		}	
		script.append("} }").append(eol);
		
		script.append("function SVGGEN_updateFontStyleAll(obj, fontSize, style) {").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    if (obj.getAttribute('id') != null && obj.getAttribute('id').substring(0,16) == 'SVGGEN_axisLabel'){").append(eol);
//		script.append("        obj.getAttribute('id').substring(0,14) == 'SVGGEN_tooltip') {").append(eol);
		script.append("      obj.setAttribute('style','font-size:' + fontSize + 'pt; ' + style);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_updateFontStyleAll(node, fontSize, style);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);

		return script.toString();
	}	
	
	/** 
	 * Generates a function which retrieves user preference styles from cookie
	 *  	
	 * @param name 		the name of the cookie
	 */
	public String generateGetPreferencesFunction(String name) {
		String cookie = name;
		
		script = new StringBuffer("function SVGGEN_getPreferences() {");
		script.append("var value = SVGGEN_get_Cookie(\"");
		script.append(cookie);
		script.append("\");").append(eol);
		script.append("if (value != null) {").append(eol);
		script.append("return value.split(\"&\");").append(eol);
		script.append("} else {").append(eol);
		script.append("return null;}").append(eol);
		script.append("}").append(eol);
			
		return script.toString();
	}
		
	/** 
	 * Generates a function which stores user preference styles in cookie
	 *  	
	 * @param name 		the name of the cookie
	 */
	public String generateStorePreferencesFunction(String name) {
		String cookie = name;
		
		script = new StringBuffer("function SVGGEN_storePreferences(storevalues) {");	
		script.append("var value = '';").append(eol);
		script.append("for (var i = 0; i < storevalues.length -1; i++) {").append(eol);
		script.append("  value += storevalues[i] + \"&\";").append(eol);
		script.append("}").append(eol);
		script.append("value += storevalues[storevalues.length-1];").append(eol);
		script.append("SVGGEN_set_Cookie('");
		script.append(cookie);
		script.append("', value, SVGGEN_expires_date, '/');").append(eol);	
		script.append("}").append(eol);
	
		return script.toString();
	}
	
	/** 
	 * Generates a function to return the current user preferences. The
	 * return value should be treated as a blob.   		
	 */
	public String generateGetUserPreferencesFunction() {
		
		script = new StringBuffer("function SVGGEN_getUserPreferences()");	
		script.append("{var value = '';").append(eol);
		script.append("for (var i = 0; i < SVGGEN_currentValues.length -1; i++) {").append(eol);
		script.append("  value += SVGGEN_currentValues[i] + \",\";").append(eol);
		script.append("}").append(eol);
		script.append("value += SVGGEN_currentValues[SVGGEN_currentValues.length-1];").append(eol);
		script.append("return value;").append(eol);	
		script.append("}").append(eol);
	
		return script.toString();
	}
	/** 
	 * Generates a function which allows the object attributes to
	 * be returned as a string for debugging purposes, for example, in
	 * an "alert".  
	 */
	public String generateInspectFunction(){
		script = new StringBuffer("function SVGGEN_inspect(obj)");
		script.append("{var output=\"\";").append(eol);
        script.append("if(obj==null){").append(eol);
        script.append("return null;} ").append(eol);
        script.append("else{").append(eol);
        script.append("for(var i in obj){").append(eol);
        script.append(" output += i + \" : \" + obj[i] + \"\\n\";}").append(eol);
        script.append("return output;}").append(eol);
        script.append("} ").append(eol);
		return script.toString();
	}
	
	/** 
	 * Generates a function for reading and writing cookies.  
	 */
	public String generateCookieFunctions(){ 
		// note that escape() has been deprecated in ECMAScript v3 and
		// may not work in IE 5.5+ and Netscape 6/Mozilla
		script = new StringBuffer("var SVGGEN_today= new Date();");
		// set expiry date for one year from current date	
 		script.append("var SVGGEN_expires_date= new Date(SVGGEN_today.getTime() + (365 * 24 * 60 * 60 * 1000));").append(eol);
		
		script.append("function SVGGEN_get_Cookie(name){").append(eol);
		// can't access browser DOM in NN - have to use window function calls 
		// hasSVGCookieSupport and get_/set_NNCookie have to be defined in embedding HTML
		// Netscape 6 and Mozilla now support DOM
		script.append("  if ((SVGGEN_isNN && SVGGEN_browserVersion <= 4) && hasSVGCookieSupport) {").append(eol);
		script.append("     return get_NNCookie(name);").append(eol);
		script.append("  }").append(eol);
		script.append("  else if ((SVGGEN_isIE || (SVGGEN_isNN && SVGGEN_browserVersion > 4)) && top.document.cookie != null) {").append(eol);
		script.append("    var start = top.document.cookie.indexOf(name+\"=\");").append(eol);
		script.append("    var len = start+name.length+1;").append(eol);
		script.append("    if ((!start) && (name != top.document.cookie.substring(0,name.length))) return null;").append(eol);
		script.append("    if (start == -1) return null;").append(eol);
		script.append("    var end = top.document.cookie.indexOf(\";\",len);").append(eol);
		script.append("    if (end == -1) end = top.document.cookie.length;").append(eol);
		script.append("    return unescape(top.document.cookie.substring(len,end));").append(eol);
		script.append("  } ").append(eol);
		script.append("  else {").append(eol);
		script.append("     return null;").append(eol);
		script.append("  }").append(eol);
		script.append("} ").append(eol);
			
		script.append("function SVGGEN_set_Cookie(name,value,expires,path,domain,secure){").append(eol);
		// can't access browser DOM in NN - have to use window function calls 
		script.append("  if ((SVGGEN_isNN && SVGGEN_browserVersion <= 4) && hasSVGCookieSupport) {").append(eol);
		script.append("    set_NNCookie(name,value,expires,path,domain,secure);").append(eol);
		script.append("  } ").append(eol);
		script.append("  else if (SVGGEN_isIE || (SVGGEN_isNN && SVGGEN_browserVersion > 4)) { ").append(eol);
		script.append("    top.document.cookie = name + \"=\" +escape(value) + ").append(eol);
		script.append("    ((expires) ? \";expires=\" + expires.toGMTString() : \"\") +").append(eol);
		script.append("    ((path) ? \";path=\" + path : \"\") + ").append(eol);
		script.append("    ((domain) ? \";domain=\" + domain : \"\") + ").append(eol);
		script.append("    ((secure) ? \";secure\" : \"\");" ).append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol); 
		return script.toString(); 
	}
	/** 
	 * Generates a function which returns the Changed Opacity
	 *	
 	 */
	public String generateChangeOpacity()
	{
		script = new StringBuffer("function SVGGEN_ChangeOpacity(id,NewOpacity){").append(eol);;
		script.append(" if (document.getElementById(id)){").append(eol);
		script.append(" var group = 'fill-opacity:'+ NewOpacity + '; stroke: black; stroke-width: 0;';").append(eol);;
		script.append(" document.getElementById(id).setAttribute(\"style\", group);").append(eol);;
		script.append("} ").append(eol);;
		script.append("} ").append(eol);;
		return script.toString();
	}

		//Praful
		//This four java script function can be reduce by 1. Will have to pass four arg to the funcrion	
		// 	Text id/rect id/group id/mouseoverORmouseout
		//Also this will make more general java script function for flyover
		/** 
	 * Generates a function which returns the fly over box for the legent text
	 *	
 	 */
	public String generateFunctionFlyOver()
	{
		script = new StringBuffer("function SVGGEN_FlyOver(id, i, bBoxId){").append(eol);
		script.append("	var forXPosition = svgDocument.getElementById(\"flyOverText\" + id + bBoxId);").append(eol);
		script.append("	var forYPosition = svgDocument.getElementById(\"flyOverText\" + id + 0);").append(eol);
		script.append("	var xbbox;").append(eol);
		script.append("	var ybbox;").append(eol);
		script.append("	for (j=0;j<i;j++)").append(eol);
		script.append(" 	{").append(eol);
		script.append("		var flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);
		script.append("		flyOverText.setAttribute('visibility', 'visible');").append(eol);			
		script.append("	}").append(eol);
		script.append("	if (forXPosition != null)").append(eol);
		script.append(" {").append(eol);
		script.append("   xbbox = forXPosition.getBBox();").append(eol);
		script.append("   ybbox = forYPosition.getBBox();").append(eol);
		script.append("	}").append(eol);
		script.append("	for (j=0;j<i;j++)").append(eol);
		script.append(" 	{").append(eol);
		script.append("		var flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);
		script.append("		if (j != bBoxId)").append(eol);
		script.append(" 	{").append(eol);
		script.append("			flyOverText.setAttribute('x', xbbox.x);").append(eol);	
		script.append("		}").append(eol);
		script.append("			flyOverText.setAttribute('y', ybbox.y + (ybbox.height*(j+1)) + 2*(j+1));").append(eol);	
		script.append("	}").append(eol);
		script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
		script.append(" if (flyOverBoxElement != null && xbbox != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("   flyOverBoxElement.setAttribute('x', xbbox.x - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('y', ybbox.y - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('width', xbbox.width + 6);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('height', (xbbox.height*(i+1))+(2*i));").append(eol);
		script.append(" }").append(eol);
		script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
		script.append(" if (flyOverGroup != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
		script.append(" }").append(eol);
		script.append(" }").append(eol);
		
		
		script.append(("function SVGGEN_FlyOut(id, i, bBoxId, y){"));
		script.append("	var forXYPosition = svgDocument.getElementById(\"flyOverText\" + id + bBoxId);").append(eol);		
		script.append("for (j=0;j<i;j++){").append(eol);
		script.append("	var flyOverText = svgDocument.getElementById(\"flyOverText\" + id + j);").append(eol);	
		script.append("	flyOverText.setAttribute('visibility', 'hidden');").append(eol);	
		script.append("	flyOverText.setAttribute('y', y+(12*j));").append(eol);					
		script.append("}").append(eol);
		script.append("var bbox;").append(eol);
		script.append("	if (forXYPosition != null)").append(eol);
		script.append(" {").append(eol);
		script.append("   bbox = forXYPosition.getBBox();").append(eol);
		script.append("	}").append(eol);
		script.append(" var flyOverBoxElement = svgDocument.getElementById(\"flyOverBox\"  + id);").append(eol);
		script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 2);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 4);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 8);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('height', bbox.height + (12*i));").append(eol);
		script.append(" }").append(eol);
		script.append(" var flyOverGroup = svgDocument.getElementById(\"flyOverGroup\" + id);").append(eol);
		script.append(" if (flyOverGroup != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
		script.append(" }").append(eol);
		script.append(" }").append(eol);
		
		return script.toString();
	}	

		/** 
	 * Generates a function which returns the fly over box for the legent text
	 *	
 	 */
	public String generateFunctionPrefFlyOver()
	{
		script = new StringBuffer("function SVGGEN_PrefFlyOver(){");
		script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
		script.append("flyOverText.setAttribute('visibility', 'visible');").append(eol);
		script.append("var bbox;").append(eol);
		script.append("	if (flyOverText != null)").append(eol);
		script.append(" {").append(eol);
		script.append("   bbox = flyOverText.getBBox();").append(eol);
		script.append("	}").append(eol);
		script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
		script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
		script.append(" }").append(eol);
		script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
		script.append(" if (flyOverGroup != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("  flyOverGroup.setAttribute('visibility', 'visible');").append(eol);
		script.append(" }").append(eol);
		script.append(" }").append(eol);
		
		
		script.append(("function SVGGEN_PrefFlyOut(){"));
		script.append("var flyOverText = svgDocument.getElementById(\"hoverBoxText\");").append(eol);
		script.append("flyOverText.setAttribute('visibility', 'hidden');").append(eol);		
		script.append("var bbox;").append(eol);
		script.append("	if (flyOverText != null)").append(eol);
		script.append(" {").append(eol);
		script.append("   bbox = flyOverText.getBBox();").append(eol);
		script.append("	}").append(eol);
		script.append(" var flyOverBoxElement = svgDocument.getElementById(\"hoverBox\");").append(eol);
		script.append(" if (flyOverBoxElement != null && bbox != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("   flyOverBoxElement.setAttribute('x', bbox.x - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('y', bbox.y - 3);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('width', bbox.width + 6);").append(eol);
		script.append("   flyOverBoxElement.setAttribute('height', bbox.height + 6);").append(eol);
		script.append(" }").append(eol);
		script.append(" var flyOverGroup = svgDocument.getElementById(\"preferencesHoverText\");").append(eol);
		script.append(" if (flyOverGroup != null)").append(eol);
		script.append(" {").append(eol);		
		script.append("  flyOverGroup.setAttribute('visibility', 'hidden');").append(eol);
		script.append(" }").append(eol);
		script.append(" }").append(eol);
		
		return script.toString();
	}	
	
	// ========================= NEW SCRIPTS ================================================================

	/**
	 * Hides and shows tooltips at the mouse pointer
	 * 
	 * @return the ECMAScript
	 */
	public String generateTooltipScripts() {
		script = new StringBuffer();
		
		script.append("function SVGGEN_setToolTipSize(tooltip, x, y, w,h) {").append(eol);
		script.append("  var nodes = tooltip.childNodes;").append(eol);
		script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("    node = nodes.item(i);").append(eol);
		script.append("    if (node.nodeName == 'rect') {").append(eol);
		script.append("      node.setAttribute('x', parseFloat(x) - 3);").append(eol);
		script.append("      node.setAttribute('y', parseFloat(y) - 3);").append(eol);
		script.append("      node.setAttribute('width', parseFloat(w) + 6);").append(eol);
		script.append("      node.setAttribute('height', parseFloat(h) + 6);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_getChildByNodeName(obj, name) {").append(eol);
		script.append("  var nodes = obj.childNodes;").append(eol);
		script.append("  var node;").append(eol);
		script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("    node = nodes.item(i);").append(eol);
		script.append("    if (node.nodeName == name) break;").append(eol);
		script.append("  }").append(eol);
		script.append("  return node;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_showTooltip(evt, tooltipId) {").append(eol);
		script.append("			   //Get text value").append(eol);
		script.append("			   var svgDocument = evt.target.ownerDocument;").append(eol);
		script.append("			   var contentNode = svgDocument.getElementById(tooltipId+'text');").append(eol);
		script.append("			   var text = ' ';").append(eol);
		script.append("			   if (contentNode != null) {").append(eol);
		script.append("			     text = SVGGEN_getChildByNodeName(contentNode, '#text').nodeValue;").append(eol);
		script.append("			   }").append(eol);
		script.append("			   ").append(eol);
		script.append("			   x = evt.clientX;").append(eol);
		script.append("			   y = evt.clientY;").append(eol);
		script.append("			   if (typeof this.group == 'undefined'){").append(eol);
		script.append("			   this.height = 15;").append(eol);
		script.append("			   this.root = svgDocument.getElementById(\"SVGGEN_tooltips\");").append(eol);
		script.append("			   this.xPadding = 5;").append(eol);
		script.append("			   var off = svgDocument.rootElement.currentTranslate;").append(eol);
		script.append("			   var scl = svgDocument.rootElement.currentScale;").append(eol);
		script.append("			   var translateX = (((x+14)-off.x)/scl);").append(eol);
		script.append("			   var translateY = (((y-20)-off.y)/scl);").append(eol);

		script.append("			   var group = new BuildHelper(\"g\");").append(eol);
		script.append("			   group.addToParent(this.root);").append(eol);
		script.append("			   var rectangle = new BuildHelper(\"rect\", ").append(eol);
		script.append("			     {id:\"test\",").append(eol);
		script.append("			      x: 0,").append(eol);
		script.append("			      y: 0,").append(eol);
		script.append("			      height: 15,").append(eol);
		script.append("			      style: \"fill:#FFFFCC;stroke:gray;stroke-width:1;\"").append(eol);
		script.append("			 } );").append(eol);
		script.append("			   ").append(eol);
		script.append("			   rectangle.addToParent(group.element);").append(eol);
		script.append("			   this.text = new BuildHelper(\"text\", ").append(eol);
		script.append("			     {id:\"tooltip\",").append(eol);
		script.append("			      x: this.xPadding,").append(eol);
		script.append("			      y: (15/2+4),").append(eol);
		script.append("			      classType: \"tooltip\"").append(eol);
		script.append("			 },text);").append(eol);
		script.append("			   this.text.addToParent(group.element);").append(eol);
		script.append("			   var itemlength =this.text.element.getComputedTextLength();").append(eol);
		script.append("			   rectangle.element.setAttributeNS(null, \"width\", (itemlength+2*this.xPadding));").append(eol);
		script.append("			   var tooltipHeight = 15;").append(eol);
		script.append("			   var xdiff = 0;").append(eol);
		script.append("			   var chartWidth = SVGGEN_getChartWidth();").append(eol);
		script.append("			   if ((x + itemlength) <= chartWidth) {").append(eol);
		script.append("			        xdiff = translateX;").append(eol);
		script.append("			   }").append(eol);
		script.append("			   else").append(eol);
		script.append("			        xdiff = chartWidth - parseFloat(itemlength+2*this.xPadding);").append(eol);
		script.append("			   var ydiff = translateY;").append(eol);
		script.append("			   if ((y - tooltipHeight ) < 0) {").append(eol);
		script.append("			        ydiff = y + tooltipHeight;").append(eol);
		script.append("			   }").append(eol);
		script.append("			   group.element.setAttributeNS(null, \"transform\", \"translate(\" + xdiff + \",\" + ydiff + \")\");").append(eol);		
		script.append("			  }").append(eol);
		script.append("			  this.group = group;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_hideTooltip(evt, tooltipId) {").append(eol);
		script.append("		   if (typeof this.group != 'undefined'){").append(eol);
		script.append("			  this.group.removeNode();").append(eol);
		script.append("		   	  this.group = undefined;").append(eol);
		script.append("		 } ").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_toggleVisibility(obj, visibility) {").append(eol);
		script.append("  obj.setAttribute('visibility', visibility);").append(eol);
		script.append("  var nodes = obj.childNodes;").append(eol);
		script.append("  for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("    var node = nodes.item(i);").append(eol);
		script.append("    if (node.nodeName == 'rect' || node.nodeName == 'text') {").append(eol);
		script.append("      node.setAttribute('visibility', visibility);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_getChartWidth() {").append(eol);
		script.append("  var boundary = document.getElementById('SVGGEN_boundary');").append(eol);
		script.append("  return boundary.getAttribute('width');").append(eol);
		script.append("}").append(eol);
		
		return script.toString();		
	}
	
	/**
	 * Toggles the visibility on the element with the given ID.  Used for hiding and
	 * showing datasets.  These functions also hide and show the associated dataset
	 * values.
	 * 
	 * @return the ECMAScript
	 */
	public String generateToggleVisibilityDataset() {
		script = new StringBuffer();
		
		script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("function SVGGEN_toggleVisibilityDataset(evt, id) {").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
    	script.append("    var foreobj = svgDoc.getElementById('SVGGEN_plotareaForeground_'+id);");
    	script.append("    if (obj != null) {").append(eol);
		script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
		script.append("      var v2;").append(eol);
		script.append("      if (v1 == 'hidden') {").append(eol);
		script.append("         v2 = 'visible';").append(eol);
		script.append("         SVGGEN_showDatasetValues(obj);").append(eol);
		script.append("      } else {").append(eol);
		script.append("         v2 = 'hidden';").append(eol);
		script.append("         SVGGEN_hideDatasetValues(obj);").append(eol);
		script.append("      }").append(eol);
   		script.append("      if (foreobj != null)");
   		script.append("         foreobj.setAttribute('visibility', v2);");
   		script.append("      obj.setAttribute('visibility', v2);").append(eol);
		script.append("      var useElementGroup = obj.getElementsByTagName('use');").append(eol);
		script.append("      if (useElementGroup != null) {").append(eol);
		script.append("        var v3 = (v2 == 'visible' && SVGGEN_noShapes == false) ? 'visible' : 'hidden';").append(eol);
		script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
		script.append("          useElementGroup.item(j).setAttribute('visibility', v3);").append(eol);
		script.append("        }").append(eol);
		script.append("      }").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_hideDatasetValues(obj) {").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
		script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_hideDatasetValues(node);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_showDatasetValues(obj) {").append(eol);
		script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
		script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_showDatasetValues(node);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();		
	}
	
	/**
	 * Toggles the visibility on the element with the given ID.  Used for hiding and
	 * showing datasets.  These functions also hide and show the associated dataset
	 * values.  This method is specific to scatter charts, it turns off the shadows
	 * when the dataset is hidden
	 * 
	 * @return the ECMAScript
	 */
	public String generateToggleVisibilityDatasetScatter() {
		script = new StringBuffer();
		
		script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("function SVGGEN_toggleVisibilityDataset(evt, id, shadowID) {").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
		script.append("    if (obj != null) {").append(eol);
		script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
		script.append("      var v2;").append(eol);
		script.append("      if (v1 == 'hidden') {").append(eol);
		script.append("         v2 = 'visible';").append(eol);
		script.append("         SVGGEN_showDatasetValues(obj);").append(eol);
		script.append("      } else {").append(eol);
		script.append("         v2 = 'hidden';").append(eol);
		script.append("         SVGGEN_hideDatasetValues(obj);").append(eol);
		script.append("      }").append(eol);
		script.append("      obj.setAttribute('visibility', v2);").append(eol);
		script.append("      var useElementGroup = obj.getElementsByTagName('use');").append(eol);
		script.append("      if (useElementGroup != null) {").append(eol);
		script.append("        if (!SVGGEN_noShapes) {").append(eol);				
		script.append("        for (var j = 0; j < useElementGroup.length; j++) {").append(eol);
		script.append("          if(useElementGroup.item(j).getAttribute('id') == null || useElementGroup.item(j).getAttribute('id').substring(0,18) != 'SVGGEN_shadowShape'){").append(eol);
		script.append("            useElementGroup.item(j).setAttribute('visibility', v2);").append(eol);
		script.append("          }").append(eol);
		script.append("        }").append(eol);
		script.append("        }").append(eol);
		script.append("      }").append(eol);
		script.append("      SVGGEN_toggleVisibilityShadow(evt, shadowID, v2);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_hideDatasetValues(obj) {").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
		script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_hideDatasetValues(node);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_showDatasetValues(obj) {").append(eol);
		script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue') {").append(eol);
		script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_showDatasetValues(node);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();		
	}
	
	/**
	 * Toggles the visibility on the element with the given ID.  Used for hiding and
	 * showing datasets.  These functions also hide and show the associated dataset
	 * values.  This method is specific to bar graphs due the fact that the 
	 * datavalues are moved out of the dataset group at runtime.
	 * 
	 * @return the ECMAScript
	 */
	public String generateToggleVisibilityDatasetBar() {
		script = new StringBuffer();
		
		script.append("var SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("function SVGGEN_toggleVisibilityDataset(evt, id) {").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
    	script.append("    var foreobj = svgDoc.getElementById('SVGGEN_plotareaForeground_'+id);").append(eol);
		script.append("    if (obj != null) {").append(eol);
		script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
		script.append("      var v2;").append(eol);
		script.append("      if (v1 == 'hidden') {").append(eol);
		script.append("         v2 = 'visible';").append(eol);
		script.append("         SVGGEN_showDatasetValues(svgDoc, id);").append(eol);
		script.append("      } else {").append(eol);
		script.append("         v2 = 'hidden';").append(eol);
		script.append("         SVGGEN_hideDatasetValues(svgDoc, id);").append(eol);
		script.append("      }").append(eol);
   		script.append("      if (foreobj != null)").append(eol);
   		script.append("         foreobj.setAttribute('visibility', v2);").append(eol);
		script.append("      obj.setAttribute('visibility', v2);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_hideDatasetValues(obj, datasetID) {").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    var datavalueID = 'SVGGEN_datavalue_' + datasetID + '_';").append(eol);
		script.append("    var len = datavalueID.length;").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,len) == datavalueID) {").append(eol);
		script.append("      obj.setAttribute('visibility', 'hidden');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_hideDatasetValues(node, datasetID);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_showDatasetValues(obj, datasetID) {").append(eol);
		script.append("  if (SVGGEN_dataValuesVisible == false) return;").append(eol);
		script.append("  if (obj.nodeName == 'text') {").append(eol);
		script.append("    var datavalueID = 'SVGGEN_datavalue_' + datasetID + '_';").append(eol);
		script.append("    var len = datavalueID.length;").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,len) == datavalueID) {").append(eol);
		script.append("      obj.setAttribute('visibility', 'visible');").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_showDatasetValues(node, datasetID);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();		
	}
	
	/**
	 * Changes the visibility on the element with the given ID to the specified  
	 * visibility.  Check parents, and do not show the shadows if any parent is set
	 * to 'hidden'.
	 * 
	 * @return the ECMAScript
	 */
	public String generateToggleVisibilityShadow(boolean showShapes) {
		script = new StringBuffer();
		script.append("function SVGGEN_toggleVisibilityShadow(evt, id, visibility) {").append(eol);
		if (!showShapes) 
			script.append("if (SVGGEN_noShapes) return;").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
		script.append("    if (obj != null) {").append(eol);
		script.append("      if (visibility == 'visible') {").append(eol);
		script.append("        var obj1 = obj.parentNode;").append(eol);
		script.append("        while (obj1 != svgDoc) {").append(eol);
		script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
		script.append("          obj1 = obj1.parentNode;").append(eol);
		script.append("        }").append(eol);
		script.append("      }").append(eol);
		script.append("      obj.setAttribute('visibility', visibility);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();		
	}
	
	public String generateBuildHelper(){
		script = new StringBuffer();
		script.append("		function BuildHelper(tag, attrList, text) {").append(eol);
		script.append("			this.tag = tag;").append(eol);
		script.append("			this.attrList = attrList;").append(eol);
		script.append("			this.text       = text;").append(eol);
		script.append("			this.element  = null;").append(eol);
		script.append("			this.textNode = null;").append(eol);
		script.append("		}").append(eol);
		script.append("	").append(eol);
		script.append("		BuildHelper.prototype.addToParent= function(parent) {").append(eol);
		script.append("		       if (!parent) return;").append(eol);
		script.append("			var svgDocument = parent.ownerDocument;").append(eol);
		script.append("			this.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);").append(eol);
		script.append("			").append(eol);
		script.append("			for (var attribute in this.attrList){").append(eol);
		script.append("		          if (attribute == 'classType')").append(eol);
		script.append("		   		     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);").append(eol);
		script.append("		          else").append(eol);
		script.append("				     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);").append(eol);
		script.append("		        }").append(eol);
		script.append("			").append(eol);
		script.append("			if (this.text) {").append(eol);
		script.append("				this.textNode = svgDocument.createTextNode(this.text);").append(eol);
		script.append("				this.element.appendChild(this.textNode);").append(eol);
		script.append("			}").append(eol);
		script.append("			").append(eol);
		script.append("			parent.appendChild(this.element);").append(eol);
		script.append("		};").append(eol);
		script.append("		").append(eol);
		script.append("		BuildHelper.prototype.insertBefore = function(parent, before) {").append(eol);
		script.append("		        if (typeof parent != 'undefined') return;").append(eol);
		script.append("			var svgDocument = parent.ownerDocument;").append(eol);
		script.append("			this.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);").append(eol);
		script.append("			").append(eol);
		script.append("			for (var attribute in this.attrList){").append(eol);
		script.append("		          if (attribute == 'classType')").append(eol);
		script.append("		  		     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);").append(eol);
		script.append("		          else").append(eol);
		script.append("				     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);").append(eol);
		script.append("		        }").append(eol);
		script.append("			").append(eol);
		script.append("			if (this.text) {").append(eol);
		script.append("				this.textNode = svgDocument.createTextNode(this.text);").append(eol);
		script.append("				this.element.appendChild(textNode);").append(eol);
		script.append("			}").append(eol);
		script.append("			").append(eol);
		script.append("			parent.insertBefore(this.element, before);").append(eol);
		script.append("		};").append(eol);
		script.append("		").append(eol);

		script.append("		BuildHelper.prototype.removeNode = function() {").append(eol);
		script.append("			if (this.element) this.element.parentNode.removeChild(this.element);").append(eol);
		script.append("			this.tag = \"\";").append(eol);
		script.append("			this.attrList = null;").append(eol);
		script.append("			this.text = null;").append(eol);
		script.append("			this.element = null;").append(eol);
		script.append("			this.textNode = null;").append(eol);
		script.append("		};").append(eol);
		
		return script.toString();
	}
	/**
	 * Recursively searches for all Text nodes with the ID prefix "SVGGEN_datavalue" and
	 * toggles their visibility.  Check visibility of parents before setting visibility
	 * to 'visible'.
	 * 
	 * @return the ECMAScript
	 */
	public String generateToggleVisibilityDatavalue() {
		script = new StringBuffer();
		
		script.append("function SVGGEN_toggleVisibilityDatavalue(evt, id) {").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
		script.append("    if (obj != null) {").append(eol);
		script.append("      SVGGEN_toggleVisibilityDatavalue2(obj);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_toggleVisibilityDatavalue2(obj, state) {").append(eol);
		script.append("  if (obj.nodeName == 'text' || obj.nodeName == 'use') {").append(eol);
	    script.append("  if((obj.getAttribute('id') != null) && (obj.getAttribute('id').substring(0,16) == 'SVGGEN_datavalue')) {").append(eol);
		script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
		script.append("      var v2 = (v1 == 'hidden') ? 'visible' : 'hidden';").append(eol);
		script.append("      if (state != null) v2 = state;").append(eol);
		script.append("      if (v2 == 'visible') {").append(eol);
		script.append("        var obj1 = obj.parentNode;").append(eol);
		script.append("        while (obj1 != document) {").append(eol);
		script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
		script.append("          obj1 = obj1.parentNode;").append(eol);
		script.append("        }").append(eol);
		script.append("        SVGGEN_dataValuesVisible = true;").append(eol);
		script.append("      } else {").append(eol);
		script.append("        SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("      }").append(eol);
		script.append("      obj.setAttribute('visibility', v2);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_toggleVisibilityDatavalue2(node, state);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);

		return script.toString();		
	}
	
	public String generateMoveNode() {
		script = new StringBuffer();
		
/*		script.append("function SVGGEN_moveNode(evt, destination) {").append(eol);
		script.append("  var node = evt.getTarget();").append(eol);
		script.append("  var originalParent = node.getParentNode();").append(eol);
		script.append("  var destNode = evt.target.ownerDocument.getElementById(destination);").append(eol);
		script.append("  destNode.appendChild(originalParent.removeChild(node));").append(eol);
		script.append("}").append(eol); */
		script.append("function SVGGEN_moveNode(source, destination) {").append(eol);
		script.append("  var node = document.getElementById(source);").append(eol);
		script.append("  if (node != null) {").append(eol);
		script.append("    var originalParent = node.parentNode;").append(eol);
		script.append("    var destNode = document.getElementById(destination);").append(eol);
		script.append("    destNode.appendChild(originalParent.removeChild(node));").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();	
	}

	/**
	 * Generates scripts to pop up an alert window with Accessibility text when
	 * "t" and "d" are pressed.
	 * 
	 * @return the ECMAScript
	 */
	public String generateKeyPressHandler() {
		script = new StringBuffer();

		script.append("var SVGGEN_g_svgdoc = null;").append(eol);
		script.append("var SVGGEN_g_svgnode = null;").append(eol);
		script.append("var SVGGEN_g_nextElement = 0;").append(eol);
		script.append("var SVGGEN_g_curNode = null;").append(eol);
		script.append("function SVGGEN_displayMessage (msg)").append(eol);
		script.append("{").append(eol);
		script.append("  alert(msg);").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_playTitle (node)").append(eol);
		script.append("{").append(eol);
		script.append("  if (!node)").append(eol);
		script.append("    SVGGEN_displayMessage ('> No caption found for title!');").append(eol);
		script.append("  else {").append(eol);
		script.append("    var titleText = node.getFirstChild().getNodeValue();").append(eol);
		script.append("    if (SVGGEN_findDesc(SVGGEN_g_curNode))").append(eol);
		script.append("      SVGGEN_displayMessage (titleText + '\\n> Press \"D\" for description.');").append(eol);
		script.append("    else").append(eol);
		script.append("      SVGGEN_displayMessage (titleText);").append(eol);
		script.append("   }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_playDesc ()").append(eol);
		script.append("{").append(eol);
		script.append("  var descnode = null;").append(eol);
		script.append("  if (SVGGEN_g_curNode)").append(eol);
		script.append("    descnode = SVGGEN_findDesc (SVGGEN_g_curNode);").append(eol);
		script.append("  if (!descnode)").append(eol);
		script.append("    SVGGEN_displayMessage ('> No caption found for description!');").append(eol);
		script.append("  else {").append(eol);
		script.append("    var titleText = descnode.getFirstChild().getNodeValue();").append(eol);
		script.append("    SVGGEN_displayMessage (titleText);").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_playNext (startOfSearch)").append(eol);
		script.append("{").append(eol);
		script.append("  if (SVGGEN_g_nextElement == 0) {").append(eol);
		script.append("    var titlenode = SVGGEN_findTitle (SVGGEN_g_svgnode);").append(eol);
		script.append("    if (!titlenode) {").append(eol);
		script.append("      SVGGEN_g_nextElement++;").append(eol);
		script.append("      return SVGGEN_playNext(true);").append(eol);
		script.append("    }").append(eol);
		script.append("  } else {").append(eol);
		script.append("    var titlenode;").append(eol);
		script.append("    if (SVGGEN_g_nextElement == 1)").append(eol);
		script.append("      titlenode = SVGGEN_findNextTitle (SVGGEN_youngestChild(SVGGEN_g_svgnode));").append(eol);
		script.append("    else").append(eol);
		script.append("      titlenode = SVGGEN_findNextTitle (SVGGEN_nextNode(SVGGEN_g_curNode));").append(eol);
		script.append("    if (!titlenode) {").append(eol);
		script.append("      if (startOfSearch) {").append(eol);
		script.append("        SVGGEN_displayMessage ('> No captions found in document!');").append(eol);
		script.append("        SVGGEN_g_curNode = null;").append(eol);
		script.append("        return false;").append(eol);
		script.append("      } else {").append(eol);
		script.append("        SVGGEN_g_nextElement = 0;").append(eol);
		script.append("        return SVGGEN_playNext(startOfSearch);").append(eol);
		script.append("      }").append(eol);
		script.append("    }").append(eol);
		script.append("    if (titlenode.getParentNode() == SVGGEN_g_svgnode) {").append(eol);
		script.append("      SVGGEN_displayMessage ('> No more captions in document.');").append(eol);
		script.append("      SVGGEN_g_curNode = null;").append(eol);
		script.append("      SVGGEN_g_nextElement = 0;").append(eol);
		script.append("      return false;").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  SVGGEN_g_curNode = titlenode.getParentNode();").append(eol);
		script.append("  SVGGEN_playTitle (titlenode);").append(eol);
		script.append("  SVGGEN_g_nextElement++;").append(eol);
		script.append("  return true;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_findDesc (node)").append(eol);
		script.append("{").append(eol);
		script.append("  var kids = node.childNodes;").append(eol);
		script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
		script.append("    var kid = kids.item(i);").append(eol);
		script.append("    if (kid.getNodeType() == 1  &&  kid.getTagName()+'' == 'desc')").append(eol);
		script.append("      return kid;").append(eol);
		script.append("  }").append(eol);
		script.append("  return null;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_findTitle (node)").append(eol);
		script.append("{").append(eol);
		script.append("  var kids = node.childNodes;").append(eol);
		script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
		script.append("    var kid = kids.item(i);").append(eol);
		script.append("    if (kid.getNodeType() == 1  &&  kid.getTagName()+'' == 'title')").append(eol);
		script.append("      return kid;").append(eol);
		script.append("  }").append(eol);
		script.append("  return null;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_youngestChild (node)").append(eol);
		script.append("{").append(eol);
		script.append("  var kids = node.childNodes;").append(eol);
		script.append("  for (var i = 0;  i < kids.length;  i++) {").append(eol);
		script.append("    var kid = kids.item(i);").append(eol);
		script.append("    if (kid.getNodeType() == 1)").append(eol);
		script.append("      return SVGGEN_youngestChild (kid);").append(eol);
		script.append("    }").append(eol);
		script.append("  return node;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_nextNode (startNode)").append(eol);
		script.append("{").append(eol);
		script.append("  var node = startNode.getNextSibling();").append(eol);
		script.append("  while (node) {").append(eol);
		script.append("    if (node.getNodeType() == 1) {").append(eol);
		script.append("      return SVGGEN_youngestChild(node);").append(eol);
		script.append("    }").append(eol);
		script.append("    node = node.getNextSibling();").append(eol);
		script.append("  }").append(eol);
		script.append("  if (startNode.getParentNode())").append(eol);
		script.append("    return startNode.getParentNode();").append(eol);
		script.append("  return null;").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_findNextTitle (startNode)").append(eol);
		script.append("{").append(eol);
		script.append("  var node = SVGGEN_findTitle (startNode);").append(eol);
		script.append("  if (node)").append(eol);
		script.append("    return node;").append(eol);
		script.append("  node = SVGGEN_nextNode (startNode);").append(eol);
		script.append("  if (!node)").append(eol);
		script.append("    return null;").append(eol);
		script.append("  else").append(eol);
		script.append("    return SVGGEN_findNextTitle (node);").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_handle_keypress (event)").append(eol);
		script.append("{").append(eol);
		script.append("  SVGGEN_g_svgnode = event.target.ownerDocument;").append(eol);
		script.append("  var key = event.getCharCode();").append(eol);
		script.append("  var keychar = String.fromCharCode(key);").append(eol);
		script.append("  switch (keychar) {").append(eol);
		script.append("    case 't':").append(eol);
		script.append("    case 'T':").append(eol);
		script.append("      SVGGEN_playNext (false);").append(eol);
		script.append("      break;").append(eol);
		script.append("    case 'd':").append(eol);
		script.append("    case 'D':").append(eol);
		script.append("      SVGGEN_playDesc();").append(eol);
		script.append("      break;").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		
		return script.toString();	
	}
	
	/**
	 * Generates scripts for tooltips and showing/hiding data values on pie charts.
	 * Note: Data values should be hidden prior to changing the pie global variables.
	 * 
	 * @return the ECMAScript
	 */
	public String generatePieScripts() {
		script = new StringBuffer();

//		script.append("var SVGGEN_pie_showValue = true;").append(eol);
//		script.append("var SVGGEN_pie_showPercent = true;").append(eol);
		script.append("function SVGGEN_showTooltipPie(evt, tooltipNum) {").append(eol);
		script.append("  if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
		script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_exactValue' + tooltipNum);").append(eol);
		script.append("  } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
		script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_percentValue' + tooltipNum);").append(eol);
		script.append("  } else {").append(eol);
		script.append("    SVGGEN_showTooltip(evt, 'SVGGEN_tooltip_bothValues' + tooltipNum);").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_hideTooltipPie(evt, tooltipNum) {").append(eol);
		script.append("  if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
		script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_exactValue' + tooltipNum);").append(eol);
		script.append("  } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
		script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_percentValue' + tooltipNum);").append(eol);
		script.append("  } else {").append(eol);
		script.append("    SVGGEN_hideTooltip(evt, 'SVGGEN_tooltip_bothValues' + tooltipNum);").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_toggleVisibilityDatavaluePie(evt, id) {").append(eol);
		script.append("  var svgDoc = evt.target.ownerDocument;").append(eol);
		script.append("  if (svgDoc != null) {").append(eol);
		script.append("    var obj = svgDoc.getElementById(id);").append(eol);
		script.append("    if (obj != null) {").append(eol);
		script.append("      SVGGEN_toggleVisibilityDatavaluePie2(obj);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);
		script.append("function SVGGEN_toggleVisibilityDatavaluePie2(obj, state) {").append(eol);
		script.append("  if (obj.nodeName == 'text' || obj.nodeName == 'use') {").append(eol);
		script.append("    var dataValueName;").append(eol);
		script.append("    if (SVGGEN_values && !SVGGEN_percents) {").append(eol);
		script.append("      dataValueName = 'SVGGEN_datavalue_exac';").append(eol);
		script.append("    } else if (!SVGGEN_values && SVGGEN_percents) {").append(eol);
		script.append("      dataValueName = 'SVGGEN_datavalue_perc';").append(eol);
		script.append("    } else {").append(eol);
		script.append("      dataValueName = 'SVGGEN_datavalue_both';").append(eol);
		script.append("    }").append(eol);
		script.append("    if (obj.getAttribute('id').substring(0,21) == dataValueName || ").append(eol);
		script.append("        obj.getAttribute('id').substring(0,21) == 'SVGGEN_datavalue_tick') {").append(eol);
		script.append("      var v1 = obj.getAttribute('visibility');").append(eol);
		script.append("      var v2 = (v1 == 'hidden') ? 'visible' : 'hidden';").append(eol);
		script.append("      if (state != null) { v2 = state; }").append(eol);
		script.append("      if (v2 == 'visible') {").append(eol);
		script.append("        var obj1 = obj.parentNode;").append(eol);
		script.append("        while (obj1 != document) {").append(eol);
		script.append("          if (obj1.getAttribute('visibility') == 'hidden') return;").append(eol);
		script.append("          obj1 = obj1.parentNode;").append(eol);
		script.append("        }").append(eol);
		script.append("        SVGGEN_dataValuesVisible = true;").append(eol);
		script.append("      } else {").append(eol);
		script.append("        SVGGEN_dataValuesVisible = false;").append(eol);
		script.append("      }").append(eol);
		script.append("      obj.setAttribute('visibility', v2);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("  else {").append(eol);
		script.append("    var nodes = obj.childNodes;").append(eol);
		script.append("    var node;").append(eol);
		script.append("    for (var i=0; i<nodes.length; i++) {").append(eol);
		script.append("      node = nodes.item(i);").append(eol);
		script.append("      SVGGEN_toggleVisibilityDatavaluePie2(node, state);").append(eol);
		script.append("    }").append(eol);
		script.append("  }").append(eol);
		script.append("}").append(eol);

		return script.toString();	
	}

	public String generateRegenInit() {
		script = new StringBuffer();
		script.append("		SVGGEN_regen();").append(eol);
		script.append("		alert(xpts);").append(eol);
		return script.toString();	
	}
		
	public String generateRegen() {
		script = new StringBuffer();
		script.append("var incl = null;").append(eol);
		script.append("function SVGGEN_regen()").append(eol);
		script.append("{").append(eol);
		script.append("	if ((incl == null) || (incl.length <= 0)) {").append(eol);
		script.append("		return;").append(eol);
		script.append("	}").append(eol);
		script.append("	if ((xpts == null) || (xpts.length <= 0)) {").append(eol);
		script.append("		return;").append(eol);
		script.append("	}").append(eol);		
		script.append("	var lstl = new Array(xpts.length);").append(eol);
		script.append("	var thsl = new Array(xpts.length);").append(eol);
		script.append("	var yTotal = new Array(xpts.length);").append(eol);
		script.append("	for( i=0;i<xpts.length;i++ ) {").append(eol);
		script.append("		lstl[i] = yBasePoint;").append(eol);
		script.append("    	thsl[i] = yBasePoint;").append(eol);
		script.append("    	yTotal[i] = 0.0;").append(eol);
		script.append("	}").append(eol);
		script.append("	for( i=1;i<=incl.length;i++ ) {").append(eol);
		script.append("		j = i - 1;").append(eol);
		script.append("		var arE = document.getElementById('SVGGEN_poly' + j);").append(eol);
		script.append("		var lnE = document.getElementById('SVGGEN_lineGroup' + j);").append(eol);
		script.append("		var nodes = lnE.childNodes;").append(eol);
		script.append("		var dSetE = document.getElementById('SVGGEN_dataColour' + (j));").append(eol);
		script.append("		var dSetNodes = dSetE.childNodes;").append(eol);
		script.append("	").append(eol);
		script.append("		if (arE == null)").append(eol);
		script.append("		continue;").append(eol);
		script.append("	").append(eol);
		script.append("		if( incl[i-1] ) {").append(eol);
		script.append("			var ypts = eval('ypts' + i );").append(eol);
		script.append("			var width = eval('width' + i );").append(eol);
		script.append("			var height = eval('height' + i );").append(eol);
		script.append("			var nlst = '';").append(eol);
		script.append("			for(j=0;j<ypts.length;j++) {").append(eol);
		script.append("				if(i==1){").append(eol);
		script.append("					if(linear){").append(eol);
		script.append("						thsl[j] = ypts[j];").append(eol);
		script.append("					}else{").append(eol);
		script.append("						yTotal[j] = ypts[j];").append(eol);
		script.append("						if(ypts[j] == 0.0){").append(eol);
		script.append("							thsl[j] = SVGGEN_getCoordinate(linear, minBase, max_coor, min_coor, max, min);").append(eol);
		script.append("						}else{").append(eol);
		script.append("							thsl[j] = SVGGEN_getCoordinate(linear, ypts[j], max_coor, min_coor, max, min);").append(eol);
		script.append("						}").append(eol);
		script.append("					}").append(eol);		
		script.append("				}else{").append(eol);
		script.append("					if(linear){").append(eol);
		script.append("						thsl[j] = lstl[j] - ypts[j] ; ").append(eol);
		script.append("					}else{").append(eol);
		script.append("						yTotal[j] += ypts[j];").append(eol);
		script.append("						if(ypts[j] == 0.0){").append(eol);
		script.append("							thsl[j] = SVGGEN_getCoordinate(linear, minBase, max_coor, min_coor, max, min);").append(eol);
		script.append("						}else{").append(eol);
		script.append("							thsl[j] = SVGGEN_getCoordinate(linear, yTotal[j], max_coor, min_coor, max, min);").append(eol);
		script.append("						}").append(eol);
		script.append("					}").append(eol);		
		script.append("				}").append(eol);
		script.append("				nlst += xpts[j] + ',' + thsl[j] + ' ';").append(eol);
		script.append("				if(j < ypts.length && j > 1){").append(eol);
		script.append("					for (var n=0; n<nodes.length; n++) {").append(eol);
		script.append("						var node = nodes.item(n);").append(eol);
		script.append("						if (node.nodeName == 'polyline'){").append(eol);
		script.append("							if (node.getAttribute('id') == 'SVGGEN_Line' + (j-1)) {").append(eol);
		script.append("								node.setAttribute('points',xpts[j-1] + ' ' + thsl[j-1] + ', ' + xpts[j] + ' ' + thsl[j]);").append(eol);
		script.append("							}").append(eol);
		script.append("						}").append(eol);
		script.append("					}").append(eol);
		script.append("					for (var n=0; n<dSetNodes.length; n++) {").append(eol);
		script.append("						var node = dSetNodes.item(n);").append(eol);
		script.append("						if (node.nodeName == 'g'){").append(eol);
		script.append("							if (node.getAttribute('id') == 'SVGGEN_pointGroupWrapper' + (j-1)) {").append(eol);
		script.append("								var cNode = node.childNodes;").append(eol);
		script.append("								//alert(node.getAttribute('id'));").append(eol);
		script.append("								for (var m=0; m<cNode.length; m++) {").append(eol);
		script.append("									var nodeC = cNode.item(m);").append(eol);
		script.append("									if (nodeC.nodeName == 'text'){").append(eol);
		script.append("										nodeC.setAttribute('x',(xpts[j-1] + 5));").append(eol);
		script.append("										nodeC.setAttribute('y',thsl[j-1]);").append(eol);
		script.append("									}").append(eol);
		script.append("									if (nodeC.nodeName == 'g'){").append(eol);
		script.append("										var ccNode = nodeC.childNodes;").append(eol);
		script.append("										for (var l=0; l<ccNode.length; l++) {").append(eol);
		script.append("											var nodeCC = ccNode.item(l);").append(eol);
		script.append("											if (nodeCC.nodeName == 'use'){").append(eol);
		script.append("												if(nodeCC.getAttribute('xlink:href') == '#SVGGEN_holeshape'){").append(eol);
		script.append("													nodeCC.setAttribute('transform', 'translate(' + (xpts[j-1]-2.8 ) + ',' + (thsl[j-1]-2.8) + ')');").append(eol);
		script.append("												}else{").append(eol);
		script.append("													nodeCC.setAttribute('transform', 'translate(' + (xpts[j-1]- width[j-2]) + ',' + (thsl[j-1] - height[j-2]) + ')');").append(eol);
		script.append("												}").append(eol);
		script.append("											}").append(eol);
		script.append("										}").append(eol);
		script.append("									}").append(eol);
		script.append("								}").append(eol);
		script.append("							}").append(eol);
		script.append("						}").append(eol);
		script.append("					}").append(eol);		
		script.append("				}").append(eol);
		script.append("			}").append(eol);
		script.append("			for(j=ypts.length-1;j>=0;j--) {").append(eol);
		script.append("				if(i==1){").append(eol);
		script.append("					nlst += xpts[j] + ',' + lstl[j] + ' ';").append(eol);
		script.append("				}else{").append(eol);
		script.append("					nlst += xpts[j] + ',' + lstl[j] + ' ';").append(eol);
		script.append("				}").append(eol);
		script.append("			}").append(eol);
		script.append("			arE.setAttribute('points',nlst);").append(eol);
		script.append("			for(j=0;j<thsl.length;j++) {").append(eol);
		script.append("				lstl[j] = thsl[j];").append(eol);
		script.append("			}").append(eol);
		script.append("		}").append(eol);
		script.append("	}").append(eol);
		script.append("} ").append(eol);

		return script.toString();	
	}
	
	public String generateTakeOut() {
		script = new StringBuffer();
	
		script.append("		function SVGGEN_takeOut(item) {").append(eol);
		script.append("			incl[item-1] = false;").append(eol);
		script.append("			SVGGEN_regen();").append(eol);
		script.append("		}").append(eol);
	
		return script.toString();	
	}
	
	public String generatePutIn() {
		script = new StringBuffer();
	
		script.append("		function SVGGEN_putIn(item) {").append(eol);
		script.append("			incl[item-1] = true;").append(eol);
		script.append("			SVGGEN_regen();").append(eol);
		script.append("		}").append(eol);
	
		return script.toString();	
	}	

	public String generateToggle() {
		script = new StringBuffer();
	
		script.append("		function SVGGEN_toggle(item) {").append(eol);

		script.append("			if( incl[item-1] ) {").append(eol);
		script.append("				SVGGEN_takeOut(item);").append(eol);
		script.append("			}").append(eol);
		script.append("				else {").append(eol);
		script.append("				SVGGEN_putIn(item);").append(eol);
		script.append("			}").append(eol);

		script.append("		}").append(eol);
	
		return script.toString();	
	}

	/**
		 * Calculate coordinate in linear/log scale
	 */
		
	public String generateGetCoordinateFunction() {
		//alert(getCoordinate('false', 1.0, 4.0, 100, 10, 1));
		script = new StringBuffer();	
		script.append("	function SVGGEN_getCoordinate(linear, value, max_coor, min_coor, max, min) {").append(eol);
		script.append("		var plotvalue;").append(eol);
		script.append("		var coord;").append(eol);
		script.append("		if (linear == 'true') {").append(eol);
		script.append("			plotvalue = value;").append(eol);
		script.append("		} else {").append(eol);
		script.append("			plotvalue = Math.log(value) / Math.log(10);").append(eol);
		script.append("		}").append(eol);
		script.append("		coord = (plotvalue - max) / (min - max) * (min_coor - max_coor) + max_coor;").append(eol);
		script.append("		return coord;").append(eol);
		script.append("	}").append(eol);
		return script.toString();	
	}
}
