/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphArea.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphArea.java,v 1.1 2005/03/30 08:26:40 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;


/**
 * 
 * 
 * $Revision: 1.1 $
 */
public abstract class GraphArea extends Part implements IGraphicTypeConstants {

	protected SVGShapes shapes = null;
	protected SVGColorPalettes palettes = null;

	/**
	 * An object for retriving translated text
	 */
	protected NLString nls;
	
	/**
	 * Constructor
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 */
	public GraphArea(Chart input, double x, double y, double width, double height) {
		super(input, x, y, width, height);
		
		this.input = input;
		setXCoordinate(Double.toString(x));
		setYCoordinate(Double.toString(y));
		setWidth(Double.toString(width));
		setHeight(Double.toString(height));
	}
	
	/**
	 * Sets the NLString object to retrive translated text
	 * @param nls
	 */
	public void setNLString(NLString nls) {
		this.nls = nls;
	}
	
	/**
	 * Return an instance of a subclass given the chart type, and other necessary information.
	 * @param input
	 * @param isLTR
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @param palettes
	 * @param shapes
	 * @return
	 */
	public static GraphArea getInstance(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, SVGShapes shapes) {
		if (input.getType().equals(IGraphicTypeConstants.LINE_CHART) ||
			input.getType().equals(IGraphicTypeConstants.AREA_CHART) ||
			input.getType().equals(IGraphicTypeConstants.SCATTER_CHART)) {
			return new GraphAreaLine(input, isLTR, x, y, width, height, palettes, shapes);
		}else if (input.getType().equals(IGraphicTypeConstants.STACK_AREA_CHART)){	
			return new GraphAreaStackArea(input, isLTR, x, y, width, height, palettes, shapes);
		}else if (input.getType().equals(IGraphicTypeConstants.VBAR_CHART3D)){	
			return new GraphAreaBar3D(input, isLTR, x, y, width, height, palettes, POSITION_SOUTH);
		}else if (input.getType().equals(IGraphicTypeConstants.HBAR_CHART3D)){	
			return new GraphAreaBar3D(input, isLTR, x, y, width, height, palettes, POSITION_WEST);	
		}else if (input.getType().equals(IGraphicTypeConstants.VSTACKBAR_CHART3D)){	
			return new GraphAreaStackBar3D(input, isLTR, x, y, width, height, palettes, POSITION_SOUTH);
		}else if (input.getType().equals(IGraphicTypeConstants.HSTACKBAR_CHART3D)){	
			return new GraphAreaStackBar3D(input, isLTR, x, y, width, height, palettes, POSITION_WEST);	
		}else if (input.getType().equals(IGraphicTypeConstants.VBAR_CHART)){	
			return new GraphAreaBar(input, isLTR, x, y, width, height, palettes, POSITION_SOUTH);
		}else if (input.getType().equals(IGraphicTypeConstants.HBAR_CHART)){	
			return new GraphAreaBar(input, isLTR, x, y, width, height, palettes, POSITION_WEST);	
		}else if (input.getType().equals(IGraphicTypeConstants.VSTACKBAR_CHART)){	
			return new GraphAreaStackBar(input, isLTR, x, y, width, height, palettes, POSITION_SOUTH);
		}else if (input.getType().equals(IGraphicTypeConstants.HSTACKBAR_CHART)){	
			return new GraphAreaStackBar(input, isLTR, x, y, width, height, palettes, POSITION_WEST);	
		}else if (input.getType().equals(IGraphicTypeConstants.PIE_CHART)){	
			return new GraphAreaPie(input, x, y, width, height, palettes);			
		}else if (input.getType().equals(IGraphicTypeConstants.PIE_CHART3D)){	
			return new GraphAreaPie3D(input, x, y, width, height, palettes);			
		}else if (input.getType().equals(IGraphicTypeConstants.METER)){	
			return new GraphAreaMeter(input, x, y, width, height);
		}else {
			return null;
		} 
	}
}
