/* ***********************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GraphAreaBar.java,v 1.2 2005/06/10 17:47:09 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

 
 
/**

 *
 * <code>GraphAreaBar</code> is class to add bar graph area in bar chart. 
 * $Revision: 1.2 $  
 */

public class GraphAreaBar extends GraphAreaXY {
	static final long serialVersionUID = 968046354675613529L;
	/**
	 * @param input
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @param palettes
	 * @param POSITION
	 */
	public GraphAreaBar(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, String POSITION) {
		super(input, isLTR, x, y, width, height);
		this.palettes = palettes;
		indepAxisPosition = POSITION;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGPartXYGraphArea#getPlotArea()
	 */
	protected PlotArea getPlotArea(double x, double y, double width, double height) {
		PlotAreaBar plotarea = new PlotAreaBar(input, isLTR, x, y, width, height, palettes, indepAxisPosition, useCategories, nls);		
		if (useCategories) {
			plotarea.setPrimaryDataSets(primaryDataSets);
			plotarea.setSecondaryDataSets(secondaryDataSets);
			plotarea.setPrimaryDepAxis(primaryDepAxis);
			plotarea.setSecondaryDepAxis(secondaryDepAxis);
			plotarea.setIndepAxis((AxisCategory)indepAxis);
		}
		return plotarea;
	}

}
